/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.condition;

import java.util.ArrayList;
import java.util.Arrays;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.io.Resource;
import org.springframework.core.type.AnnotatedTypeMetadata;

public abstract class ResourceCondition
extends SpringBootCondition {
    private final String name;
    private final String prefix;
    private final String propertyName;
    private final String[] resourceLocations;

    protected ResourceCondition(String name, String prefix, String propertyName, String ... resourceLocations) {
        this.name = name;
        this.prefix = prefix.endsWith(".") ? prefix : prefix + ".";
        this.propertyName = propertyName;
        this.resourceLocations = resourceLocations;
    }

    @Override
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        RelaxedPropertyResolver resolver = new RelaxedPropertyResolver(context.getEnvironment(), this.prefix);
        if (resolver.containsProperty(this.propertyName)) {
            return ConditionOutcome.match(this.startConditionMessage().foundExactly("property " + this.prefix + this.propertyName));
        }
        return this.getResourceOutcome(context, metadata);
    }

    protected ConditionOutcome getResourceOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        ConditionMessage message;
        ArrayList<String> found = new ArrayList<String>();
        for (String location : this.resourceLocations) {
            Resource resource = context.getResourceLoader().getResource(location);
            if (resource == null || !resource.exists()) continue;
            found.add(location);
        }
        if (found.isEmpty()) {
            message = this.startConditionMessage().didNotFind("resource", "resources").items(ConditionMessage.Style.QUOTE, Arrays.asList(this.resourceLocations));
            return ConditionOutcome.noMatch(message);
        }
        message = this.startConditionMessage().found("resource", "resources").items(ConditionMessage.Style.QUOTE, found);
        return ConditionOutcome.match(message);
    }

    protected final ConditionMessage.Builder startConditionMessage() {
        return ConditionMessage.forCondition("ResourceCondition", "(" + this.name + ")");
    }
}

