/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.history;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.springframework.data.history.Revision;
import org.springframework.util.Assert;

public class Revisions<N extends Number, T>
implements Iterable<Revision<N, T>> {
    private final List<Revision<N, T>> revisions;
    private final boolean latestLast;

    public Revisions(List<? extends Revision<N, T>> revisions) {
        this(revisions, true);
    }

    private Revisions(List<? extends Revision<N, T>> revisions, boolean latestLast) {
        Assert.notNull(revisions, "Revisions must not be null!");
        this.revisions = new ArrayList<Revision<N, T>>(revisions);
        this.latestLast = latestLast;
        Collections.sort(this.revisions);
        if (!latestLast) {
            Collections.reverse(this.revisions);
        }
    }

    public Revision<N, T> getLatestRevision() {
        int index = this.latestLast ? this.revisions.size() - 1 : 0;
        return this.revisions.get(index);
    }

    public Revisions<N, T> reverse() {
        ArrayList<Revision<N, T>> result = new ArrayList<Revision<N, T>>(this.revisions);
        Collections.reverse(result);
        return new Revisions<N, T>(result, !this.latestLast);
    }

    @Override
    public Iterator<Revision<N, T>> iterator() {
        return this.revisions.iterator();
    }

    public List<Revision<N, T>> getContent() {
        return Collections.unmodifiableList(this.revisions);
    }
}

