/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.web;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.core.MethodParameter;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.HateoasPageableHandlerMethodArgumentResolver;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.ResourceAssembler;
import org.springframework.hateoas.ResourceSupport;
import org.springframework.hateoas.UriTemplate;
import org.springframework.hateoas.core.EmbeddedWrapper;
import org.springframework.hateoas.core.EmbeddedWrappers;
import org.springframework.util.Assert;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class PagedResourcesAssembler<T>
implements ResourceAssembler<Page<T>, PagedResources<Resource<T>>> {
    private final HateoasPageableHandlerMethodArgumentResolver pageableResolver;
    private final UriComponents baseUri;
    private final EmbeddedWrappers wrappers = new EmbeddedWrappers(false);
    private boolean forceFirstAndLastRels = false;

    public PagedResourcesAssembler(HateoasPageableHandlerMethodArgumentResolver resolver, UriComponents baseUri) {
        this.pageableResolver = resolver == null ? new HateoasPageableHandlerMethodArgumentResolver() : resolver;
        this.baseUri = baseUri;
    }

    public void setForceFirstAndLastRels(boolean forceFirstAndLastRels) {
        this.forceFirstAndLastRels = forceFirstAndLastRels;
    }

    public PagedResources<Resource<T>> toResource(Page<T> entity) {
        return this.toResource(entity, new SimplePagedResourceAssembler());
    }

    public PagedResources<Resource<T>> toResource(Page<T> page, Link selfLink) {
        return this.toResource(page, new SimplePagedResourceAssembler(), selfLink);
    }

    public <R extends ResourceSupport> PagedResources<R> toResource(Page<T> page, ResourceAssembler<T, R> assembler) {
        return this.createResource(page, assembler, null);
    }

    public <R extends ResourceSupport> PagedResources<R> toResource(Page<T> page, ResourceAssembler<T, R> assembler, Link link) {
        Assert.notNull((Object)link, "Link must not be null!");
        return this.createResource(page, assembler, link);
    }

    public PagedResources<?> toEmptyResource(Page<?> page, Class<?> type, Link link) {
        Assert.notNull(page, "Page must must not be null!");
        Assert.isTrue(!page.hasContent(), "Page must not have any content!");
        Assert.notNull(type, "Type must not be null!");
        PagedResources.PageMetadata metadata = PagedResourcesAssembler.asPageMetadata(page);
        EmbeddedWrapper wrapper = this.wrappers.emptyCollectionOf(type);
        List<EmbeddedWrapper> embedded = Collections.singletonList(wrapper);
        return this.addPaginationLinks(new PagedResources(embedded, metadata, new Link[0]), page, link);
    }

    @Deprecated
    public Link appendPaginationParameterTemplates(Link link) {
        Assert.notNull((Object)link, "Link must not be null!");
        return this.createLink(new UriTemplate(link.getHref()), null, link.getRel());
    }

    protected <R extends ResourceSupport, S> PagedResources<R> createPagedResource(List<R> resources, PagedResources.PageMetadata metadata, Page<S> page) {
        Assert.notNull(resources, "Content resources must not be null!");
        Assert.notNull((Object)metadata, "PageMetadata must not be null!");
        Assert.notNull(page, "Page must not be null!");
        return new PagedResources(resources, metadata, new Link[0]);
    }

    private <S, R extends ResourceSupport> PagedResources<R> createResource(Page<S> page, ResourceAssembler<S, R> assembler, Link link) {
        Assert.notNull(page, "Page must not be null!");
        Assert.notNull(assembler, "ResourceAssembler must not be null!");
        ArrayList<ResourceSupport> resources = new ArrayList<ResourceSupport>(page.getNumberOfElements());
        for (Object element : page) {
            resources.add(assembler.toResource(element));
        }
        PagedResources resource = this.createPagedResource(resources, PagedResourcesAssembler.asPageMetadata(page), page);
        return this.addPaginationLinks(resource, page, link);
    }

    private <R> PagedResources<R> addPaginationLinks(PagedResources<R> resources, Page<?> page, Link link) {
        boolean isNavigable;
        UriTemplate base = this.getUriTemplate(link);
        boolean bl = isNavigable = page.hasPrevious() || page.hasNext();
        if (isNavigable || this.forceFirstAndLastRels) {
            resources.add(this.createLink(base, new PageRequest(0, page.getSize(), page.getSort()), "first"));
        }
        if (page.hasPrevious()) {
            resources.add(this.createLink(base, page.previousPageable(), "prev"));
        }
        PageRequest current = new PageRequest(page.getNumber(), page.getSize(), page.getSort());
        resources.add(link == null ? this.createLink(base, current, "self") : link.withSelfRel());
        if (page.hasNext()) {
            resources.add(this.createLink(base, page.nextPageable(), "next"));
        }
        if (isNavigable || this.forceFirstAndLastRels) {
            int lastIndex = page.getTotalPages() == 0 ? 0 : page.getTotalPages() - 1;
            resources.add(this.createLink(base, new PageRequest(lastIndex, page.getSize(), page.getSort()), "last"));
        }
        return resources;
    }

    private UriTemplate getUriTemplate(Link baseLink) {
        String href = baseLink != null ? baseLink.getHref() : (this.baseUri == null ? ServletUriComponentsBuilder.fromCurrentRequest().build().toString() : this.baseUri.toString());
        return new UriTemplate(href);
    }

    private Link createLink(UriTemplate base, Pageable pageable, String rel) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)base.expand(new Object[0]));
        this.pageableResolver.enhance(builder, this.getMethodParameter(), pageable);
        return new Link(new UriTemplate(builder.build().toString()), rel);
    }

    protected MethodParameter getMethodParameter() {
        return null;
    }

    private static <T> PagedResources.PageMetadata asPageMetadata(Page<T> page) {
        Assert.notNull(page, "Page must not be null!");
        return new PagedResources.PageMetadata((long)page.getSize(), (long)page.getNumber(), page.getTotalElements(), (long)page.getTotalPages());
    }

    private static class SimplePagedResourceAssembler<T>
    implements ResourceAssembler<T, Resource<T>> {
        private SimplePagedResourceAssembler() {
        }

        public Resource<T> toResource(T entity) {
            return new Resource(entity, new Link[0]);
        }
    }
}

