package br.pucrio.tecgraf.soma.job.application.service.job.builder;

import java.util.List;

import br.pucrio.tecgraf.soma.job.JobProgressEvent;
import br.pucrio.tecgraf.soma.job.NodeProgress;
import br.pucrio.tecgraf.soma.job.domain.model.Job;

public class JobProgressBuilder {

  public void build(Job job, JobProgressEvent event) {
    if(event == null) {
      throw new IllegalArgumentException();
    }

    // Seta o progresso geral do comando
    job.setProgress(event.getJobProgress());

    // Seta o progresso de nós do fluxo (se houver)
    List<NodeProgress> nodesProgress = event.getNodesProgress();
    if(nodesProgress != null) {
      for (NodeProgress nodeProgress : nodesProgress) {
        job.setAlgorithmProgress(nodeProgress.getFlowNodeId(), nodeProgress.getFlowNodeProgress());
      }
    }
  }
}
