/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.util;

import br.pucrio.tecgraf.soma.job.Algorithm;
import br.pucrio.tecgraf.soma.job.AlgorithmParameter;
import br.pucrio.tecgraf.soma.job.ExitStatus;
import br.pucrio.tecgraf.soma.job.Flow;
import csbase.logic.CommandFinalizationInfo;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.flows.configurator.FlowAlgorithmConfigurator;
import csbase.logic.algorithms.flows.configurator.Node;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.serializer.FlowAlgorithmConfigurationSerializer;
import csbase.logic.algorithms.serializer.exception.AlgorithmConfigurationSerializerException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class CSBaseCommandUtil {
    public static AlgorithmParameter convertFromCSBaseParameter(SimpleParameter<?> p) {
        AlgorithmParameter param = new AlgorithmParameter();
        param.setParameterId(p.getName());
        param.setLabel(p.getLabel());
        param.setType(p.getType());
        try {
            String valueAsJSON = p.getValueAsJSON();
            param.setValue(valueAsJSON);
        }
        catch (Throwable e) {
            e.printStackTrace();
            param.setValue("###INVALID_VALUE###");
        }
        return param;
    }

    public static Flow createFlowFromConfig(FlowAlgorithmConfigurator flowConf) {
        Flow flow = new Flow();
        if (flowConf.getAlgorithmId() != null) {
            flow.setFlowId(flowConf.getAlgorithmId());
        } else {
            flow.setFlowId("");
        }
        if (flowConf.getAlgorithmVersion() != null) {
            flow.setFlowVersion(flowConf.getAlgorithmVersion().toString());
        } else {
            flow.setFlowVersion("");
        }
        if (flowConf.getAlgorithmName() != null) {
            flow.setFlowName(flowConf.getAlgorithmName());
        } else {
            flow.setFlowName("");
        }
        ArrayList<Algorithm> algorithms = new ArrayList<Algorithm>();
        for (Node node : flowConf.getNodes()) {
            Algorithm algorithm = CSBaseCommandUtil.createAlgorithmFromConfig(node.getConfigurator());
            algorithm.setFlowNodeId(Integer.valueOf(node.getId()));
            algorithms.add(algorithm);
        }
        flow.setAlgorithms(algorithms);
        FlowAlgorithmConfigurationSerializer serializer = new FlowAlgorithmConfigurationSerializer();
        try (ByteArrayOutputStream serializerOutput = new ByteArrayOutputStream();){
            serializer.write((AlgorithmConfigurator)flowConf, (OutputStream)serializerOutput);
            byte[] configuratorData = serializerOutput.toByteArray();
            flow.setRaw(ByteBuffer.wrap(configuratorData));
        }
        catch (AlgorithmConfigurationSerializerException | IOException e) {
            e.printStackTrace();
        }
        return flow;
    }

    public static Algorithm createAlgorithmFromConfig(AlgorithmConfigurator algoConf) {
        Algorithm algorithm = new Algorithm();
        algorithm.setAlgorithmId(algoConf.getAlgorithmId());
        algorithm.setAlgorithmVersion(algoConf.getAlgorithmVersion().toString());
        algorithm.setAlgorithmName(algoConf.getAlgorithmName());
        List params = ((SimpleAlgorithmConfigurator)algoConf).getSimpleParameters().stream().map(CSBaseCommandUtil::convertFromCSBaseParameter).collect(Collectors.toList());
        algorithm.setParameters(params);
        return algorithm;
    }

    public static ExitStatus getExitStatusFromInfo(CommandFinalizationInfo finalizationInfo) {
        switch (finalizationInfo.getFinalizationType()) {
            case SUCCESS: {
                return ExitStatus.SUCCESS;
            }
            case LOST: {
                return ExitStatus.LOST;
            }
            case EXECUTION_ERROR: {
                return ExitStatus.EXECUTION_ERROR;
            }
            case KILLED: {
                return ExitStatus.KILLED;
            }
            case FAILED: {
                switch (finalizationInfo.getFailureCause()) {
                    case UNKNOWN: {
                        return ExitStatus.UNKNOWN;
                    }
                    case COMMAND_IDENTIFIER_NOT_FOUND: {
                        return ExitStatus.COMMAND_IDENTIFIER_NOT_FOUND;
                    }
                    case SGA_EXECUTION_ERROR: {
                        return ExitStatus.UNEXPECTED_MACHINE_ERROR;
                    }
                    case FAILED_SETUP_EXECUTION_ENVIRONMENT: {
                        return ExitStatus.FAILED_SETUP_EXECUTION_ENVIRONMENT;
                    }
                    case PROJECT_NOT_FOUND: {
                        return ExitStatus.PROJECT_NOT_FOUND;
                    }
                    case NO_SGA_AVAILABLE_TO_ROOT_COMMAND: 
                    case SGA_IS_NOT_AVAILABLE: {
                        return ExitStatus.NO_MACHINE_AVAILABLE;
                    }
                    case USER_WITHOUT_PERMISSION_FOR_EXECUTION: {
                        return ExitStatus.NO_PERMISSION;
                    }
                }
                return ExitStatus.UNDEFINED;
            }
            case NO_EXIT_CODE: 
            case END: 
            case UNKNOWN: {
                return ExitStatus.UNKNOWN;
            }
        }
        return ExitStatus.UNDEFINED;
    }
}

