/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.api;

import br.pucrio.tecgraf.soma.job.api.JobsApiService;
import br.pucrio.tecgraf.soma.job.api.NotFoundException;
import br.pucrio.tecgraf.soma.job.api.factories.JobsApiServiceFactory;
import br.pucrio.tecgraf.soma.job.api.model.AlgorithmResponse;
import br.pucrio.tecgraf.soma.job.api.model.Error;
import br.pucrio.tecgraf.soma.job.api.model.JobResponse;
import br.pucrio.tecgraf.soma.job.api.model.NewComment;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import jakarta.servlet.ServletConfig;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import java.util.List;

@Path(value="/jobs/history")
@Api(description="the jobs API")
public class JobsApi {
    private final JobsApiService delegate;

    public JobsApi(@Context ServletConfig servletContext) {
        String implClass;
        JobsApiService delegate = null;
        if (servletContext != null && (implClass = servletContext.getInitParameter("JobsApi.implementation")) != null && !"".equals(implClass.trim())) {
            try {
                delegate = (JobsApiService)Class.forName(implClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (delegate == null) {
            delegate = JobsApiServiceFactory.getJobsApi();
        }
        this.delegate = delegate;
    }

    @GET
    @Path(value="/algorithms")
    @Produces(value={"application/json;", "application/json"})
    @ApiOperation(value="Fetch list of all distinct algorithms used by the filtered jobs.", notes="This endpoint lists all distinct algorithms used by the filtered jobs.", response=AlgorithmResponse.class, tags={"Algorithms"})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation.", response=AlgorithmResponse.class), @ApiResponse(code=403, message="if the authenticated user does not have permission to access the project.", response=Error.class)})
    public Response jobsHistoryAlgorithmsGet(@ApiParam(value="The query in RSQL format.") @QueryParam(value="q") String q, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.jobsHistoryAlgorithmsGet(q, locale, securityContext);
    }

    @DELETE
    @ApiOperation(value="Archive a job execution.", notes="This endpoint archives the job execution, removing from the list of searchable jobs.", response=Void.class, tags={"Jobs"})
    @ApiResponses(value={@ApiResponse(code=204, message="Successful operation.", response=Void.class), @ApiResponse(code=403, message="if the authenticated user is not authorized to archive the job. Only the job owner or the administrator can archive a job.", response=Void.class), @ApiResponse(code=500, message="Processing error occurred during the job archive operation.", response=Void.class)})
    public Response jobsHistoryDelete(@ApiParam(value="The IDs of the jobs to be archived.", required=true) @QueryParam(value="jobIds") @NotNull List<String> jobIds, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.jobsHistoryDelete(jobIds, locale, securityContext);
    }

    @GET
    @Produces(value={"application/json;", "application/json"})
    @ApiOperation(value="Fetch list of matching jobs.", notes="This endpoint list all jobs that match the parameters criteria", response=JobResponse.class, tags={"Jobs"})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation.", response=JobResponse.class), @ApiResponse(code=403, message="if the authenticated user does not have permission to access the project.", response=Void.class), @ApiResponse(code=400, message="bad parameters. The error code are: <br> 1. If a invalid limit was used 2. If a invalid offset was used 3. If a invalid sort was used ", response=Error.class)})
    public Response jobsHistoryGet(@ApiParam(value="The query in RSQL format.") @QueryParam(value="q") String q, @ApiParam(value="The zero based position of the first item to retrieve") @QueryParam(value="offset") Integer offset, @ApiParam(value="The number of items to retrieve") @QueryParam(value="limit") Integer limit, @ApiParam(value="Parameter indicating the sorting direction of the results") @QueryParam(value="asc") Boolean asc, @ApiParam(value="Attribute that should be used to sort the results") @QueryParam(value="attr") String attr, @ApiParam(value="Return jobs in the same group as a single entry.", defaultValue="false") @DefaultValue(value="false") @QueryParam(value="grouped") Boolean grouped, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.jobsHistoryGet(q, offset, limit, asc, attr, grouped, locale, securityContext);
    }

    @PUT
    @Path(value="/{jobId}/comment")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Changes a job comment.", notes="This endpoint edits a job comment.", response=Void.class, tags={"Jobs"})
    @ApiResponses(value={@ApiResponse(code=204, message="Successful operation.", response=Void.class), @ApiResponse(code=400, message="Missing body parameter(s).", response=Void.class), @ApiResponse(code=401, message="No authorization token.", response=Void.class), @ApiResponse(code=403, message="If the authenticated user is not authorized to edit the job comment. Only the job owner or the administrator can edit a job comment.", response=Void.class), @ApiResponse(code=404, message="Job not found.", response=Void.class), @ApiResponse(code=500, message="Processing error occurred during the job edit operation.", response=Void.class), @ApiResponse(code=503, message="Server is currently unable to handle the request.", response=Void.class)})
    public Response jobsHistoryJobIdCommentPut(@ApiParam(value="The ID of the job to be edited.", required=true) @PathParam(value="jobId") @NotNull String jobId, @ApiParam(value="The comment to be added to the job.", required=true) @NotNull @Valid NewComment newComment, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.jobsHistoryJobIdCommentPut(jobId, newComment, locale, securityContext);
    }
}

