/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.api;

import br.pucrio.tecgraf.soma.job.api.NotFoundException;
import br.pucrio.tecgraf.soma.job.api.ReplicaApiService;
import br.pucrio.tecgraf.soma.job.api.factories.ReplicaApiServiceFactory;
import br.pucrio.tecgraf.soma.job.api.model.ReplicaJob;
import br.pucrio.tecgraf.soma.job.api.model.ReplicaJobBatchResponse;
import br.pucrio.tecgraf.soma.job.api.model.ReplicaJobResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import jakarta.servlet.ServletConfig;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import java.util.List;

@Path(value="/replica")
@Api(description="the replica API")
public class ReplicaApi {
    private final ReplicaApiService delegate;

    public ReplicaApi(@Context ServletConfig servletContext) {
        String implClass;
        ReplicaApiService delegate = null;
        if (servletContext != null && (implClass = servletContext.getInitParameter("ReplicaApi.implementation")) != null && !"".equals(implClass.trim())) {
            try {
                delegate = (ReplicaApiService)Class.forName(implClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (delegate == null) {
            delegate = ReplicaApiServiceFactory.getReplicaApi();
        }
        this.delegate = delegate;
    }

    @POST
    @Path(value="/batch")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create multiple replica submissions", notes="This endpoint creates multiple replica submissions from a multiflow.", response=ReplicaJobBatchResponse.class, responseContainer="List", tags={"Replicas"})
    @ApiResponses(value={@ApiResponse(code=201, message="New replica jobs created.", response=ReplicaJobBatchResponse.class, responseContainer="List"), @ApiResponse(code=400, message="Missing body parameter(s).", response=Void.class), @ApiResponse(code=401, message="No authorization token.", response=Void.class), @ApiResponse(code=403, message="The authenticated user does not have permission to access the project.", response=Void.class), @ApiResponse(code=404, message="Multiflow not found.", response=Void.class), @ApiResponse(code=500, message="Processing error occurred during the multiflow creation.", response=Void.class), @ApiResponse(code=503, message="Server is currently unable to handle the request.", response=Void.class)})
    public Response replicaBatchPost(@ApiParam(value="Required information to create multiple replica submissions", required=true) @NotNull @Valid List<ReplicaJob> replicaJob, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.replicaBatchPost(replicaJob, locale, securityContext);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create a replica submission", notes="This endpoint creates a replica submission from a multiflow.", response=ReplicaJobResponse.class, tags={"Replicas"})
    @ApiResponses(value={@ApiResponse(code=201, message="New replica job created.", response=ReplicaJobResponse.class), @ApiResponse(code=400, message="Missing body parameter(s).", response=Void.class), @ApiResponse(code=401, message="No authorization token.", response=Void.class), @ApiResponse(code=403, message="The authenticated user does not have permission to access the project.", response=Void.class), @ApiResponse(code=404, message="Multiflow not found.", response=Void.class), @ApiResponse(code=409, message="Job id already associated with a replica.", response=Void.class), @ApiResponse(code=500, message="Processing error occurred during the multiflow creation.", response=Void.class), @ApiResponse(code=503, message="Server is currently unable to handle the request.", response=Void.class)})
    public Response replicaPost(@ApiParam(value="Required information to create a replica submission", required=true) @NotNull @Valid ReplicaJob replicaJob, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.replicaPost(replicaJob, locale, securityContext);
    }
}

