/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.api.model;

import br.pucrio.tecgraf.soma.job.api.model.AlgorithmParameter;
import br.pucrio.tecgraf.soma.job.application.JsonUndefined;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"algorithmId", "algorithmVersion", "algorithmName", "flowNodeId", "flowNodeExitCode", "flowNodeProgress", "parameters"})
@JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=JsonUndefined.class)
public class JobAlgorithm {
    public static final String JSON_PROPERTY_ALGORITHM_ID = "algorithmId";
    @JsonProperty(value="algorithmId")
    private String algorithmId;
    public static final String JSON_PROPERTY_ALGORITHM_VERSION = "algorithmVersion";
    @JsonProperty(value="algorithmVersion")
    private String algorithmVersion;
    public static final String JSON_PROPERTY_ALGORITHM_NAME = "algorithmName";
    @JsonProperty(value="algorithmName")
    private String algorithmName;
    public static final String JSON_PROPERTY_FLOW_NODE_ID = "flowNodeId";
    @JsonProperty(value="flowNodeId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    private Integer flowNodeId;
    public static final String JSON_PROPERTY_FLOW_NODE_EXIT_CODE = "flowNodeExitCode";
    @JsonProperty(value="flowNodeExitCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    private Integer flowNodeExitCode;
    public static final String JSON_PROPERTY_FLOW_NODE_PROGRESS = "flowNodeProgress";
    @JsonProperty(value="flowNodeProgress")
    private String flowNodeProgress;
    public static final String JSON_PROPERTY_PARAMETERS = "parameters";
    @JsonProperty(value="parameters")
    private List<@Valid AlgorithmParameter> parameters = new ArrayList();

    public JobAlgorithm algorithmId(String algorithmId) {
        this.algorithmId = algorithmId;
        return this;
    }

    @JsonProperty(value="algorithmId")
    @ApiModelProperty(value="The algorithm Id associated with the job.")
    public String getAlgorithmId() {
        return this.algorithmId;
    }

    public void setAlgorithmId(String algorithmId) {
        this.algorithmId = algorithmId;
    }

    public JobAlgorithm algorithmVersion(String algorithmVersion) {
        this.algorithmVersion = algorithmVersion;
        return this;
    }

    @JsonProperty(value="algorithmVersion")
    @ApiModelProperty(value="The algoritm version associated with the job.")
    public String getAlgorithmVersion() {
        return this.algorithmVersion;
    }

    public void setAlgorithmVersion(String algorithmVersion) {
        this.algorithmVersion = algorithmVersion;
    }

    public JobAlgorithm algorithmName(String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    @JsonProperty(value="algorithmName")
    @ApiModelProperty(value="The algoritm name associated with the job.")
    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public void setAlgorithmName(String algorithmName) {
        this.algorithmName = algorithmName;
    }

    public JobAlgorithm flowNodeId(Integer flowNodeId) {
        this.flowNodeId = flowNodeId;
        return this;
    }

    @JsonProperty(value="flowNodeId")
    @ApiModelProperty(value="The algorithm flow node id that helps to identify algorithms with same name and version when job is a flow.")
    public Integer getFlowNodeId() {
        return this.flowNodeId;
    }

    public void setFlowNodeId(Integer flowNodeId) {
        this.flowNodeId = flowNodeId;
    }

    public JobAlgorithm flowNodeExitCode(Integer flowNodeExitCode) {
        this.flowNodeExitCode = flowNodeExitCode;
        return this;
    }

    @JsonProperty(value="flowNodeExitCode")
    @ApiModelProperty(value="The code returned by the execution of this algorithm. It can be empty if the job have not already finished or if the system could not gather it.")
    public Integer getFlowNodeExitCode() {
        return this.flowNodeExitCode;
    }

    public void setFlowNodeExitCode(Integer flowNodeExitCode) {
        this.flowNodeExitCode = flowNodeExitCode;
    }

    public JobAlgorithm flowNodeProgress(String flowNodeProgress) {
        this.flowNodeProgress = flowNodeProgress;
        return this;
    }

    @JsonProperty(value="flowNodeProgress")
    @ApiModelProperty(value="The execution progress of this algorithm.")
    public String getFlowNodeProgress() {
        return this.flowNodeProgress;
    }

    public void setFlowNodeProgress(String flowNodeProgress) {
        this.flowNodeProgress = flowNodeProgress;
    }

    public JobAlgorithm parameters(List<@Valid AlgorithmParameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    public JobAlgorithm addParametersItem(AlgorithmParameter parametersItem) {
        if (this.parameters == null) {
            this.parameters = new ArrayList();
        }
        this.parameters.add(parametersItem);
        return this;
    }

    @JsonProperty(value="parameters")
    @ApiModelProperty(value="List with all algorithm parameters.")
    @Valid
    public @Valid List<@Valid AlgorithmParameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<@Valid AlgorithmParameter> parameters) {
        this.parameters = parameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobAlgorithm jobAlgorithm = (JobAlgorithm)o;
        return Objects.equals(this.algorithmId, jobAlgorithm.algorithmId) && Objects.equals(this.algorithmVersion, jobAlgorithm.algorithmVersion) && Objects.equals(this.algorithmName, jobAlgorithm.algorithmName) && Objects.equals(this.flowNodeId, jobAlgorithm.flowNodeId) && Objects.equals(this.flowNodeExitCode, jobAlgorithm.flowNodeExitCode) && Objects.equals(this.flowNodeProgress, jobAlgorithm.flowNodeProgress) && Objects.equals(this.parameters, jobAlgorithm.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.algorithmId, this.algorithmVersion, this.algorithmName, this.flowNodeId, this.flowNodeExitCode, this.flowNodeProgress, this.parameters);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JobAlgorithm {\n");
        sb.append("    algorithmId: ").append(this.toIndentedString((Object)this.algorithmId)).append("\n");
        sb.append("    algorithmVersion: ").append(this.toIndentedString((Object)this.algorithmVersion)).append("\n");
        sb.append("    algorithmName: ").append(this.toIndentedString((Object)this.algorithmName)).append("\n");
        sb.append("    flowNodeId: ").append(this.toIndentedString((Object)this.flowNodeId)).append("\n");
        sb.append("    flowNodeExitCode: ").append(this.toIndentedString((Object)this.flowNodeExitCode)).append("\n");
        sb.append("    flowNodeProgress: ").append(this.toIndentedString((Object)this.flowNodeProgress)).append("\n");
        sb.append("    parameters: ").append(this.toIndentedString((Object)this.parameters)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

