/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.application.appservice;

import br.pucrio.tecgraf.soma.job.api.model.ReplicaJobBatchResponse;
import br.pucrio.tecgraf.soma.job.api.model.ReplicaJobResponse;
import br.pucrio.tecgraf.soma.job.application.service.MultiflowService;
import br.pucrio.tecgraf.soma.job.application.service.ProjectService;
import br.pucrio.tecgraf.soma.job.application.service.ReplicaService;
import br.pucrio.tecgraf.soma.job.domain.model.Multiflow;
import br.pucrio.tecgraf.soma.job.domain.model.Replica;
import br.pucrio.tecgraf.soma.job.domain.model.ReplicaJob;
import jakarta.ws.rs.ForbiddenException;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.client.HttpClientErrorException;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ReplicaAppService {
    private static final Logger LOG = Logger.getLogger(ReplicaAppService.class);
    @Autowired
    private ProjectService projectService;
    @Autowired
    private MultiflowService multiflowService;
    @Autowired
    private ReplicaService replicaService;

    @Transactional
    public List<ReplicaJobBatchResponse> createReplicaJobs(List<br.pucrio.tecgraf.soma.job.api.model.ReplicaJob> replicaJobs) {
        Multiflow multiflow = this.multiflowService.findMultiflowById(replicaJobs.get(0).getMultiflowId());
        this.validateMultiflowId(multiflow);
        return replicaJobs.stream().map(replicaJob -> {
            try {
                this.validateReplicaJobId(replicaJob);
                return ReplicaAppService.convertToBatchResponse((ReplicaJobResponse)this.persistReplicaJob(replicaJob, multiflow));
            }
            catch (HttpClientErrorException e) {
                String errorMsg = "HTTP error creating a Replica. " + e.getMessage();
                LOG.info((Object)errorMsg);
                ReplicaJobBatchResponse response = new ReplicaJobBatchResponse();
                return response.error(e.getStatusText());
            }
            catch (Exception e) {
                String errorMsg = "Unknown error creating a Replica: " + e.getMessage();
                LOG.info((Object)errorMsg);
                ReplicaJobBatchResponse response = new ReplicaJobBatchResponse();
                return response.error(errorMsg);
            }
        }).collect(Collectors.toList());
    }

    @Transactional
    public ReplicaJobResponse createReplicaJob(br.pucrio.tecgraf.soma.job.api.model.ReplicaJob replicaJobData) {
        Multiflow multiflow = this.multiflowService.findMultiflowById(replicaJobData.getMultiflowId());
        this.validateMultiflowId(multiflow);
        this.validateReplicaJobId(replicaJobData);
        return this.persistReplicaJob(replicaJobData, multiflow);
    }

    private void validateMultiflowId(Multiflow multiflow) {
        if (!this.projectService.hasPermission(multiflow.getProjectId())) {
            throw new ForbiddenException("User has no permission to add a Replica to this project");
        }
    }

    private ReplicaJobResponse persistReplicaJob(br.pucrio.tecgraf.soma.job.api.model.ReplicaJob replicaJobData, Multiflow multiflow) {
        Replica replica = this.replicaService.findReplicaBy(multiflow.getId(), replicaJobData.getLineNumber().intValue());
        if (replica == null) {
            replica = new Replica();
            replica.setMultiflow(multiflow);
            replica.setLineNumber(replicaJobData.getLineNumber());
            this.replicaService.createReplica(replica);
        }
        ReplicaJob replicaJob = new ReplicaJob();
        replicaJob.setVersion(this.replicaService.getNextReplicaJobVersion(replica));
        replicaJob.setJobStringId(replicaJobData.getJobId());
        replicaJob.setSubmissionTime(LocalDateTime.now(ZoneOffset.UTC));
        replicaJob.setReplicaDependencyRaw(replicaJobData.getReplicaDependencyRaw());
        replica.addReplicaJob(replicaJob);
        this.replicaService.updateReplica(replica);
        return ReplicaAppService.convertToBasicRESTModel((ReplicaJob)this.replicaService.findReplicaJobBy(replicaJob.getJobStringId()));
    }

    private void validateReplicaJobId(br.pucrio.tecgraf.soma.job.api.model.ReplicaJob replicaJobData) {
        ReplicaJob replicaJobFound = this.replicaService.findReplicaJobBy(replicaJobData.getJobId());
        if (replicaJobFound != null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.CONFLICT, "Job ID " + replicaJobData.getJobId() + " exists in line number " + replicaJobFound.getReplica().getLineNumber());
        }
    }

    private static ReplicaJobResponse convertToBasicRESTModel(ReplicaJob replicaJobDbModel) {
        ReplicaJobResponse restModel = new ReplicaJobResponse();
        Replica replica = replicaJobDbModel.getReplica();
        restModel.setLineNumber(replica.getLineNumber());
        restModel.setMultiflowId(Long.valueOf(replica.getMultiflow().getId()));
        restModel.setMultiflowName(replica.getMultiflow().getName());
        restModel.setJobId(replicaJobDbModel.getJobStringId());
        restModel.setVersion(replicaJobDbModel.getVersion());
        restModel.replicaDependencyRaw(replicaJobDbModel.getReplicaDependencyRaw());
        return restModel;
    }

    private static ReplicaJobBatchResponse convertToBatchResponse(ReplicaJobResponse response) {
        ReplicaJobBatchResponse batchResponse = new ReplicaJobBatchResponse();
        batchResponse.setVersion(response.getVersion());
        return batchResponse;
    }
}

