/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.application.controller;

import br.pucrio.tecgraf.soma.job.api.MultiflowApi;
import br.pucrio.tecgraf.soma.job.api.model.Multiflow;
import br.pucrio.tecgraf.soma.job.api.model.MultiflowBasicResponse;
import br.pucrio.tecgraf.soma.job.api.model.MultiflowFullResponse;
import br.pucrio.tecgraf.soma.job.api.model.MultiflowPatch;
import br.pucrio.tecgraf.soma.job.application.appservice.MultiflowAppService;
import jakarta.persistence.NoResultException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.ServiceUnavailableException;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import java.util.List;
import org.jboss.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.transaction.CannotCreateTransactionException;

@Component
public class MultiflowController
extends MultiflowApi {
    private static final Logger LOG = Logger.getLogger(MultiflowController.class);
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private MultiflowAppService multiflowAppService;

    public MultiflowController() {
        super(null);
    }

    public Response multiflowPost(Multiflow multiflow, String locale, SecurityContext securityContext) {
        MultiflowBasicResponse multiflowResponse;
        String accessToken = this.request.getHeader("Authorization");
        if (accessToken == null || accessToken.isEmpty()) {
            LOG.info((Object)"Empty or null token");
            return Response.status((int)HttpStatus.UNAUTHORIZED.value()).build();
        }
        try {
            multiflowResponse = this.multiflowAppService.createMultiflow(multiflow);
        }
        catch (ServiceUnavailableException | CannotCreateTransactionException e) {
            String errorMsg = "Error creating a Multiflow: " + e.getMessage();
            LOG.info((Object)errorMsg);
            return Response.status((int)HttpStatus.SERVICE_UNAVAILABLE.value()).entity((Object)errorMsg).build();
        }
        catch (ForbiddenException e) {
            String errorMsg = "Error creating a Multiflow: " + e.getMessage();
            LOG.info((Object)errorMsg);
            return Response.status((int)HttpStatus.FORBIDDEN.value()).entity((Object)errorMsg).build();
        }
        catch (Exception e) {
            String errorMsg = "Error creating a Multiflow: " + e.getMessage();
            LOG.info((Object)errorMsg);
            return Response.status((int)HttpStatus.INTERNAL_SERVER_ERROR.value()).entity((Object)errorMsg).build();
        }
        return Response.status((int)HttpStatus.CREATED.value()).entity((Object)multiflowResponse).build();
    }

    public Response multiflowGet(String projectId, String locale, SecurityContext securityContext) {
        List multiflows;
        String accessToken = this.request.getHeader("Authorization");
        if (accessToken == null || accessToken.isEmpty()) {
            LOG.info((Object)"Empty or null token");
            return Response.status((int)HttpStatus.UNAUTHORIZED.value()).build();
        }
        try {
            multiflows = this.multiflowAppService.findMultiflowsByProjectId(projectId);
        }
        catch (ServiceUnavailableException | CannotCreateTransactionException e) {
            String errorMsg = "Error getting a Multiflow: " + e.getMessage();
            LOG.info((Object)errorMsg);
            return Response.status((int)HttpStatus.SERVICE_UNAVAILABLE.value()).entity((Object)errorMsg).build();
        }
        catch (ForbiddenException e) {
            String errorMsg = "Error getting a Multiflow: " + e.getMessage();
            LOG.info((Object)errorMsg);
            return Response.status((int)HttpStatus.FORBIDDEN.value()).entity((Object)errorMsg).build();
        }
        catch (Exception e) {
            String errorMsg = "Error getting a Multiflow: " + e.getMessage();
            LOG.info((Object)errorMsg);
            return Response.status((int)HttpStatus.INTERNAL_SERVER_ERROR.value()).entity((Object)errorMsg).build();
        }
        return Response.status((int)HttpStatus.OK.value()).entity((Object)multiflows).build();
    }

    public Response multiflowMultiflowIdGet(Long multiflowId, String locale, SecurityContext securityContext) {
        MultiflowFullResponse multiflow;
        String accessToken = this.request.getHeader("Authorization");
        if (accessToken == null || accessToken.isEmpty()) {
            LOG.info((Object)"Empty or null token");
            return Response.status((int)HttpStatus.UNAUTHORIZED.value()).build();
        }
        try {
            multiflow = this.multiflowAppService.findMultiflowById(multiflowId);
        }
        catch (ServiceUnavailableException | CannotCreateTransactionException e) {
            String errorMsg = "Error getting a Multiflow: " + e.getMessage();
            LOG.info((Object)errorMsg);
            return Response.status((int)HttpStatus.SERVICE_UNAVAILABLE.value()).entity((Object)errorMsg).build();
        }
        catch (ForbiddenException e) {
            String errorMsg = "Error getting a Multiflow: " + e.getMessage();
            LOG.info((Object)errorMsg);
            return Response.status((int)HttpStatus.FORBIDDEN.value()).entity((Object)errorMsg).build();
        }
        catch (NoResultException e) {
            String errorMsg = "Error getting a Multiflow: " + e.getMessage();
            LOG.info((Object)errorMsg);
            return Response.status((int)HttpStatus.NOT_FOUND.value()).entity((Object)errorMsg).build();
        }
        catch (Exception e) {
            String errorMsg = "Error getting a Multiflow: " + e.getMessage();
            LOG.info((Object)errorMsg);
            return Response.status((int)HttpStatus.INTERNAL_SERVER_ERROR.value()).entity((Object)errorMsg).build();
        }
        return Response.status((int)HttpStatus.OK.value()).entity((Object)multiflow).build();
    }

    public Response multiflowMultiflowIdPatch(Long multiflowId, MultiflowPatch multiflowPatch, String locale, SecurityContext securityContext) {
        MultiflowFullResponse multiflow;
        String accessToken = this.request.getHeader("Authorization");
        if (accessToken == null || accessToken.isEmpty()) {
            LOG.info((Object)"Empty or null token");
            return Response.status((int)HttpStatus.UNAUTHORIZED.value()).build();
        }
        if (!this.validatePatchProperties(multiflowPatch)) {
            LOG.info((Object)"Missing arguments");
            return Response.status((int)HttpStatus.BAD_REQUEST.value()).build();
        }
        try {
            multiflow = this.multiflowAppService.updateMultiflow(multiflowId, multiflowPatch.getMultiflowName(), multiflowPatch.getReplicaFilePath(), multiflowPatch.getReplicaFileName(), multiflowPatch.getParameterMapping());
        }
        catch (ServiceUnavailableException | CannotCreateTransactionException e) {
            String errorMsg = "Error updating Multiflow: " + e.getMessage();
            LOG.info((Object)errorMsg);
            return Response.status((int)HttpStatus.SERVICE_UNAVAILABLE.value()).entity((Object)errorMsg).build();
        }
        catch (ForbiddenException e) {
            String errorMsg = "Error updating Multiflow: " + e.getMessage();
            LOG.info((Object)errorMsg);
            return Response.status((int)HttpStatus.FORBIDDEN.value()).entity((Object)errorMsg).build();
        }
        catch (NoResultException e) {
            String errorMsg = "Error updating Multiflow: " + e.getMessage();
            LOG.info((Object)errorMsg);
            return Response.status((int)HttpStatus.NOT_FOUND.value()).entity((Object)errorMsg).build();
        }
        catch (Exception e) {
            String errorMsg = "Error updating Multiflow: " + e.getMessage();
            LOG.info((Object)errorMsg);
            return Response.status((int)HttpStatus.INTERNAL_SERVER_ERROR.value()).entity((Object)errorMsg).build();
        }
        return Response.status((int)HttpStatus.OK.value()).entity((Object)multiflow).build();
    }

    public Response multiflowMultiflowIdDelete(Long multiflowId, String locale, SecurityContext securityContext) {
        String accessToken = this.request.getHeader("Authorization");
        if (accessToken == null || accessToken.isEmpty()) {
            LOG.info((Object)"Empty or null token");
            return Response.status((int)HttpStatus.UNAUTHORIZED.value()).build();
        }
        try {
            this.multiflowAppService.deleteMultiflow(multiflowId);
        }
        catch (ServiceUnavailableException | CannotCreateTransactionException e) {
            String errorMsg = "Error deleting Multiflow: " + e.getMessage();
            LOG.info((Object)errorMsg);
            return Response.status((int)HttpStatus.SERVICE_UNAVAILABLE.value()).entity((Object)errorMsg).build();
        }
        catch (ForbiddenException e) {
            String errorMsg = "Error deleting Multiflow: " + e.getMessage();
            LOG.info((Object)errorMsg);
            return Response.status((int)HttpStatus.FORBIDDEN.value()).entity((Object)errorMsg).build();
        }
        catch (NoResultException e) {
            String errorMsg = "Error deleting Multiflow: " + e.getMessage();
            LOG.info((Object)errorMsg);
            return Response.status((int)HttpStatus.NOT_FOUND.value()).entity((Object)errorMsg).build();
        }
        catch (Exception e) {
            String errorMsg = "Error deleting Multiflow: " + e.getMessage();
            LOG.info((Object)errorMsg);
            return Response.status((int)HttpStatus.INTERNAL_SERVER_ERROR.value()).entity((Object)errorMsg).build();
        }
        return Response.status((int)HttpStatus.NO_CONTENT.value()).build();
    }

    private boolean validatePatchProperties(MultiflowPatch multiflowPatch) {
        return multiflowPatch.getReplicaFileName() != null || multiflowPatch.getReplicaFilePath() != null || multiflowPatch.getParameterMapping() != null || multiflowPatch.getMultiflowName() != null;
    }
}

