/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.infrastructure.persistence.repository;

import br.pucrio.tecgraf.soma.job.domain.model.Replica;
import br.pucrio.tecgraf.soma.job.domain.model.ReplicaJob;
import br.pucrio.tecgraf.soma.serviceapi.persistence.repository.impl.JPARepository;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.TypedQuery;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Repository
public class ReplicaRepository
extends JPARepository<Replica> {
    @PersistenceContext
    private EntityManager _entityManager;

    public Class<Replica> getType() {
        return Replica.class;
    }

    public EntityManager getEntityManager() {
        return this._entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this._entityManager = entityManager;
    }

    public void clearEntityManager() {
        this._entityManager.clear();
    }

    public Replica findBy(long multiflowId, int lineNumber) {
        EntityManager manager = this.getEntityManager();
        String hql = "SELECT r FROM Replica r WHERE r.multiflow.id = :multiflowId AND r.lineNumber = :lineNumber";
        TypedQuery query = manager.createQuery(hql, Replica.class);
        query.setParameter("multiflowId", (Object)multiflowId);
        query.setParameter("lineNumber", (Object)lineNumber);
        try {
            return (Replica)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public ReplicaJob findReplicaJobBy(String replicaJobId) {
        EntityManager manager = this.getEntityManager();
        String hql = "SELECT rj FROM ReplicaJob rj WHERE rj.jobStringId = :replicaJobId";
        TypedQuery query = manager.createQuery(hql, ReplicaJob.class);
        query.setParameter("replicaJobId", (Object)replicaJobId);
        try {
            return (ReplicaJob)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    @Transactional
    public Integer getNextReplicaJobVersion(Replica replica) {
        EntityManager manager = this.getEntityManager();
        String hql = "SELECT COUNT(rj) FROM ReplicaJob rj WHERE rj.replica.id = :replicaId";
        TypedQuery query = manager.createQuery(hql, Long.class);
        query.setParameter("replicaId", (Object)replica.getId());
        try {
            return ((Long)query.getSingleResult()).intValue() + 1;
        }
        catch (NoResultException e) {
            return null;
        }
    }
}

