/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.websocketnotifier.factory.chain;

import br.pucrio.tecgraf.soma.websocketnotifier.application.configuration.SomaWebSocketSession;
import br.pucrio.tecgraf.soma.websocketnotifier.factory.chain.AbstractChain;
import br.pucrio.tecgraf.soma.websocketnotifier.factory.chain.ChainException;
import br.pucrio.tecgraf.soma.websocketnotifier.factory.chain.HandlerResult;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;

public class ProjectPermissionFilter
extends AbstractChain {
    private boolean requiredProject;

    public ProjectPermissionFilter(boolean requiredProject) {
        this.requiredProject = requiredProject;
    }

    public HandlerResult handlerRequest(JsonObject event, List<SomaWebSocketSession> sessions) throws ChainException {
        List<Object> autorizedSessions = new ArrayList();
        if (event.get("event").getAsJsonObject().has("projectId")) {
            String sessionProjectId = event.get("event").getAsJsonObject().get("projectId").getAsString();
            for (SomaWebSocketSession somaWebSocketSession : sessions) {
                if (somaWebSocketSession.getProjectIds() == null || somaWebSocketSession.getProjectIds().isEmpty()) continue;
                for (String projectId : somaWebSocketSession.getProjectIds()) {
                    if (!sessionProjectId.equals(projectId)) continue;
                    autorizedSessions.add(somaWebSocketSession);
                }
            }
        } else if (!this.requiredProject) {
            autorizedSessions = sessions;
        }
        return this.next(event, autorizedSessions);
    }
}

