/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.websocketnotifier.application.appservice;

import br.pucrio.tecgraf.soma.serviceapi.configuration.ServiceConfiguration;
import br.pucrio.tecgraf.soma.websocketnotifier.application.configuration.Constants;
import java.util.List;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EventAppService {
    private final Logger logger = LoggerFactory.getLogger(EventAppService.class);
    @Autowired
    private ServiceConfiguration config;

    public List<String> getUserProjects(String accessToken) throws NotFoundException {
        String csgridBaseURL = this.config.getValue(Constants.Config.CSGRID_BASE_URL.option.getLongName());
        String csgridProjectsPermissionPath = this.config.getValue(Constants.Config.CSGRID_PROJECTS_PERMISSION_PATH.option.getLongName());
        Client client = ClientBuilder.newClient();
        WebTarget target = client.target(csgridBaseURL);
        String requestToken = "Bearer " + accessToken;
        Invocation.Builder requestBuilder = target.path(csgridProjectsPermissionPath).request(new String[]{"application/json"}).header("Authorization", (Object)requestToken);
        Response response = requestBuilder.get();
        if (response.getStatus() != 200) {
            this.logger.warn(csgridBaseURL);
            this.logger.warn(csgridProjectsPermissionPath);
            throw new NotFoundException("Error while trying to retrieve user projects: " + response.getEntity(), response);
        }
        return (List)response.readEntity((GenericType)new /* Unavailable Anonymous Inner Class!! */);
    }
}

