/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.datatype;

import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v23.datatype.CM_CCP;
import ca.uhn.hl7v2.model.v23.datatype.CM_CD_ELECTRODE;
import ca.uhn.hl7v2.model.v23.datatype.CM_CSU;
import ca.uhn.hl7v2.model.v23.datatype.CM_MDV;
import ca.uhn.hl7v2.model.v23.datatype.CM_WVI;
import ca.uhn.hl7v2.model.v23.datatype.NM;
import ca.uhn.log.HapiLogFactory;

public class CD
extends AbstractType
implements Composite {
    private Type[] data;

    public CD(Message message) {
        super(message);
        this.init();
    }

    private void init() {
        this.data = new Type[6];
        this.data[0] = new CM_WVI(this.getMessage());
        this.data[1] = new CM_CD_ELECTRODE(this.getMessage());
        this.data[2] = new CM_CSU(this.getMessage());
        this.data[3] = new CM_CCP(this.getMessage());
        this.data[4] = new NM(this.getMessage());
        this.data[5] = new CM_MDV(this.getMessage());
    }

    public Type[] getComponents() {
        return this.data;
    }

    public Type getComponent(int number) throws DataTypeException {
        try {
            return this.data[number];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + ((Object)((Object)this)).getClass().getName() + " has only " + this.data.length + " components)");
        }
    }

    public CM_WVI getChannelIdentifier() {
        CM_WVI ret = null;
        try {
            ret = (CM_WVI)this.getComponent(0);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public CM_WVI getCd1_ChannelIdentifier() {
        CM_WVI ret = null;
        try {
            ret = (CM_WVI)this.getComponent(0);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public CM_CD_ELECTRODE getElectrodeNames() {
        CM_CD_ELECTRODE ret = null;
        try {
            ret = (CM_CD_ELECTRODE)this.getComponent(1);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public CM_CD_ELECTRODE getCd2_ElectrodeNames() {
        CM_CD_ELECTRODE ret = null;
        try {
            ret = (CM_CD_ELECTRODE)this.getComponent(1);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public CM_CSU getChannelSensitivityUnits() {
        CM_CSU ret = null;
        try {
            ret = (CM_CSU)this.getComponent(2);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public CM_CSU getCd3_ChannelSensitivityUnits() {
        CM_CSU ret = null;
        try {
            ret = (CM_CSU)this.getComponent(2);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public CM_CCP getCalibrationParameters() {
        CM_CCP ret = null;
        try {
            ret = (CM_CCP)this.getComponent(3);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public CM_CCP getCd4_CalibrationParameters() {
        CM_CCP ret = null;
        try {
            ret = (CM_CCP)this.getComponent(3);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NM getSamplingFrequency() {
        NM ret = null;
        try {
            ret = (NM)this.getComponent(4);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NM getCd5_SamplingFrequency() {
        NM ret = null;
        try {
            ret = (NM)this.getComponent(4);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public CM_MDV getMinimumMaximumDataValues() {
        CM_MDV ret = null;
        try {
            ret = (CM_MDV)this.getComponent(5);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public CM_MDV getCd6_MinimumMaximumDataValues() {
        CM_MDV ret = null;
        try {
            ret = (CM_MDV)this.getComponent(5);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }
}

