/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v24.group.PEX_P07_ASSOCIATED_PERSON;
import ca.uhn.hl7v2.model.v24.group.PEX_P07_RX_ADMINISTRATION;
import ca.uhn.hl7v2.model.v24.group.PEX_P07_RX_ORDER;
import ca.uhn.hl7v2.model.v24.group.PEX_P07_STUDY;
import ca.uhn.hl7v2.model.v24.segment.NTE;
import ca.uhn.hl7v2.model.v24.segment.OBX;
import ca.uhn.hl7v2.model.v24.segment.PCR;
import ca.uhn.hl7v2.model.v24.segment.PRB;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class PEX_P07_PEX_CAUSE
extends AbstractGroup {
    public PEX_P07_PEX_CAUSE(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PCR.class, true, false);
            this.add(PEX_P07_RX_ORDER.class, false, false);
            this.add(PEX_P07_RX_ADMINISTRATION.class, false, true);
            this.add(PRB.class, false, true);
            this.add(OBX.class, false, true);
            this.add(NTE.class, false, true);
            this.add(PEX_P07_ASSOCIATED_PERSON.class, false, false);
            this.add(PEX_P07_STUDY.class, false, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating PEX_P07_PEX_CAUSE - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.4";
    }

    public PCR getPCR() {
        PCR ret = null;
        try {
            ret = (PCR)this.get("PCR");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PEX_P07_RX_ORDER getRX_ORDER() {
        PEX_P07_RX_ORDER ret = null;
        try {
            ret = (PEX_P07_RX_ORDER)this.get("RX_ORDER");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PEX_P07_RX_ADMINISTRATION getRX_ADMINISTRATION() {
        PEX_P07_RX_ADMINISTRATION ret = null;
        try {
            ret = (PEX_P07_RX_ADMINISTRATION)this.get("RX_ADMINISTRATION");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PEX_P07_RX_ADMINISTRATION getRX_ADMINISTRATION(int rep) {
        PEX_P07_RX_ADMINISTRATION ret = null;
        try {
            ret = (PEX_P07_RX_ADMINISTRATION)this.get("RX_ADMINISTRATION", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getRX_ADMINISTRATIONReps() {
        int reps = -1;
        try {
            reps = this.getAll("RX_ADMINISTRATION").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertRX_ADMINISTRATION(PEX_P07_RX_ADMINISTRATION structure, int rep) throws HL7Exception {
        super.insertRepetition("RX_ADMINISTRATION", (Structure)structure, rep);
    }

    public PEX_P07_RX_ADMINISTRATION insertRX_ADMINISTRATION(int rep) throws HL7Exception {
        return (PEX_P07_RX_ADMINISTRATION)super.insertRepetition("RX_ADMINISTRATION", rep);
    }

    public PEX_P07_RX_ADMINISTRATION removeRX_ADMINISTRATION(int rep) throws HL7Exception {
        return (PEX_P07_RX_ADMINISTRATION)super.removeRepetition("RX_ADMINISTRATION", rep);
    }

    public PRB getPRB() {
        PRB ret = null;
        try {
            ret = (PRB)this.get("PRB");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PRB getPRB(int rep) {
        PRB ret = null;
        try {
            ret = (PRB)this.get("PRB", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getPRBReps() {
        int reps = -1;
        try {
            reps = this.getAll("PRB").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertPRB(PRB structure, int rep) throws HL7Exception {
        super.insertRepetition("PRB", (Structure)structure, rep);
    }

    public PRB insertPRB(int rep) throws HL7Exception {
        return (PRB)super.insertRepetition("PRB", rep);
    }

    public PRB removePRB(int rep) throws HL7Exception {
        return (PRB)super.removeRepetition("PRB", rep);
    }

    public OBX getOBX() {
        OBX ret = null;
        try {
            ret = (OBX)this.get("OBX");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OBX getOBX(int rep) {
        OBX ret = null;
        try {
            ret = (OBX)this.get("OBX", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getOBXReps() {
        int reps = -1;
        try {
            reps = this.getAll("OBX").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertOBX(OBX structure, int rep) throws HL7Exception {
        super.insertRepetition("OBX", (Structure)structure, rep);
    }

    public OBX insertOBX(int rep) throws HL7Exception {
        return (OBX)super.insertRepetition("OBX", rep);
    }

    public OBX removeOBX(int rep) throws HL7Exception {
        return (OBX)super.removeRepetition("OBX", rep);
    }

    public NTE getNTE() {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE(int rep) {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getNTEReps() {
        int reps = -1;
        try {
            reps = this.getAll("NTE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public PEX_P07_ASSOCIATED_PERSON getASSOCIATED_PERSON() {
        PEX_P07_ASSOCIATED_PERSON ret = null;
        try {
            ret = (PEX_P07_ASSOCIATED_PERSON)this.get("ASSOCIATED_PERSON");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PEX_P07_STUDY getSTUDY() {
        PEX_P07_STUDY ret = null;
        try {
            ret = (PEX_P07_STUDY)this.get("STUDY");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PEX_P07_STUDY getSTUDY(int rep) {
        PEX_P07_STUDY ret = null;
        try {
            ret = (PEX_P07_STUDY)this.get("STUDY", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getSTUDYReps() {
        int reps = -1;
        try {
            reps = this.getAll("STUDY").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertSTUDY(PEX_P07_STUDY structure, int rep) throws HL7Exception {
        super.insertRepetition("STUDY", (Structure)structure, rep);
    }

    public PEX_P07_STUDY insertSTUDY(int rep) throws HL7Exception {
        return (PEX_P07_STUDY)super.insertRepetition("STUDY", rep);
    }

    public PEX_P07_STUDY removeSTUDY(int rep) throws HL7Exception {
        return (PEX_P07_STUDY)super.removeRepetition("STUDY", rep);
    }
}

