/*
 * Decompiled with CFR 0.152.
 */
package cn.jiguang.common.connection;

import cn.jiguang.common.connection.NettyHttpClient;
import cn.jiguang.common.resp.ResponseWrapper;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.CharsetUtil;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class HttpResponseHandler
extends SimpleChannelInboundHandler<HttpObject> {
    private static final Logger LOG = LoggerFactory.getLogger(HttpResponseHandler.class);
    private int status;
    private NettyHttpClient.BaseCallback _callback;
    private CountDownLatch _latch;
    private ResponseWrapper _wrapper = new ResponseWrapper();

    public HttpResponseHandler(NettyHttpClient.BaseCallback callback, CountDownLatch latch) {
        this._callback = callback;
        this._latch = latch;
    }

    protected void channelRead0(ChannelHandlerContext ctx, HttpObject msg) throws Exception {
        if (msg instanceof HttpResponse) {
            HttpResponse response = (HttpResponse)msg;
            this.status = response.status().code();
        }
        if (msg instanceof HttpContent) {
            HttpContent content = (HttpContent)msg;
            LOG.info(content.content().toString());
            if (content instanceof LastHttpContent) {
                LOG.info("closing connection");
                ctx.close();
            } else {
                String responseContent = content.content().toString(CharsetUtil.UTF_8);
                this._wrapper.responseCode = this.status;
                this._wrapper.responseContent = responseContent;
                if (this.status >= 200 && this.status < 300) {
                    LOG.debug("Succeed to get response OK - responseCode:" + this.status);
                    LOG.debug("Response Content - " + responseContent);
                } else if (this.status >= 300 && this.status < 400) {
                    LOG.warn("Normal response but unexpected - responseCode:" + this.status + ", responseContent:" + responseContent);
                } else {
                    LOG.warn("Got error response - responseCode:" + this.status + ", responseContent:" + responseContent);
                    switch (this.status) {
                        case 400: {
                            LOG.error("Your request params is invalid. Please check them according to error message.");
                            this._wrapper.setErrorObject();
                            break;
                        }
                        case 401: {
                            LOG.error("Authentication failed! Please check authentication params according to docs.");
                            this._wrapper.setErrorObject();
                            break;
                        }
                        case 403: {
                            LOG.error("Request is forbidden! Maybe your appkey is listed in blacklist or your params is invalid.");
                            this._wrapper.setErrorObject();
                            break;
                        }
                        case 404: {
                            LOG.error("Request page is not found! Maybe your params is invalid.");
                            this._wrapper.setErrorObject();
                            break;
                        }
                        case 410: {
                            LOG.error("Request resource is no longer in service. Please according to notice on official website.");
                            this._wrapper.setErrorObject();
                        }
                        case 429: {
                            LOG.error("Too many requests! Please review your appkey's request quota.");
                            this._wrapper.setErrorObject();
                            break;
                        }
                        case 500: 
                        case 502: 
                        case 503: 
                        case 504: {
                            LOG.error("Seems encountered server error. Maybe JPush is in maintenance? Please retry later.");
                            break;
                        }
                        default: {
                            LOG.error("Unexpected response.");
                        }
                    }
                }
                if (null != this._latch) {
                    this._latch.countDown();
                }
                if (null != this._callback) {
                    this._callback.onSucceed(this._wrapper);
                }
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        LOG.error("error:", cause);
        try {
            ctx.close();
            if (null != this._latch) {
                this._latch.countDown();
            }
        }
        catch (Exception ex) {
            LOG.error("close error:", (Throwable)ex);
        }
    }

    public void resetLatch(CountDownLatch latch) {
        this._latch = latch;
    }

    public ResponseWrapper getResponse() {
        return this._wrapper;
    }
}

