/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.ModifyNetworkInterfaceAttributeRequest;
import com.amazonaws.services.ec2.model.NetworkInterfaceAttachmentChanges;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class ModifyNetworkInterfaceAttributeRequestMarshaller
implements Marshaller<Request<ModifyNetworkInterfaceAttributeRequest>, ModifyNetworkInterfaceAttributeRequest> {
    public Request<ModifyNetworkInterfaceAttributeRequest> marshall(ModifyNetworkInterfaceAttributeRequest modifyNetworkInterfaceAttributeRequest) {
        if (modifyNetworkInterfaceAttributeRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyNetworkInterfaceAttributeRequest, "AmazonEC2");
        request.addParameter("Action", "ModifyNetworkInterfaceAttribute");
        request.addParameter("Version", "2015-04-15");
        if (modifyNetworkInterfaceAttributeRequest.getNetworkInterfaceId() != null) {
            request.addParameter("NetworkInterfaceId", StringUtils.fromString((String)modifyNetworkInterfaceAttributeRequest.getNetworkInterfaceId()));
        }
        if (modifyNetworkInterfaceAttributeRequest.getDescription() != null) {
            request.addParameter("Description.Value", StringUtils.fromString((String)modifyNetworkInterfaceAttributeRequest.getDescription()));
        }
        if (modifyNetworkInterfaceAttributeRequest.isSourceDestCheck() != null) {
            request.addParameter("SourceDestCheck.Value", StringUtils.fromBoolean((Boolean)modifyNetworkInterfaceAttributeRequest.isSourceDestCheck()));
        }
        List<String> groupsList = modifyNetworkInterfaceAttributeRequest.getGroups();
        int groupsListIndex = 1;
        for (String groupsListValue : groupsList) {
            if (groupsListValue != null) {
                request.addParameter("SecurityGroupId." + groupsListIndex, StringUtils.fromString((String)groupsListValue));
            }
            ++groupsListIndex;
        }
        NetworkInterfaceAttachmentChanges networkInterfaceAttachmentChangesAttachment = modifyNetworkInterfaceAttributeRequest.getAttachment();
        if (networkInterfaceAttachmentChangesAttachment != null) {
            if (networkInterfaceAttachmentChangesAttachment.getAttachmentId() != null) {
                request.addParameter("Attachment.AttachmentId", StringUtils.fromString((String)networkInterfaceAttachmentChangesAttachment.getAttachmentId()));
            }
            if (networkInterfaceAttachmentChangesAttachment.isDeleteOnTermination() != null) {
                request.addParameter("Attachment.DeleteOnTermination", StringUtils.fromBoolean((Boolean)networkInterfaceAttachmentChangesAttachment.isDeleteOnTermination()));
            }
        }
        return request;
    }
}

