/*
 * Decompiled with CFR 0.152.
 */
package com.github.tennaito.rsql.jpa;

import com.github.tennaito.rsql.jpa.AbstractJpaVisitor;
import com.github.tennaito.rsql.jpa.JpaPredicateVisitor;
import cz.jirutka.rsql.parser.ast.AndNode;
import cz.jirutka.rsql.parser.ast.ComparisonNode;
import cz.jirutka.rsql.parser.ast.OrNode;
import cz.jirutka.rsql.parser.ast.RSQLVisitor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaCriteriaCountQueryVisitor<T>
extends AbstractJpaVisitor<CriteriaQuery<Long>, T>
implements RSQLVisitor<CriteriaQuery<Long>, EntityManager> {
    private static final Logger LOG = Logger.getLogger(JpaCriteriaCountQueryVisitor.class.getName());
    private final JpaPredicateVisitor<T> predicateVisitor;
    private Root<T> root;

    @SafeVarargs
    public JpaCriteriaCountQueryVisitor(T ... t) {
        super(t);
        this.predicateVisitor = new JpaPredicateVisitor<T>(t);
    }

    protected JpaPredicateVisitor<T> getPredicateVisitor() {
        this.predicateVisitor.setBuilderTools(this.getBuilderTools());
        return this.predicateVisitor;
    }

    public CriteriaQuery<Long> visit(AndNode node, EntityManager entityManager) {
        LOG.log(Level.INFO, "Creating CriteriaQuery for AndNode: {0}", node);
        CriteriaBuilder cb = entityManager.getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(Long.class);
        this.root = cq.from(this.entityClass);
        cq.select((Selection)cb.countDistinct(this.root));
        cq.where((Expression)this.getPredicateVisitor().defineRoot((From)this.root).visit(node, entityManager));
        return cq;
    }

    public CriteriaQuery<Long> visit(OrNode node, EntityManager entityManager) {
        LOG.log(Level.INFO, "Creating CriteriaQuery for OrNode: {0}", node);
        CriteriaBuilder cb = entityManager.getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(Long.class);
        this.root = cq.from(this.entityClass);
        cq.select((Selection)cb.countDistinct(this.root));
        this.root = cq.from(this.entityClass);
        cq.where((Expression)this.getPredicateVisitor().defineRoot((From)this.root).visit(node, entityManager));
        return cq;
    }

    public CriteriaQuery<Long> visit(ComparisonNode node, EntityManager entityManager) {
        LOG.log(Level.INFO, "Creating CriteriaQuery for ComparisonNode: {0}", node);
        CriteriaBuilder cb = entityManager.getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(Long.class);
        this.root = cq.from(this.entityClass);
        cq.select((Selection)cb.countDistinct(this.root));
        cq.where((Expression)this.getPredicateVisitor().defineRoot((From)this.root).visit(node, entityManager));
        return cq;
    }

    public Root<T> getRoot() {
        return this.root;
    }

    public void setRoot(Root<T> root) {
        this.root = root;
    }
}

