/*
 * Decompiled with CFR 0.152.
 */
package com.github.tobato.fastdfs.domain.fdfs;

import com.github.tobato.fastdfs.domain.proto.mapper.FdfsColumn;
import java.text.SimpleDateFormat;

public class FileInfo {
    @FdfsColumn(index=0)
    private long fileSize;
    @FdfsColumn(index=1)
    private long createTime;
    @FdfsColumn(index=2)
    private int crc32;
    @FdfsColumn(index=3, max=16)
    private String sourceIpAddr;

    public FileInfo() {
    }

    public FileInfo(String sourceIpAddr, long fileSize, long createTime, int crc32) {
        this.sourceIpAddr = sourceIpAddr;
        this.fileSize = fileSize;
        this.createTime = createTime;
        this.crc32 = crc32;
    }

    public String getSourceIpAddr() {
        return this.sourceIpAddr;
    }

    public void setSourceIpAddr(String sourceIpAddr) {
        this.sourceIpAddr = sourceIpAddr;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public int getCrc32() {
        return this.crc32;
    }

    public void setCrc32(int crc32) {
        this.crc32 = crc32;
    }

    public String toString() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return "source_ip_addr = " + this.sourceIpAddr + ", file_size = " + this.fileSize + ", create_timestamp = " + df.format(this.createTime * 1000L) + ", crc32 = " + this.crc32;
    }
}

