/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wickedcharts.highcharts.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.googlecode.wickedcharts.highcharts.jackson.ColorReferenceSerializer;
import com.googlecode.wickedcharts.highcharts.options.color.HighchartsColor;
import java.io.IOException;
import java.util.Locale;

public class HighchartsColorReferenceSerializer
extends ColorReferenceSerializer<HighchartsColor> {
    private static final String HIGHCHARTS_COLOR = "Highcharts.getOptions().colors[%d]";

    @Override
    protected void serializeIfNotNull(HighchartsColor color, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        if (color.getBrightness() == null) {
            jgen.writeRawValue(String.format(HIGHCHARTS_COLOR, color.getHighchartsIndex()));
        } else {
            String colorString = String.format(Locale.ENGLISH, HIGHCHARTS_COLOR, color.getHighchartsIndex());
            colorString = this.brighten(colorString, color.getBrightness().floatValue());
            jgen.writeRawValue(colorString);
        }
    }
}

