/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wickedcharts.highcharts.options.color;

import com.googlecode.wickedcharts.highcharts.options.color.ColorReference;
import java.util.ArrayList;
import java.util.List;

public class HexColor
extends ColorReference {
    private static final long serialVersionUID = 1L;
    private final String hexColor;

    public static ColorReference fromString(String color) {
        return new HexColor(color);
    }

    public static List<ColorReference> fromStrings(String color1, String ... colors) {
        ArrayList<ColorReference> resultList = new ArrayList<ColorReference>();
        resultList.add(new HexColor(color1));
        for (String color : colors) {
            resultList.add(new HexColor(color));
        }
        return resultList;
    }

    public HexColor(String hexColor) {
        this.hexColor = hexColor.toLowerCase();
        if (!hexColor.matches("^#[0-9a-fA-F]{6}$")) {
            throw new IllegalArgumentException("Invalid hex color format: " + hexColor + ". A hex color must be of the format \"^#[0-9a-fA-F]{6}$\".");
        }
    }

    @Override
    protected ColorReference copy() {
        HexColor copy = new HexColor(this.hexColor);
        copy.setBrightness(this.getBrightness());
        return copy;
    }

    public String getHexColor() {
        return this.hexColor;
    }
}

