/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.management.compute;

import com.microsoft.windowsazure.core.LazyCollection;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.OperationStatus;
import com.microsoft.windowsazure.core.OperationStatusResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceRequestFilter;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceResponseFilter;
import com.microsoft.windowsazure.core.utils.Base64;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.CloudError;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.compute.ComputeManagementClient;
import com.microsoft.windowsazure.management.compute.ComputeManagementClientImpl;
import com.microsoft.windowsazure.management.compute.ExtensionImageOperations;
import com.microsoft.windowsazure.management.compute.models.ExtensionEndpointConfiguration;
import com.microsoft.windowsazure.management.compute.models.ExtensionImageRegisterParameters;
import com.microsoft.windowsazure.management.compute.models.ExtensionImageUpdateParameters;
import com.microsoft.windowsazure.management.compute.models.ExtensionLocalResourceConfiguration;
import com.microsoft.windowsazure.tracing.ClientRequestTrackingHandler;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class ExtensionImageOperationsImpl
implements ServiceOperations<ComputeManagementClientImpl>,
ExtensionImageOperations {
    private ComputeManagementClientImpl client;

    ExtensionImageOperationsImpl(ComputeManagementClientImpl client) {
        this.client = client;
    }

    public ComputeManagementClientImpl getClient() {
        return this.client;
    }

    @Override
    public Future<OperationResponse> beginRegisteringAsync(final ExtensionImageRegisterParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return ExtensionImageOperationsImpl.this.beginRegistering(parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse beginRegistering(ExtensionImageRegisterParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getCertificate() != null && parameters.getCertificate().getStoreLocation() == null) {
            throw new NullPointerException("parameters.Certificate.StoreLocation");
        }
        if (parameters.getExtensionEndpoints() != null) {
            if (parameters.getExtensionEndpoints().getInputEndpoints() != null) {
                for (ExtensionEndpointConfiguration.InputEndpoint inputEndpointsParameterItem : parameters.getExtensionEndpoints().getInputEndpoints()) {
                    if (inputEndpointsParameterItem.getName() == null) {
                        throw new NullPointerException("parameters.ExtensionEndpoints.InputEndpoints.Name");
                    }
                    if (inputEndpointsParameterItem.getProtocol() != null) continue;
                    throw new NullPointerException("parameters.ExtensionEndpoints.InputEndpoints.Protocol");
                }
            }
            if (parameters.getExtensionEndpoints().getInternalEndpoints() != null) {
                for (ExtensionEndpointConfiguration.InternalEndpoint internalEndpointsParameterItem : parameters.getExtensionEndpoints().getInternalEndpoints()) {
                    if (internalEndpointsParameterItem.getName() == null) {
                        throw new NullPointerException("parameters.ExtensionEndpoints.InternalEndpoints.Name");
                    }
                    if (internalEndpointsParameterItem.getProtocol() != null) continue;
                    throw new NullPointerException("parameters.ExtensionEndpoints.InternalEndpoints.Protocol");
                }
            }
        }
        if (parameters.getLocalResources() != null) {
            for (ExtensionLocalResourceConfiguration localResourcesParameterItem : parameters.getLocalResources()) {
                if (localResourcesParameterItem.getName() != null) continue;
                throw new NullPointerException("parameters.LocalResources.Name");
            }
        }
        if (parameters.getProviderNameSpace() == null) {
            throw new NullPointerException("parameters.ProviderNameSpace");
        }
        if (parameters.getType() == null) {
            throw new NullPointerException("parameters.Type");
        }
        if (parameters.getVersion() == null) {
            throw new NullPointerException("parameters.Version");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, ExtensionImageRegisterParameters> tracingParameters = new HashMap<String, ExtensionImageRegisterParameters>();
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginRegisteringAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/extensions";
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2015-04-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        Element extensionImageElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ExtensionImage");
        requestDoc.appendChild(extensionImageElement);
        Element providerNameSpaceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ProviderNameSpace");
        providerNameSpaceElement.appendChild(requestDoc.createTextNode(parameters.getProviderNameSpace()));
        extensionImageElement.appendChild(providerNameSpaceElement);
        Element typeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Type");
        typeElement.appendChild(requestDoc.createTextNode(parameters.getType()));
        extensionImageElement.appendChild(typeElement);
        Element versionElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Version");
        versionElement.appendChild(requestDoc.createTextNode(parameters.getVersion()));
        extensionImageElement.appendChild(versionElement);
        if (parameters.getLabel() != null) {
            Element labelElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Label");
            labelElement.appendChild(requestDoc.createTextNode(parameters.getLabel()));
            extensionImageElement.appendChild(labelElement);
        }
        if (parameters.getHostingResources() != null) {
            Element hostingResourcesElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "HostingResources");
            hostingResourcesElement.appendChild(requestDoc.createTextNode(parameters.getHostingResources()));
            extensionImageElement.appendChild(hostingResourcesElement);
        }
        if (parameters.getMediaLink() != null) {
            Element mediaLinkElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "MediaLink");
            mediaLinkElement.appendChild(requestDoc.createTextNode(parameters.getMediaLink().toString()));
            extensionImageElement.appendChild(mediaLinkElement);
        }
        if (parameters.getCertificate() != null) {
            Element certificateElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Certificate");
            extensionImageElement.appendChild(certificateElement);
            Element storeLocationElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "StoreLocation");
            storeLocationElement.appendChild(requestDoc.createTextNode(parameters.getCertificate().getStoreLocation()));
            certificateElement.appendChild(storeLocationElement);
            if (parameters.getCertificate().getStoreName() != null) {
                Element storeNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "StoreName");
                storeNameElement.appendChild(requestDoc.createTextNode(parameters.getCertificate().getStoreName()));
                certificateElement.appendChild(storeNameElement);
            }
            if (parameters.getCertificate().isThumbprintRequired() != null) {
                Element thumbprintRequiredElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ThumbprintRequired");
                thumbprintRequiredElement.appendChild(requestDoc.createTextNode(Boolean.toString(parameters.getCertificate().isThumbprintRequired()).toLowerCase()));
                certificateElement.appendChild(thumbprintRequiredElement);
            }
            if (parameters.getCertificate().getThumbprintAlgorithm() != null) {
                Element thumbprintAlgorithmElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ThumbprintAlgorithm");
                thumbprintAlgorithmElement.appendChild(requestDoc.createTextNode(parameters.getCertificate().getThumbprintAlgorithm()));
                certificateElement.appendChild(thumbprintAlgorithmElement);
            }
        }
        if (parameters.getExtensionEndpoints() != null) {
            Element endpointsElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Endpoints");
            extensionImageElement.appendChild(endpointsElement);
            if (parameters.getExtensionEndpoints().getInputEndpoints() != null && (!(parameters.getExtensionEndpoints().getInputEndpoints() instanceof LazyCollection) || ((LazyCollection)parameters.getExtensionEndpoints().getInputEndpoints()).isInitialized())) {
                Element inputEndpointsSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "InputEndpoints");
                for (ExtensionEndpointConfiguration.InputEndpoint inputEndpointsItem : parameters.getExtensionEndpoints().getInputEndpoints()) {
                    Element inputEndpointElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "InputEndpoint");
                    inputEndpointsSequenceElement.appendChild(inputEndpointElement);
                    Element nameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
                    nameElement.appendChild(requestDoc.createTextNode(inputEndpointsItem.getName()));
                    inputEndpointElement.appendChild(nameElement);
                    Element protocolElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Protocol");
                    protocolElement.appendChild(requestDoc.createTextNode(inputEndpointsItem.getProtocol()));
                    inputEndpointElement.appendChild(protocolElement);
                    Element portElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Port");
                    portElement.appendChild(requestDoc.createTextNode(Integer.toString(inputEndpointsItem.getPort())));
                    inputEndpointElement.appendChild(portElement);
                    Element localPortElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "LocalPort");
                    localPortElement.appendChild(requestDoc.createTextNode(Integer.toString(inputEndpointsItem.getLocalPort())));
                    inputEndpointElement.appendChild(localPortElement);
                }
                endpointsElement.appendChild(inputEndpointsSequenceElement);
            }
            if (parameters.getExtensionEndpoints().getInternalEndpoints() != null && (!(parameters.getExtensionEndpoints().getInternalEndpoints() instanceof LazyCollection) || ((LazyCollection)parameters.getExtensionEndpoints().getInternalEndpoints()).isInitialized())) {
                Element internalEndpointsSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "InternalEndpoints");
                for (ExtensionEndpointConfiguration.InternalEndpoint internalEndpointsItem : parameters.getExtensionEndpoints().getInternalEndpoints()) {
                    Element internalEndpointElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "InternalEndpoint");
                    internalEndpointsSequenceElement.appendChild(internalEndpointElement);
                    Element nameElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
                    nameElement2.appendChild(requestDoc.createTextNode(internalEndpointsItem.getName()));
                    internalEndpointElement.appendChild(nameElement2);
                    Element protocolElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Protocol");
                    protocolElement2.appendChild(requestDoc.createTextNode(internalEndpointsItem.getProtocol()));
                    internalEndpointElement.appendChild(protocolElement2);
                    Element portElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Port");
                    portElement2.appendChild(requestDoc.createTextNode(Integer.toString(internalEndpointsItem.getPort())));
                    internalEndpointElement.appendChild(portElement2);
                }
                endpointsElement.appendChild(internalEndpointsSequenceElement);
            }
        }
        if (parameters.getPublicConfigurationSchema() != null) {
            Element publicConfigurationSchemaElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "PublicConfigurationSchema");
            publicConfigurationSchemaElement.appendChild(requestDoc.createTextNode(Base64.encode((byte[])parameters.getPublicConfigurationSchema().getBytes())));
            extensionImageElement.appendChild(publicConfigurationSchemaElement);
        }
        if (parameters.getPrivateConfigurationSchema() != null) {
            Element privateConfigurationSchemaElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "PrivateConfigurationSchema");
            privateConfigurationSchemaElement.appendChild(requestDoc.createTextNode(Base64.encode((byte[])parameters.getPrivateConfigurationSchema().getBytes())));
            extensionImageElement.appendChild(privateConfigurationSchemaElement);
        }
        if (parameters.getDescription() != null) {
            Element descriptionElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Description");
            descriptionElement.appendChild(requestDoc.createTextNode(parameters.getDescription()));
            extensionImageElement.appendChild(descriptionElement);
        }
        if (parameters.getPublisherName() != null) {
            Element publisherNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "PublisherName");
            publisherNameElement.appendChild(requestDoc.createTextNode(parameters.getPublisherName()));
            extensionImageElement.appendChild(publisherNameElement);
        }
        if (parameters.getPublishedDate() != null) {
            Element publishedDateElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "PublishedDate");
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            publishedDateElement.appendChild(requestDoc.createTextNode(simpleDateFormat.format(parameters.getPublishedDate().getTime())));
            extensionImageElement.appendChild(publishedDateElement);
        }
        if (parameters.getLocalResources() != null) {
            Element localResourcesSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "LocalResources");
            for (ExtensionLocalResourceConfiguration localResourcesItem : parameters.getLocalResources()) {
                Element localResourceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "LocalResource");
                localResourcesSequenceElement.appendChild(localResourceElement);
                Element nameElement3 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
                nameElement3.appendChild(requestDoc.createTextNode(localResourcesItem.getName()));
                localResourceElement.appendChild(nameElement3);
                if (localResourcesItem.getSizeInMB() == null) continue;
                Element sizeInMBElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "SizeInMB");
                sizeInMBElement.appendChild(requestDoc.createTextNode(Integer.toString(localResourcesItem.getSizeInMB())));
                localResourceElement.appendChild(sizeInMBElement);
            }
            extensionImageElement.appendChild(localResourcesSequenceElement);
        }
        if (parameters.isBlockRoleUponFailure() != null) {
            Element blockRoleUponFailureElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "BlockRoleUponFailure");
            blockRoleUponFailureElement.appendChild(requestDoc.createTextNode(Boolean.toString(parameters.isBlockRoleUponFailure()).toLowerCase()));
            extensionImageElement.appendChild(blockRoleUponFailureElement);
        }
        if (parameters.isInternalExtension() != null) {
            Element isInternalExtensionElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "IsInternalExtension");
            isInternalExtensionElement.appendChild(requestDoc.createTextNode(Boolean.toString(parameters.isInternalExtension()).toLowerCase()));
            extensionImageElement.appendChild(isInternalExtensionElement);
        }
        if (parameters.getSampleConfig() != null) {
            Element sampleConfigElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "SampleConfig");
            sampleConfigElement.appendChild(requestDoc.createTextNode(parameters.getSampleConfig()));
            extensionImageElement.appendChild(sampleConfigElement);
        }
        if (parameters.isReplicationCompleted() != null) {
            Element replicationCompletedElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ReplicationCompleted");
            replicationCompletedElement.appendChild(requestDoc.createTextNode(Boolean.toString(parameters.isReplicationCompleted()).toLowerCase()));
            extensionImageElement.appendChild(replicationCompletedElement);
        }
        if (parameters.getEula() != null) {
            Element eulaElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Eula");
            eulaElement.appendChild(requestDoc.createTextNode(parameters.getEula().toString()));
            extensionImageElement.appendChild(eulaElement);
        }
        if (parameters.getPrivacyUri() != null) {
            Element privacyUriElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "PrivacyUri");
            privacyUriElement.appendChild(requestDoc.createTextNode(parameters.getPrivacyUri().toString()));
            extensionImageElement.appendChild(privacyUriElement);
        }
        if (parameters.getHomepageUri() != null) {
            Element homepageUriElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "HomepageUri");
            homepageUriElement.appendChild(requestDoc.createTextNode(parameters.getHomepageUri().toString()));
            extensionImageElement.appendChild(homepageUriElement);
        }
        if (parameters.isJsonExtension() != null) {
            Element isJsonExtensionElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "IsJsonExtension");
            isJsonExtensionElement.appendChild(requestDoc.createTextNode(Boolean.toString(parameters.isJsonExtension()).toLowerCase()));
            extensionImageElement.appendChild(isJsonExtensionElement);
        }
        if (parameters.isDisallowMajorVersionUpgrade() != null) {
            Element disallowMajorVersionUpgradeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "DisallowMajorVersionUpgrade");
            disallowMajorVersionUpgradeElement.appendChild(requestDoc.createTextNode(Boolean.toString(parameters.isDisallowMajorVersionUpgrade()).toLowerCase()));
            extensionImageElement.appendChild(disallowMajorVersionUpgradeElement);
        }
        if (parameters.getSupportedOS() != null) {
            Element supportedOSElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "SupportedOS");
            supportedOSElement.appendChild(requestDoc.createTextNode(parameters.getSupportedOS()));
            extensionImageElement.appendChild(supportedOSElement);
        }
        if (parameters.getCompanyName() != null) {
            Element companyNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "CompanyName");
            companyNameElement.appendChild(requestDoc.createTextNode(parameters.getCompanyName()));
            extensionImageElement.appendChild(companyNameElement);
        }
        if (parameters.getRegions() != null) {
            Element regionsElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Regions");
            regionsElement.appendChild(requestDoc.createTextNode(parameters.getRegions()));
            extensionImageElement.appendChild(regionsElement);
        }
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationResponse> beginUnregisteringAsync(final String providerNamespace, final String type, final String version) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return ExtensionImageOperationsImpl.this.beginUnregistering(providerNamespace, type, version);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse beginUnregistering(String providerNamespace, String type, String version) throws IOException, ServiceException {
        if (providerNamespace == null) {
            throw new NullPointerException("providerNamespace");
        }
        if (type == null) {
            throw new NullPointerException("type");
        }
        if (version == null) {
            throw new NullPointerException("version");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("providerNamespace", providerNamespace);
            tracingParameters.put("type", type);
            tracingParameters.put("version", version);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginUnregisteringAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/extensions/";
        url = url + URLEncoder.encode(providerNamespace, "UTF-8");
        url = url + "/";
        url = url + URLEncoder.encode(type, "UTF-8");
        url = url + "/";
        url = url + URLEncoder.encode(version, "UTF-8");
        String baseUrl = this.getClient().getBaseUri().toString();
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2015-04-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationResponse> beginUpdatingAsync(final ExtensionImageUpdateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return ExtensionImageOperationsImpl.this.beginUpdating(parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse beginUpdating(ExtensionImageUpdateParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        String baseUrl;
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getCertificate() != null && parameters.getCertificate().getStoreLocation() == null) {
            throw new NullPointerException("parameters.Certificate.StoreLocation");
        }
        if (parameters.getExtensionEndpoints() != null) {
            if (parameters.getExtensionEndpoints().getInputEndpoints() != null) {
                for (ExtensionEndpointConfiguration.InputEndpoint inputEndpointsParameterItem : parameters.getExtensionEndpoints().getInputEndpoints()) {
                    if (inputEndpointsParameterItem.getName() == null) {
                        throw new NullPointerException("parameters.ExtensionEndpoints.InputEndpoints.Name");
                    }
                    if (inputEndpointsParameterItem.getProtocol() != null) continue;
                    throw new NullPointerException("parameters.ExtensionEndpoints.InputEndpoints.Protocol");
                }
            }
            if (parameters.getExtensionEndpoints().getInternalEndpoints() != null) {
                for (ExtensionEndpointConfiguration.InternalEndpoint internalEndpointsParameterItem : parameters.getExtensionEndpoints().getInternalEndpoints()) {
                    if (internalEndpointsParameterItem.getName() == null) {
                        throw new NullPointerException("parameters.ExtensionEndpoints.InternalEndpoints.Name");
                    }
                    if (internalEndpointsParameterItem.getProtocol() != null) continue;
                    throw new NullPointerException("parameters.ExtensionEndpoints.InternalEndpoints.Protocol");
                }
            }
        }
        if (parameters.getLocalResources() != null) {
            for (ExtensionLocalResourceConfiguration localResourcesParameterItem : parameters.getLocalResources()) {
                if (localResourcesParameterItem.getName() != null) continue;
                throw new NullPointerException("parameters.LocalResources.Name");
            }
        }
        if (parameters.getProviderNameSpace() == null) {
            throw new NullPointerException("parameters.ProviderNameSpace");
        }
        if (parameters.getType() == null) {
            throw new NullPointerException("parameters.Type");
        }
        if (parameters.getVersion() == null) {
            throw new NullPointerException("parameters.Version");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, ExtensionImageUpdateParameters> tracingParameters = new HashMap<String, ExtensionImageUpdateParameters>();
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginUpdatingAsync", tracingParameters);
        }
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/extensions";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("action=update");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPut httpRequest = new HttpPut(url);
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2015-04-01");
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        Element extensionImageElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ExtensionImage");
        requestDoc.appendChild(extensionImageElement);
        Element providerNameSpaceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ProviderNameSpace");
        providerNameSpaceElement.appendChild(requestDoc.createTextNode(parameters.getProviderNameSpace()));
        extensionImageElement.appendChild(providerNameSpaceElement);
        Element typeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Type");
        typeElement.appendChild(requestDoc.createTextNode(parameters.getType()));
        extensionImageElement.appendChild(typeElement);
        Element versionElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Version");
        versionElement.appendChild(requestDoc.createTextNode(parameters.getVersion()));
        extensionImageElement.appendChild(versionElement);
        if (parameters.getLabel() != null) {
            Element labelElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Label");
            labelElement.appendChild(requestDoc.createTextNode(parameters.getLabel()));
            extensionImageElement.appendChild(labelElement);
        }
        if (parameters.getHostingResources() != null) {
            Element hostingResourcesElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "HostingResources");
            hostingResourcesElement.appendChild(requestDoc.createTextNode(parameters.getHostingResources()));
            extensionImageElement.appendChild(hostingResourcesElement);
        }
        if (parameters.getMediaLink() != null) {
            Element mediaLinkElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "MediaLink");
            mediaLinkElement.appendChild(requestDoc.createTextNode(parameters.getMediaLink().toString()));
            extensionImageElement.appendChild(mediaLinkElement);
        }
        if (parameters.getCertificate() != null) {
            Element certificateElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Certificate");
            extensionImageElement.appendChild(certificateElement);
            Element storeLocationElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "StoreLocation");
            storeLocationElement.appendChild(requestDoc.createTextNode(parameters.getCertificate().getStoreLocation()));
            certificateElement.appendChild(storeLocationElement);
            if (parameters.getCertificate().getStoreName() != null) {
                Element storeNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "StoreName");
                storeNameElement.appendChild(requestDoc.createTextNode(parameters.getCertificate().getStoreName()));
                certificateElement.appendChild(storeNameElement);
            }
            if (parameters.getCertificate().isThumbprintRequired() != null) {
                Element thumbprintRequiredElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ThumbprintRequired");
                thumbprintRequiredElement.appendChild(requestDoc.createTextNode(Boolean.toString(parameters.getCertificate().isThumbprintRequired()).toLowerCase()));
                certificateElement.appendChild(thumbprintRequiredElement);
            }
            if (parameters.getCertificate().getThumbprintAlgorithm() != null) {
                Element thumbprintAlgorithmElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ThumbprintAlgorithm");
                thumbprintAlgorithmElement.appendChild(requestDoc.createTextNode(parameters.getCertificate().getThumbprintAlgorithm()));
                certificateElement.appendChild(thumbprintAlgorithmElement);
            }
        }
        if (parameters.getExtensionEndpoints() != null) {
            Element endpointsElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Endpoints");
            extensionImageElement.appendChild(endpointsElement);
            if (parameters.getExtensionEndpoints().getInputEndpoints() != null && (!(parameters.getExtensionEndpoints().getInputEndpoints() instanceof LazyCollection) || ((LazyCollection)parameters.getExtensionEndpoints().getInputEndpoints()).isInitialized())) {
                Element inputEndpointsSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "InputEndpoints");
                for (ExtensionEndpointConfiguration.InputEndpoint inputEndpointsItem : parameters.getExtensionEndpoints().getInputEndpoints()) {
                    Element inputEndpointElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "InputEndpoint");
                    inputEndpointsSequenceElement.appendChild(inputEndpointElement);
                    Element nameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
                    nameElement.appendChild(requestDoc.createTextNode(inputEndpointsItem.getName()));
                    inputEndpointElement.appendChild(nameElement);
                    Element protocolElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Protocol");
                    protocolElement.appendChild(requestDoc.createTextNode(inputEndpointsItem.getProtocol()));
                    inputEndpointElement.appendChild(protocolElement);
                    Element portElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Port");
                    portElement.appendChild(requestDoc.createTextNode(Integer.toString(inputEndpointsItem.getPort())));
                    inputEndpointElement.appendChild(portElement);
                    Element localPortElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "LocalPort");
                    localPortElement.appendChild(requestDoc.createTextNode(Integer.toString(inputEndpointsItem.getLocalPort())));
                    inputEndpointElement.appendChild(localPortElement);
                }
                endpointsElement.appendChild(inputEndpointsSequenceElement);
            }
            if (parameters.getExtensionEndpoints().getInternalEndpoints() != null && (!(parameters.getExtensionEndpoints().getInternalEndpoints() instanceof LazyCollection) || ((LazyCollection)parameters.getExtensionEndpoints().getInternalEndpoints()).isInitialized())) {
                Element internalEndpointsSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "InternalEndpoints");
                for (ExtensionEndpointConfiguration.InternalEndpoint internalEndpointsItem : parameters.getExtensionEndpoints().getInternalEndpoints()) {
                    Element internalEndpointElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "InternalEndpoint");
                    internalEndpointsSequenceElement.appendChild(internalEndpointElement);
                    Element nameElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
                    nameElement2.appendChild(requestDoc.createTextNode(internalEndpointsItem.getName()));
                    internalEndpointElement.appendChild(nameElement2);
                    Element protocolElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Protocol");
                    protocolElement2.appendChild(requestDoc.createTextNode(internalEndpointsItem.getProtocol()));
                    internalEndpointElement.appendChild(protocolElement2);
                    Element portElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Port");
                    portElement2.appendChild(requestDoc.createTextNode(Integer.toString(internalEndpointsItem.getPort())));
                    internalEndpointElement.appendChild(portElement2);
                }
                endpointsElement.appendChild(internalEndpointsSequenceElement);
            }
        }
        if (parameters.getPublicConfigurationSchema() != null) {
            Element publicConfigurationSchemaElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "PublicConfigurationSchema");
            publicConfigurationSchemaElement.appendChild(requestDoc.createTextNode(Base64.encode((byte[])parameters.getPublicConfigurationSchema().getBytes())));
            extensionImageElement.appendChild(publicConfigurationSchemaElement);
        }
        if (parameters.getPrivateConfigurationSchema() != null) {
            Element privateConfigurationSchemaElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "PrivateConfigurationSchema");
            privateConfigurationSchemaElement.appendChild(requestDoc.createTextNode(Base64.encode((byte[])parameters.getPrivateConfigurationSchema().getBytes())));
            extensionImageElement.appendChild(privateConfigurationSchemaElement);
        }
        if (parameters.getDescription() != null) {
            Element descriptionElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Description");
            descriptionElement.appendChild(requestDoc.createTextNode(parameters.getDescription()));
            extensionImageElement.appendChild(descriptionElement);
        }
        if (parameters.getPublisherName() != null) {
            Element publisherNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "PublisherName");
            publisherNameElement.appendChild(requestDoc.createTextNode(parameters.getPublisherName()));
            extensionImageElement.appendChild(publisherNameElement);
        }
        if (parameters.getPublishedDate() != null) {
            Element publishedDateElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "PublishedDate");
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            publishedDateElement.appendChild(requestDoc.createTextNode(simpleDateFormat.format(parameters.getPublishedDate().getTime())));
            extensionImageElement.appendChild(publishedDateElement);
        }
        if (parameters.getLocalResources() != null) {
            Element localResourcesSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "LocalResources");
            for (ExtensionLocalResourceConfiguration localResourcesItem : parameters.getLocalResources()) {
                Element localResourceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "LocalResource");
                localResourcesSequenceElement.appendChild(localResourceElement);
                Element nameElement3 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
                nameElement3.appendChild(requestDoc.createTextNode(localResourcesItem.getName()));
                localResourceElement.appendChild(nameElement3);
                if (localResourcesItem.getSizeInMB() == null) continue;
                Element sizeInMBElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "SizeInMB");
                sizeInMBElement.appendChild(requestDoc.createTextNode(Integer.toString(localResourcesItem.getSizeInMB())));
                localResourceElement.appendChild(sizeInMBElement);
            }
            extensionImageElement.appendChild(localResourcesSequenceElement);
        }
        if (parameters.isBlockRoleUponFailure() != null) {
            Element blockRoleUponFailureElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "BlockRoleUponFailure");
            blockRoleUponFailureElement.appendChild(requestDoc.createTextNode(Boolean.toString(parameters.isBlockRoleUponFailure()).toLowerCase()));
            extensionImageElement.appendChild(blockRoleUponFailureElement);
        }
        if (parameters.isInternalExtension() != null) {
            Element isInternalExtensionElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "IsInternalExtension");
            isInternalExtensionElement.appendChild(requestDoc.createTextNode(Boolean.toString(parameters.isInternalExtension()).toLowerCase()));
            extensionImageElement.appendChild(isInternalExtensionElement);
        }
        if (parameters.getSampleConfig() != null) {
            Element sampleConfigElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "SampleConfig");
            sampleConfigElement.appendChild(requestDoc.createTextNode(parameters.getSampleConfig()));
            extensionImageElement.appendChild(sampleConfigElement);
        }
        if (parameters.isReplicationCompleted() != null) {
            Element replicationCompletedElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ReplicationCompleted");
            replicationCompletedElement.appendChild(requestDoc.createTextNode(Boolean.toString(parameters.isReplicationCompleted()).toLowerCase()));
            extensionImageElement.appendChild(replicationCompletedElement);
        }
        if (parameters.getEula() != null) {
            Element eulaElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Eula");
            eulaElement.appendChild(requestDoc.createTextNode(parameters.getEula().toString()));
            extensionImageElement.appendChild(eulaElement);
        }
        if (parameters.getPrivacyUri() != null) {
            Element privacyUriElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "PrivacyUri");
            privacyUriElement.appendChild(requestDoc.createTextNode(parameters.getPrivacyUri().toString()));
            extensionImageElement.appendChild(privacyUriElement);
        }
        if (parameters.getHomepageUri() != null) {
            Element homepageUriElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "HomepageUri");
            homepageUriElement.appendChild(requestDoc.createTextNode(parameters.getHomepageUri().toString()));
            extensionImageElement.appendChild(homepageUriElement);
        }
        if (parameters.isJsonExtension() != null) {
            Element isJsonExtensionElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "IsJsonExtension");
            isJsonExtensionElement.appendChild(requestDoc.createTextNode(Boolean.toString(parameters.isJsonExtension()).toLowerCase()));
            extensionImageElement.appendChild(isJsonExtensionElement);
        }
        if (parameters.isDisallowMajorVersionUpgrade() != null) {
            Element disallowMajorVersionUpgradeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "DisallowMajorVersionUpgrade");
            disallowMajorVersionUpgradeElement.appendChild(requestDoc.createTextNode(Boolean.toString(parameters.isDisallowMajorVersionUpgrade()).toLowerCase()));
            extensionImageElement.appendChild(disallowMajorVersionUpgradeElement);
        }
        if (parameters.getSupportedOS() != null) {
            Element supportedOSElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "SupportedOS");
            supportedOSElement.appendChild(requestDoc.createTextNode(parameters.getSupportedOS()));
            extensionImageElement.appendChild(supportedOSElement);
        }
        if (parameters.getCompanyName() != null) {
            Element companyNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "CompanyName");
            companyNameElement.appendChild(requestDoc.createTextNode(parameters.getCompanyName()));
            extensionImageElement.appendChild(companyNameElement);
        }
        if (parameters.getRegions() != null) {
            Element regionsElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Regions");
            regionsElement.appendChild(requestDoc.createTextNode(parameters.getRegions()));
            extensionImageElement.appendChild(regionsElement);
        }
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationStatusResponse> registerAsync(final ExtensionImageRegisterParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>(){

            @Override
            public OperationStatusResponse call() throws Exception {
                return ExtensionImageOperationsImpl.this.register(parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationStatusResponse register(ExtensionImageRegisterParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, ExtensionImageRegisterParameters> tracingParameters = new HashMap<String, ExtensionImageRegisterParameters>();
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"registerAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (ComputeManagementClient)((ComputeManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            OperationResponse response = client2.getExtensionImagesOperations().beginRegisteringAsync(parameters).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (!(result.getStatus() != OperationStatus.INPROGRESS)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            if (result.getStatus() != OperationStatus.SUCCEEDED) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setError(new CloudError());
                    ex.getError().setCode(result.getError().getCode());
                    ex.getError().setMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationStatusResponse operationStatusResponse = result;
            return operationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<OperationStatusResponse> unregisterAsync(final String providerNamespace, final String type, final String version) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>(){

            @Override
            public OperationStatusResponse call() throws Exception {
                return ExtensionImageOperationsImpl.this.unregister(providerNamespace, type, version);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationStatusResponse unregister(String providerNamespace, String type, String version) throws InterruptedException, ExecutionException, ServiceException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("providerNamespace", providerNamespace);
            tracingParameters.put("type", type);
            tracingParameters.put("version", version);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"unregisterAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (ComputeManagementClient)((ComputeManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            OperationResponse response = client2.getExtensionImagesOperations().beginUnregisteringAsync(providerNamespace, type, version).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (!(result.getStatus() != OperationStatus.INPROGRESS)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            if (result.getStatus() != OperationStatus.SUCCEEDED) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setError(new CloudError());
                    ex.getError().setCode(result.getError().getCode());
                    ex.getError().setMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationStatusResponse operationStatusResponse = result;
            return operationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<OperationStatusResponse> updateAsync(final ExtensionImageUpdateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>(){

            @Override
            public OperationStatusResponse call() throws Exception {
                return ExtensionImageOperationsImpl.this.update(parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationStatusResponse update(ExtensionImageUpdateParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException, ParserConfigurationException, SAXException, TransformerException, URISyntaxException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, ExtensionImageUpdateParameters> tracingParameters = new HashMap<String, ExtensionImageUpdateParameters>();
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"updateAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (ComputeManagementClient)((ComputeManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            OperationResponse response = client2.getExtensionImagesOperations().beginUpdatingAsync(parameters).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (!(result.getStatus() != OperationStatus.INPROGRESS)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            if (result.getStatus() != OperationStatus.SUCCEEDED) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setError(new CloudError());
                    ex.getError().setCode(result.getError().getCode());
                    ex.getError().setMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationStatusResponse operationStatusResponse = result;
            return operationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
}

