/*
 * Decompiled with CFR 0.152.
 */
package com.pastdev.jsch;

import com.jcraft.jsch.IdentityRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import com.jcraft.jsch.agentproxy.AgentProxyException;
import com.jcraft.jsch.agentproxy.Connector;
import com.jcraft.jsch.agentproxy.ConnectorFactory;
import com.jcraft.jsch.agentproxy.RemoteIdentityRepository;
import com.pastdev.jsch.SessionFactory;
import com.pastdev.jsch.Slf4jBridge;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.slf4j.LoggerFactory;

public class DefaultSessionFactory
implements SessionFactory {
    private static org.slf4j.Logger logger = LoggerFactory.getLogger(DefaultSessionFactory.class);
    public static final String PROPERTY_JSCH_DOT_SSH = "jsch.dotSsh";
    public static final String PROPERTY_JSCH_KNOWN_HOSTS_FILE = "jsch.knownHosts.file";
    public static final String PROPERTY_JSCH_PRIVATE_KEY_FILES = "jsch.privateKey.files";
    private Map<String, String> config;
    private File dotSshDir;
    private String hostname;
    private JSch jsch;
    private String password;
    private int port = 22;
    private Proxy proxy;
    private UserInfo userInfo;
    private String username;

    public DefaultSessionFactory() {
        this(null, null, null);
    }

    public DefaultSessionFactory(String username, String hostname, Integer port) {
        JSch.setLogger((Logger)new Slf4jBridge());
        this.jsch = new JSch();
        try {
            this.setDefaultIdentities();
        }
        catch (JSchException e) {
            logger.warn("Unable to set default identities: ", (Throwable)e);
        }
        try {
            this.setDefaultKnownHosts();
        }
        catch (JSchException e) {
            logger.warn("Unable to set default known_hosts: ", (Throwable)e);
        }
        this.username = username == null ? System.getProperty("user.name").toLowerCase() : username;
        this.hostname = hostname == null ? "localhost" : hostname;
        this.port = port == null ? 22 : port;
    }

    private DefaultSessionFactory(JSch jsch, String username, String hostname, int port, Proxy proxy) {
        this.jsch = jsch;
        this.username = username;
        this.hostname = hostname;
        this.port = port;
        this.proxy = proxy;
    }

    private void clearIdentityRepository() throws JSchException {
        this.jsch.setIdentityRepository(null);
        this.jsch.removeAllIdentity();
    }

    private File dotSshDir() {
        if (this.dotSshDir == null) {
            String dotSshString = System.getProperty(PROPERTY_JSCH_DOT_SSH);
            this.dotSshDir = dotSshString != null ? new File(dotSshString) : new File(new File(System.getProperty("user.home")), ".ssh");
        }
        return this.dotSshDir;
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public Proxy getProxy() {
        return this.proxy;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    @Override
    public Session newSession() throws JSchException {
        Session session = this.jsch.getSession(this.username, this.hostname, this.port);
        if (this.config != null) {
            for (String key : this.config.keySet()) {
                session.setConfig(key, this.config.get(key));
            }
        }
        if (this.proxy != null) {
            session.setProxy(this.proxy);
        }
        if (this.password != null) {
            session.setPassword(this.password);
        }
        if (this.userInfo != null) {
            session.setUserInfo(this.userInfo);
        }
        return session;
    }

    @Override
    public SessionFactory.SessionFactoryBuilder newSessionFactoryBuilder() {
        return new SessionFactory.SessionFactoryBuilder(this.jsch, this.username, this.hostname, this.port, this.proxy, this.config, this.userInfo){

            @Override
            public SessionFactory build() {
                DefaultSessionFactory sessionFactory = new DefaultSessionFactory(this.jsch, this.username, this.hostname, this.port, this.proxy);
                sessionFactory.config = this.config;
                sessionFactory.password = DefaultSessionFactory.this.password;
                sessionFactory.userInfo = this.userInfo;
                return sessionFactory;
            }
        };
    }

    public void setConfig(Map<String, String> config) {
        this.config = config;
    }

    public void setConfig(String key, String value) {
        if (this.config == null) {
            this.config = new HashMap<String, String>();
        }
        this.config.put(key, value);
    }

    private void setDefaultKnownHosts() throws JSchException {
        String knownHosts = System.getProperty(PROPERTY_JSCH_KNOWN_HOSTS_FILE);
        if (knownHosts != null && !knownHosts.isEmpty()) {
            this.setKnownHosts(knownHosts);
        } else {
            File knownHostsFile = new File(this.dotSshDir(), "known_hosts");
            if (knownHostsFile.exists()) {
                this.setKnownHosts(knownHostsFile.getAbsolutePath());
            }
        }
    }

    private void setDefaultIdentities() throws JSchException {
        String privateKeyFilesString;
        boolean identitiesSet = false;
        try {
            Connector connector = ConnectorFactory.getDefault().createConnector();
            if (connector != null) {
                logger.info("An AgentProxy Connector was found, check for identities");
                RemoteIdentityRepository repository = new RemoteIdentityRepository(connector);
                Vector identities = repository.getIdentities();
                if (identities.size() > 0) {
                    logger.info("Using AgentProxy identities: {}", (Object)identities);
                    this.setIdentityRepository((IdentityRepository)repository);
                    identitiesSet = true;
                }
            }
        }
        catch (AgentProxyException e) {
            logger.debug("Failed to load any keys from AgentProxy:", (Throwable)e);
        }
        if (!identitiesSet && (privateKeyFilesString = System.getProperty(PROPERTY_JSCH_PRIVATE_KEY_FILES)) != null && !privateKeyFilesString.isEmpty()) {
            logger.info("Using local identities from {}: {}", (Object)PROPERTY_JSCH_PRIVATE_KEY_FILES, (Object)privateKeyFilesString);
            this.setIdentitiesFromPrivateKeys(Arrays.asList(privateKeyFilesString.split(",")));
            identitiesSet = true;
        }
        if (!identitiesSet) {
            ArrayList<String> privateKeyFiles = new ArrayList<String>();
            for (File file : new File[]{new File(this.dotSshDir(), "id_rsa"), new File(this.dotSshDir(), "id_dsa"), new File(this.dotSshDir(), "id_ecdsa")}) {
                if (!file.exists()) continue;
                privateKeyFiles.add(file.getAbsolutePath());
            }
            logger.info("Using local identities: {}", privateKeyFiles);
            this.setIdentitiesFromPrivateKeys(privateKeyFiles);
        }
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setIdentityFromPrivateKey(String privateKey) throws JSchException {
        this.clearIdentityRepository();
        this.jsch.addIdentity(privateKey);
    }

    public void setIdentitiesFromPrivateKeys(List<String> privateKeys) throws JSchException {
        this.clearIdentityRepository();
        for (String privateKey : privateKeys) {
            this.jsch.addIdentity(privateKey);
        }
    }

    public void setIdentityRepository(IdentityRepository identityRepository) {
        this.jsch.setIdentityRepository(identityRepository);
    }

    public void setKnownHosts(InputStream knownHosts) throws JSchException {
        this.jsch.setKnownHosts(knownHosts);
    }

    public void setKnownHosts(String knownHosts) throws JSchException {
        this.jsch.setKnownHosts(knownHosts);
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public void setUserInfo(UserInfo userInfo) {
        this.userInfo = userInfo;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String toString() {
        return (this.proxy == null ? "" : this.proxy.toString() + " ") + "ssh://" + this.username + "@" + this.hostname + ":" + this.port;
    }
}

