/*
 * Decompiled with CFR 0.152.
 */
package com.samczsun.skype4j.events.chat.sent;

import com.samczsun.skype4j.chat.Chat;
import com.samczsun.skype4j.events.chat.ChatEvent;
import com.samczsun.skype4j.formatting.Message;
import com.samczsun.skype4j.formatting.Text;
import com.samczsun.skype4j.user.User;
import java.io.UnsupportedEncodingException;
import javax.xml.bind.DatatypeConverter;

public class LocationReceivedEvent
extends ChatEvent {
    private User sender;
    private LocationInfo info;

    public LocationReceivedEvent(Chat chat, User sender, LocationInfo info) {
        super(chat);
        this.sender = sender;
        this.info = info;
    }

    public User getSender() {
        return this.sender;
    }

    public LocationInfo getLocation() {
        return this.info;
    }

    public static class LocationInfo {
        private String base64;
        private String text;
        private double latitude = Double.NaN;
        private double longitude = Double.NaN;
        private int zoomLevel = -1;
        private String sty;
        private String ss;

        public LocationInfo(String parse, String text) throws IllegalArgumentException {
            this.base64 = parse;
            this.text = text;
            try {
                String[] args;
                for (String s : args = new String(DatatypeConverter.parseBase64Binary((String)parse), "UTF-8").split("&")) {
                    String[] data = s.split("=");
                    if (data[0].equalsIgnoreCase("cp")) {
                        String[] coords = data[1].split("~");
                        this.latitude = Double.parseDouble(coords[0]);
                        this.longitude = Double.parseDouble(coords[1]);
                        continue;
                    }
                    if (data[0].equalsIgnoreCase("lvl")) {
                        this.zoomLevel = Integer.parseInt(data[1]);
                        continue;
                    }
                    if (data[0].equalsIgnoreCase("sty")) {
                        this.sty = data[1];
                        continue;
                    }
                    if (data[0].equalsIgnoreCase("ss")) {
                        this.ss = data[1];
                        continue;
                    }
                    throw new IllegalArgumentException("Unknown argument type " + data[0]);
                }
                if (Double.isNaN(this.latitude) || Double.isNaN(this.longitude) || this.zoomLevel == -1 || this.sty == null || this.ss == null) {
                    throw new IllegalArgumentException("Missing certain parameters in args");
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException("UTF-8 is not supported by your Java installation");
            }
        }

        public double getLatitude() {
            return this.latitude;
        }

        public double getLongitude() {
            return this.longitude;
        }

        public int getZoomLevel() {
            return this.zoomLevel;
        }

        public String getSty() {
            return this.sty;
        }

        public String getSs() {
            return this.ss;
        }

        public String getText() {
            return this.text;
        }

        public Message toMessage() {
            return Message.create().with(Text.rich(this.text).withLink("https://www.bing.com/maps/" + this.base64));
        }
    }
}

