/*
 * Decompiled with CFR 0.152.
 */
package com.samczsun.skype4j.formatting;

import com.samczsun.skype4j.formatting.RichText;
import com.samczsun.skype4j.formatting.Text;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jsoup.Jsoup;

public class Message {
    private final List<Text> components = new ArrayList<Text>();

    private Message() {
    }

    public static Message create() {
        return new Message();
    }

    public Message with(Text text) {
        this.components.add(text);
        return this;
    }

    public String write() {
        StringBuilder result = new StringBuilder();
        for (Text t : this.components) {
            result.append(t);
        }
        return result.toString();
    }

    public String toString() {
        return this.write();
    }

    public String asPlaintext() {
        return Jsoup.parse(this.write()).text();
    }

    public Text child(int index) {
        return this.components.get(index);
    }

    public List<Text> children() {
        return Collections.unmodifiableList(this.components);
    }

    public static Message fromHtml(String text) {
        Message parsed = Message.create();
        parsed.with(RichText.fromHtml(text));
        return parsed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return o.toString().equals(this.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

