/*
 * Decompiled with CFR 0.152.
 */
package com.samczsun.skype4j.formatting;

import com.samczsun.skype4j.formatting.PlainText;
import com.samczsun.skype4j.formatting.RichText;
import com.samczsun.skype4j.formatting.lang.en.Emoticon;
import java.util.Map;
import org.jsoup.helper.Validate;
import org.unbescape.html.HtmlEscape;

public abstract class Text {
    public static final Text NEW_LINE = Text.plain(System.getProperty("line.separator"));
    public static final Text BLANK = Text.plain("");

    public abstract String write();

    public String toString() {
        return this.write();
    }

    public static RichText rich(String text) {
        return new RichText(Text.parseEmojis(HtmlEscape.escapeHtml5Xml(text)));
    }

    public static RichText rich(String format, Object ... params) {
        Validate.notNull(format, "Format was null");
        Validate.notNull(params, "Parameters were null. If you don't want to pass any, consider plain(String)");
        return Text.rich(String.format(format, params));
    }

    public static PlainText plain(String format, Object ... params) {
        Validate.notNull(format, "Format was null");
        Validate.notNull(params, "Parameters were null. If you don't want to pass any, consider plain(String)");
        return Text.plain(String.format(format, params));
    }

    public static PlainText plain(String text) {
        Validate.notNull(text, "The message cannot be null");
        return new PlainText(Text.parseEmojis(HtmlEscape.escapeHtml5Xml(text)));
    }

    public static PlainText plain(byte text) {
        return Text.plain(Integer.toString(text));
    }

    public static PlainText plain(char text) {
        return Text.plain(String.valueOf(text));
    }

    public static PlainText plain(short text) {
        return Text.plain(Integer.toString(text));
    }

    public static PlainText plain(double text) {
        return Text.plain(Double.toString(text));
    }

    public static PlainText plain(float text) {
        return Text.plain(Float.toString(text));
    }

    public static PlainText plain(int text) {
        return Text.plain(Integer.toString(text));
    }

    public static PlainText plain(long text) {
        return Text.plain(Long.toString(text));
    }

    public static PlainText plain(Object text) {
        Validate.notNull(text, "The message cannot be null");
        return Text.plain(text.toString());
    }

    public static PlainText raw(String raw) {
        return new PlainText(raw);
    }

    public static String parseEmojis(String in) {
        Map<String, Emoticon> mapping = Emoticon.getDictionary();
        StringBuilder result = new StringBuilder(in);
        block0: for (int i = 0; i < result.length(); ++i) {
            int end = Math.min(result.length(), result.charAt(i) == '(' ? result.indexOf(")", i) + 1 : i + Emoticon.getLongestEmoji() + 1);
            for (int j = i + 1; j <= end; ++j) {
                String str = result.substring(i, j);
                if (!mapping.containsKey(str) || j != result.length() && result.charAt(j) != ' ') continue;
                String replacement = "<ss type=\"" + mapping.get(str).getId() + "\">" + str + "</ss>";
                result.replace(i, j, replacement);
                i += replacement.length() - 1;
                continue block0;
            }
        }
        return result.toString();
    }
}

