/*
 * Decompiled with CFR 0.152.
 */
package com.samczsun.skype4j.internal;

import com.eclipsesource.json.JsonObject;
import com.samczsun.skype4j.chat.Chat;
import com.samczsun.skype4j.chat.messages.ChatMessage;
import com.samczsun.skype4j.chat.messages.ReceivedMessage;
import com.samczsun.skype4j.chat.messages.SentMessage;
import com.samczsun.skype4j.events.UnsupportedEvent;
import com.samczsun.skype4j.events.chat.ChatEvent;
import com.samczsun.skype4j.events.chat.ChatJoinedEvent;
import com.samczsun.skype4j.events.chat.ChatQuitEvent;
import com.samczsun.skype4j.events.chat.call.CallReceivedEvent;
import com.samczsun.skype4j.events.chat.message.MessageDeletedEvent;
import com.samczsun.skype4j.events.chat.message.MessageEditedEvent;
import com.samczsun.skype4j.events.chat.message.MessageReceivedEvent;
import com.samczsun.skype4j.events.chat.message.MessageSentEvent;
import com.samczsun.skype4j.events.chat.message.SmsReceivedEvent;
import com.samczsun.skype4j.events.chat.sent.ContactReceivedEvent;
import com.samczsun.skype4j.events.chat.sent.FileReceivedEvent;
import com.samczsun.skype4j.events.chat.sent.FlikReceivedEvent;
import com.samczsun.skype4j.events.chat.sent.LocationReceivedEvent;
import com.samczsun.skype4j.events.chat.sent.MultiContactReceivedEvent;
import com.samczsun.skype4j.events.chat.sent.PictureReceivedEvent;
import com.samczsun.skype4j.events.chat.sent.TypingReceivedEvent;
import com.samczsun.skype4j.events.chat.user.LegacyMemberAddedEvent;
import com.samczsun.skype4j.events.chat.user.LegacyMemberUpgradedEvent;
import com.samczsun.skype4j.events.chat.user.MultiUserAddEvent;
import com.samczsun.skype4j.events.chat.user.UserAddEvent;
import com.samczsun.skype4j.events.chat.user.UserRemoveEvent;
import com.samczsun.skype4j.events.chat.user.action.OptionUpdateEvent;
import com.samczsun.skype4j.events.chat.user.action.PictureUpdateEvent;
import com.samczsun.skype4j.events.chat.user.action.RoleUpdateEvent;
import com.samczsun.skype4j.events.chat.user.action.TopicUpdateEvent;
import com.samczsun.skype4j.exceptions.ChatNotFoundException;
import com.samczsun.skype4j.exceptions.ConnectionException;
import com.samczsun.skype4j.exceptions.SkypeException;
import com.samczsun.skype4j.formatting.IMoji;
import com.samczsun.skype4j.formatting.Message;
import com.samczsun.skype4j.formatting.lang.en.Moji;
import com.samczsun.skype4j.internal.Endpoints;
import com.samczsun.skype4j.internal.SkypeImpl;
import com.samczsun.skype4j.internal.UserImpl;
import com.samczsun.skype4j.internal.Utils;
import com.samczsun.skype4j.internal.chat.ChatGroup;
import com.samczsun.skype4j.internal.chat.ChatImpl;
import com.samczsun.skype4j.internal.chat.messages.ChatMessageImpl;
import com.samczsun.skype4j.internal.chat.objects.ReceivedFileImpl;
import com.samczsun.skype4j.user.Contact;
import com.samczsun.skype4j.user.User;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;
import org.unbescape.html.HtmlEscape;

public enum MessageType {
    UNKNOWN("Unknown"){

        @Override
        public void handle(SkypeImpl skype, JsonObject resource) {
            skype.getEventDispatcher().callEvent(new UnsupportedEvent(this.name(), resource.toString()));
            throw new IllegalArgumentException("Unknown type!");
        }
    }
    ,
    TEXT_INTERNAL("TextInternalShouldNotBeUsedOutside"){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void handle(SkypeImpl skype, JsonObject resource) throws SkypeException, IOException {
            String content = Utils.getString(resource, "content");
            ChatImpl chat = this.getChat(resource, skype);
            UserImpl user = this.getSender(resource, chat);
            if (content == null) {
                String clientId = resource.get("skypeeditedid").asString();
                ChatMessage m = user.getMessageById(clientId);
                if (m == null) return;
                MessageDeletedEvent event = new MessageDeletedEvent(m);
                skype.getEventDispatcher().callEvent(event);
                ((ChatMessageImpl)m).edit0(null);
                return;
            }
            content = 2.stripMetadata(content);
            if (resource.get("clientmessageid") != null) {
                String clientId = resource.get("clientmessageid").asString();
                String id = resource.get("id").asString();
                if (resource.get("content") == null) {
                    throw new IllegalArgumentException("Null content? " + resource);
                }
                if (user == null) throw new IllegalArgumentException("Null sender? " + resource);
                ChatMessage m = ChatMessageImpl.createMessage(chat, user, id, clientId, System.currentTimeMillis(), Message.fromHtml(content), skype);
                chat.onMessage(m);
                if (m instanceof ReceivedMessage) {
                    MessageReceivedEvent event = new MessageReceivedEvent((ReceivedMessage)m);
                    skype.getEventDispatcher().callEvent(event);
                    return;
                } else {
                    MessageSentEvent event = new MessageSentEvent((SentMessage)m);
                    skype.getEventDispatcher().callEvent(event);
                }
                return;
            } else {
                if (resource.get("skypeeditedid") == null) throw new IllegalArgumentException("Message had no id - hacking by user or skype changed their api");
                String clientId = resource.get("skypeeditedid").asString();
                if (!content.startsWith("Edited previous message: ")) return;
                content = content.substring("Edited previous message: ".length());
                ChatMessage m = user.getMessageById(clientId);
                if (m == null) return;
                MessageEditedEvent evnt = new MessageEditedEvent(m, content);
                skype.getEventDispatcher().callEvent(evnt);
                ((ChatMessageImpl)m).edit0(Message.fromHtml(content));
            }
        }
    }
    ,
    TEXT("Text"){

        @Override
        public void handle(SkypeImpl skype, JsonObject resource) throws SkypeException, IOException {
            TEXT_INTERNAL.handle(skype, resource);
        }
    }
    ,
    RICH_TEXT("RichText"){

        @Override
        public void handle(SkypeImpl skype, JsonObject resource) throws SkypeException, IOException {
            String content = Utils.getString(resource, "content");
            Validate.notNull(content, "Null content");
            Matcher matcher = URIOBJECT.matcher(content);
            if (matcher.find()) {
                String type = matcher.group(1).split("\\.")[0];
                if (type.equalsIgnoreCase("credit")) {
                    throw new IllegalArgumentException("This event needs an implementation. Please open a ticket with the stacktrace");
                }
                if (type.equalsIgnoreCase("poll")) {
                    throw new IllegalArgumentException("This event needs an implementation. Please open a ticket with the stacktrace");
                }
                throw new IllegalArgumentException("Unknown rich type " + type);
            }
            TEXT_INTERNAL.handle(skype, resource);
        }
    }
    ,
    RICH_TEXT_CONTACTS("RichText/Contacts"){

        @Override
        public void handle(SkypeImpl skype, JsonObject resource) throws ConnectionException, ChatNotFoundException, IOException {
            String content = Utils.getString(resource, "content");
            String chatId = Utils.getString(resource, "conversationLink");
            String author = 5.getAuthor(resource);
            Validate.notNull(content, "Null content");
            Validate.notNull(chatId, "Null chat");
            Validate.notNull(author, "Null author");
            String username = MessageType.getUsername(author);
            Validate.notNull(username, "Null username");
            ChatImpl chat = 5.getChat(chatId, skype);
            Validate.notNull(chat, "Null chatobj");
            User initiator = chat.getUser(username);
            Validate.notNull(initiator, "Null initiator");
            ArrayList<Contact> contacts = new ArrayList<Contact>();
            Matcher matcher = CONTACT_PATTERN.matcher(content);
            while (matcher.find()) {
                String contactUsername = matcher.group(2).equals("s") ? matcher.group(6) : matcher.group(4);
                Contact contact = skype.getOrLoadContact(contactUsername);
                if (contact != null) {
                    contacts.add(contact);
                    continue;
                }
                skype.getLogger().log(Level.SEVERE, "Null contact (" + contactUsername + ")");
            }
            if (contacts.size() <= 0) {
                throw new IllegalArgumentException("No contacts sent");
            }
            ContactReceivedEvent event = contacts.size() == 1 ? new ContactReceivedEvent(chat, initiator, (Contact)contacts.get(0)) : new MultiContactReceivedEvent((Chat)chat, initiator, contacts);
            skype.getEventDispatcher().callEvent(event);
        }
    }
    ,
    RICH_TEXT_FILES("RichText/Files"){

        @Override
        public void handle(SkypeImpl skype, JsonObject resource) throws ConnectionException, ChatNotFoundException, IOException {
            String content = Utils.getString(resource, "content");
            String chatId = Utils.getString(resource, "conversationLink");
            String author = 6.getAuthor(resource);
            Validate.notNull(content, "Null content");
            Validate.notNull(chatId, "Null chat");
            Validate.notNull(author, "Null author");
            String username = MessageType.getUsername(author);
            Validate.notNull(username, "Null username");
            ChatImpl chat = 6.getChat(chatId, skype);
            Validate.notNull(chat, "Null chatobj");
            User initiator = chat.getUser(username);
            Validate.notNull(initiator, "Null initiator");
            Document doc = Parser.xmlParser().parseInput(content, "");
            List receivedFiles = doc.getElementsByTag("file").stream().map(fe -> new ReceivedFileImpl(fe.text(), Long.parseLong(fe.attr("size")), Long.parseLong(fe.attr("tid")))).collect(Collectors.toList());
            FileReceivedEvent event = new FileReceivedEvent(chat, initiator, Collections.unmodifiableList(receivedFiles));
            skype.getEventDispatcher().callEvent(event);
        }
    }
    ,
    RICH_TEXT_SMS("RichText/Sms"){

        @Override
        public void handle(SkypeImpl skype, JsonObject resource) throws ConnectionException, ChatNotFoundException, IOException {
            String content = resource.get("content").asString();
            String from = resource.get("from").asString();
            String url = resource.get("conversationLink").asString();
            ChatImpl c = 7.getChat(url, skype);
            User u = 7.getUser(from, c);
            Matcher m = SMS_PATTERN.matcher(content);
            if (!m.find()) {
                throw new IllegalArgumentException("Sms event did not conform to format expected");
            }
            String message = m.group(1);
            ChatMessage chatmessage = ChatMessageImpl.createMessage(c, u, null, null, System.currentTimeMillis(), Message.fromHtml(message), skype);
            SmsReceivedEvent event = new SmsReceivedEvent((ReceivedMessage)chatmessage);
            skype.getEventDispatcher().callEvent(event);
        }
    }
    ,
    RICH_TEXT_LOCATION("RichText/Location"){

        @Override
        public void handle(SkypeImpl skype, JsonObject resource) throws ConnectionException, ChatNotFoundException, IOException {
            String content = resource.get("content").asString();
            ChatImpl c = 8.getChat(resource.get("conversationLink").asString(), skype);
            User u = 8.getUser(resource.get("from").asString(), c);
            Matcher m = LOCATION_PATTERN.matcher(content);
            if (!m.find()) {
                throw MessageType.conformError("Location");
            }
            String location = m.group(1);
            String text = m.group(2);
            LocationReceivedEvent event = new LocationReceivedEvent(c, u, new LocationReceivedEvent.LocationInfo(location, text));
            skype.getEventDispatcher().callEvent(event);
        }
    }
    ,
    RICH_TEXT_URI_OBJECT("RichText/UriObject"){

        @Override
        public void handle(SkypeImpl skype, JsonObject resource) throws ConnectionException, ChatNotFoundException, IOException {
            JsonObject obj;
            String from = resource.get("from").asString();
            String url = resource.get("conversationLink").asString();
            ChatImpl c = 9.getChat(url, skype);
            User u = 9.getUser(from, c);
            String content = resource.get("content").asString();
            Document doc = Parser.xmlParser().parseInput(content, "");
            if (doc.getElementsByTag("meta").size() == 0) {
                throw new IllegalArgumentException("No meta? " + resource);
            }
            Element meta = (Element)doc.getElementsByTag("meta").get(0);
            if (meta.attr("type").equalsIgnoreCase("photo")) {
                String blob = ((Element)doc.getElementsByTag("a").get(0)).attr("href");
                Matcher matcher = BLOBID.matcher(blob);
                if (!matcher.find()) {
                    throw new IllegalArgumentException("Blob ID has changed?");
                }
                blob = matcher.group(1);
                obj = Endpoints.IMG_STATUS.open(skype, blob, "imgpsh_fullsize").as(JsonObject.class).cookies(skype.getCookies()).expect(200, "While getting URI object").get();
                Endpoints.EndpointConnection<JsonObject> econn = Endpoints.custom(obj.get("status_location").asString(), skype, new String[0]).as(JsonObject.class).expect(200, "While getting URI object").header("Cookie", Endpoints.COOKIE.provide(skype));
                while (!(obj = econn.get()).get("content_state").asString().equalsIgnoreCase("ready")) {
                }
            } else {
                throw new IllegalArgumentException("Unknown meta type " + meta.attr("type"));
            }
            BufferedImage img = Endpoints.custom(obj.get("view_location").asString(), skype, new String[0]).header("Cookie", Endpoints.COOKIE.provide(skype)).as(BufferedImage.class).expect(200, "While getting URI object").get();
            skype.getEventDispatcher().callEvent(new PictureReceivedEvent(c, u, meta.attr("originalName"), img));
        }
    }
    ,
    RICH_TEXT_MEDIA_FLIK_MSG("RichText/Media_FlikMsg"){

        @Override
        public void handle(SkypeImpl skype, JsonObject resource) throws ConnectionException, IOException, ChatNotFoundException {
            ChatImpl chat = this.getChat(resource, skype);
            UserImpl sender = this.getSender(resource, chat);
            String content = Utils.getString(resource, "content");
            Validate.notNull(content, "Null content");
            Matcher matcher = URIOBJECT_URI.matcher(content);
            Validate.isTrue(matcher.find(), "Bad match");
            String id = matcher.group(1);
            id = id.substring(id.lastIndexOf(47) + 1, id.length());
            IMoji flik = Moji.getById(id);
            Validate.notNull(flik, "No such flik");
            skype.getEventDispatcher().callEvent(new FlikReceivedEvent(chat, sender, flik));
        }
    }
    ,
    EVENT_SKYPE_VIDEO_MESSAGE("Event/SkypeVideoMessage"){

        @Override
        public void handle(SkypeImpl skype, JsonObject resource) throws ConnectionException, IOException, ChatNotFoundException {
            skype.getEventDispatcher().callEvent(new UnsupportedEvent(this.name(), resource.toString()));
            throw new IllegalArgumentException("This event needs implementation");
        }
    }
    ,
    THREAD_ACTIVITY_ADD_MEMBER("ThreadActivity/AddMember"){

        @Override
        public void handle(SkypeImpl skype, JsonObject resource) throws ConnectionException, ChatNotFoundException, IOException {
            ChatImpl chat = this.getChat(resource, skype);
            UserImpl initiator = MessageType.getInitiator(resource, chat);
            ArrayList<User> usersAdded = new ArrayList<User>();
            boolean addedSelf = false;
            Matcher matcher = SINGLE_TARGET.matcher(resource.get("content").asString());
            while (matcher.find()) {
                String username = MessageType.getUsername(matcher.group(1));
                chat.addUser(username);
                usersAdded.add(chat.getUser(username));
                if (!username.equalsIgnoreCase(skype.getUsername())) continue;
                addedSelf = true;
            }
            UserAddEvent event = null;
            if (usersAdded.size() == 0) {
                throw new IllegalArgumentException("No targets");
            }
            if (usersAdded.size() == 1) {
                event = new UserAddEvent((User)usersAdded.get(0), initiator);
            } else if (usersAdded.size() > 1) {
                event = new MultiUserAddEvent(usersAdded, (User)initiator);
            }
            skype.getEventDispatcher().callEvent(event);
            if (addedSelf) {
                ChatJoinedEvent cje = new ChatJoinedEvent(chat, initiator);
                skype.getEventDispatcher().callEvent(cje);
            }
        }
    }
    ,
    THREAD_ACTIVITY_DELETE_MEMBER("ThreadActivity/DeleteMember"){

        @Override
        public void handle(SkypeImpl skype, JsonObject resource) throws ConnectionException, ChatNotFoundException, IOException {
            ChatEvent event;
            ChatImpl chat = this.getChat(resource, skype);
            UserImpl initiator = MessageType.getInitiator(resource, chat);
            ArrayList<UserImpl> usersRemoved = new ArrayList<UserImpl>();
            Matcher matcher = SINGLE_TARGET.matcher(resource.get("content").asString());
            boolean removedSelf = false;
            while (matcher.find()) {
                String username = MessageType.getUsername(matcher.group(1));
                usersRemoved.add(chat.getUser(username));
                chat.removeUser(username);
                if (!username.equalsIgnoreCase(skype.getUsername())) continue;
                removedSelf = true;
            }
            if (usersRemoved.size() == 0) {
                throw new IllegalArgumentException("No targets");
            }
            if (usersRemoved.size() == 1) {
                event = new UserRemoveEvent((User)usersRemoved.get(0), initiator);
                skype.getEventDispatcher().callEvent(event);
            } else if (usersRemoved.size() > 1) {
                throw new IllegalArgumentException("More than one user removed?");
            }
            if (removedSelf) {
                event = new ChatQuitEvent(chat, initiator);
                skype.getEventDispatcher().callEvent(event);
            }
        }
    }
    ,
    THREAD_ACTIVITY_ROLE_UPDATE("ThreadActivity/RoleUpdate"){

        @Override
        public void handle(SkypeImpl skype, JsonObject resource) throws ConnectionException, ChatNotFoundException, IOException {
            ChatImpl chat = this.getChat(resource, skype);
            UserImpl initiator = MessageType.getInitiator(resource, chat);
            String content = resource.get("content").asString();
            Matcher timeMatcher = EVENTTIME_PATTERN.matcher(content);
            Matcher roleMatcher = ROLE_UPDATE_PATTERN.matcher(content);
            if (!timeMatcher.find() || !roleMatcher.find()) {
                throw MessageType.conformError("RoleUpdate");
            }
            long time = Long.parseLong(timeMatcher.group(1));
            UserImpl target = chat.getUser(roleMatcher.group(1).substring(2));
            User.Role role = User.Role.getByName(roleMatcher.group(2));
            RoleUpdateEvent event = new RoleUpdateEvent(initiator, time, target, role);
            skype.getEventDispatcher().callEvent(event);
        }
    }
    ,
    THREAD_ACTIVITY_TOPIC_UPDATE("ThreadActivity/TopicUpdate"){

        @Override
        public void handle(SkypeImpl skype, JsonObject resource) throws ConnectionException, ChatNotFoundException, IOException {
            String content = resource.get("content").asString();
            ChatImpl chat = this.getChat(resource, skype);
            UserImpl initiator = MessageType.getInitiator(resource, chat);
            Matcher timeMatcher = EVENTTIME_PATTERN.matcher(content);
            Matcher valueMatcher = VALUE_PATTERN.matcher(content);
            if (!timeMatcher.find() || !valueMatcher.find()) {
                throw MessageType.conformError("TopicUpdate");
            }
            long time = Long.parseLong(timeMatcher.group(1));
            String topic = valueMatcher.groupCount() > 0 ? HtmlEscape.unescapeHtml(valueMatcher.group(1)) : "";
            TopicUpdateEvent event = new TopicUpdateEvent(initiator, time, ((ChatGroup)chat).getTopic(), topic);
            skype.getEventDispatcher().callEvent(event);
            ((ChatGroup)chat).updateTopic(topic);
        }
    }
    ,
    THREAD_ACTIVITY_PICTURE_UPDATE("ThreadActivity/PictureUpdate"){

        @Override
        public void handle(SkypeImpl skype, JsonObject resource) throws ConnectionException, ChatNotFoundException, IOException {
            String content = resource.get("content").asString();
            ChatImpl chat = this.getChat(resource, skype);
            UserImpl initiator = MessageType.getInitiator(resource, chat);
            Matcher timeMatcher = EVENTTIME_PATTERN.matcher(content);
            Matcher valueMatcher = VALUE_PATTERN.matcher(content);
            if (!timeMatcher.find() || !valueMatcher.find()) {
                throw MessageType.conformError("PictureUpdate");
            }
            long time = Long.parseLong(timeMatcher.group(1));
            String picurl = valueMatcher.group(1).substring(4);
            PictureUpdateEvent event = new PictureUpdateEvent(initiator, time, picurl);
            skype.getEventDispatcher().callEvent(event);
            ((ChatGroup)chat).updatePicture(picurl);
        }
    }
    ,
    THREAD_ACTIVITY_HISTORY_DISCLOSED_UPDATE("ThreadActivity/HistoryDisclosedUpdate"){

        @Override
        public void handle(SkypeImpl skype, JsonObject resource) throws ConnectionException, ChatNotFoundException, IOException {
            String content = resource.get("content").asString();
            ChatImpl chat = this.getChat(resource, skype);
            UserImpl initiator = MessageType.getInitiator(resource, chat);
            Matcher timeMatcher = EVENTTIME_PATTERN.matcher(content);
            Matcher valueMatcher = VALUE_PATTERN.matcher(content);
            if (!timeMatcher.find() || !valueMatcher.find()) {
                throw MessageType.conformError("HistoryDisclosedUpdate");
            }
            long time = Long.parseLong(timeMatcher.group(1));
            boolean enabled = Boolean.parseBoolean(valueMatcher.group(1));
            OptionUpdateEvent event = new OptionUpdateEvent(initiator, time, OptionUpdateEvent.Option.HISTORY_DISCLOSED, enabled);
            skype.getEventDispatcher().callEvent(event);
            ((ChatGroup)chat).updateOption(OptionUpdateEvent.Option.HISTORY_DISCLOSED, enabled);
        }
    }
    ,
    THREAD_ACTIVITY_JOINING_ENABLED_UPDATE("ThreadActivity/JoiningEnabledUpdate"){

        @Override
        public void handle(SkypeImpl skype, JsonObject resource) throws ConnectionException, ChatNotFoundException, IOException {
            String content = resource.get("content").asString();
            ChatImpl chat = this.getChat(resource, skype);
            UserImpl initiator = MessageType.getInitiator(resource, chat);
            Matcher timeMatcher = EVENTTIME_PATTERN.matcher(content);
            Matcher valueMatcher = VALUE_PATTERN.matcher(content);
            if (!timeMatcher.find() || !valueMatcher.find()) {
                throw MessageType.conformError("JoiningEnabledUpdate");
            }
            long time = Long.parseLong(timeMatcher.group(1));
            boolean enabled = Boolean.parseBoolean(valueMatcher.group(1));
            OptionUpdateEvent event = new OptionUpdateEvent(initiator, time, OptionUpdateEvent.Option.JOINING_ENABLED, enabled);
            skype.getEventDispatcher().callEvent(event);
            ((ChatGroup)chat).updateOption(OptionUpdateEvent.Option.JOINING_ENABLED, enabled);
        }
    }
    ,
    THREAD_ACTIVITY_LEGACY_MEMBER_ADDED("ThreadActivity/LegacyMemberAdded"){

        @Override
        public void handle(SkypeImpl skype, JsonObject resource) throws ConnectionException, IOException, ChatNotFoundException {
            String content = Utils.getString(resource, "content");
            String chatId = Utils.getString(resource, "conversationLink");
            if (content == null) {
                throw new IllegalArgumentException("Null content");
            }
            if (chatId == null) {
                throw new IllegalArgumentException("Null chat");
            }
            Matcher matcher = SINGLE_TARGET.matcher(content);
            if (!matcher.find()) {
                throw new IllegalArgumentException("Target conformity");
            }
            ChatImpl chat = 19.getChat(chatId, skype);
            User user = chat.getUser(matcher.group(1).substring(2));
            if (user == null) {
                throw new IllegalArgumentException("Null user");
            }
            skype.getEventDispatcher().callEvent(new LegacyMemberAddedEvent(user));
        }
    }
    ,
    THREAD_ACTIVITY_LEGACY_MEMBER_UPGRADED("ThreadActivity/LegacyMemberUpgraded"){

        @Override
        public void handle(SkypeImpl skype, JsonObject resource) throws ConnectionException, IOException, ChatNotFoundException {
            String content = Utils.getString(resource, "content");
            String chatId = Utils.getString(resource, "conversationLink");
            if (content == null) {
                throw new IllegalArgumentException("Null content");
            }
            if (chatId == null) {
                throw new IllegalArgumentException("Null chat");
            }
            Matcher matcher = SINGLE_TARGET.matcher(content);
            if (!matcher.find()) {
                throw new IllegalArgumentException("Target conformity");
            }
            ChatImpl chat = 20.getChat(chatId, skype);
            User user = chat.getUser(matcher.group(1).substring(2));
            if (user == null) {
                throw new IllegalArgumentException("Null user");
            }
            skype.getEventDispatcher().callEvent(new LegacyMemberUpgradedEvent(user));
        }
    }
    ,
    EVENT_CALL("Event/Call"){

        @Override
        public void handle(SkypeImpl skype, JsonObject resource) throws ConnectionException, ChatNotFoundException, IOException {
            String from = resource.get("from").asString();
            String url = resource.get("conversationLink").asString();
            String content = resource.get("content").asString();
            boolean finished = content.startsWith("<ended/>") || content.startsWith("<partlist type=\"ended\"");
            ChatImpl c = 21.getChat(url, skype);
            User u = 21.getUser(from, c);
            CallReceivedEvent event = new CallReceivedEvent(c, u, !finished);
            skype.getEventDispatcher().callEvent(event);
        }
    }
    ,
    CONTROL_TYPING("Control/Typing"){

        @Override
        public void handle(SkypeImpl skype, JsonObject resource) throws ConnectionException, ChatNotFoundException, IOException {
            String from = resource.get("from").asString();
            String url = resource.get("conversationLink").asString();
            ChatImpl c = 22.getChat(url, skype);
            User u = 22.getUser(from, c);
            TypingReceivedEvent event = new TypingReceivedEvent(c, u, true);
            skype.getEventDispatcher().callEvent(event);
        }
    }
    ,
    CONTROL_CLEAR_TYPING("Control/ClearTyping"){

        @Override
        public void handle(SkypeImpl skype, JsonObject resource) throws ConnectionException, ChatNotFoundException, IOException {
            ChatImpl c = 23.getChat(resource.get("conversationLink").asString(), skype);
            User u = 23.getUser(resource.get("from").asString(), c);
            TypingReceivedEvent event = new TypingReceivedEvent(c, u, false);
            skype.getEventDispatcher().callEvent(event);
        }
    }
    ,
    CONTROL_LIVE_STATE("Control/LiveState"){

        @Override
        public void handle(SkypeImpl skype, JsonObject resource) {
        }
    };

    private static final Map<String, Pattern> METADATA;
    private static final Pattern NAME;
    private static final Pattern USERNAME;
    private static final Pattern SINGLE_TARGET;
    private static final Pattern VIDEOMESSAGE;
    private static final Pattern URIOBJECT;
    private static final Pattern URIOBJECT_URI;
    private static final Pattern CONVERSATION;
    private static final Pattern INITIATOR;
    private static final Map<String, MessageType> byValue;
    private static final Pattern USER_PATTERN;
    private static final Pattern STRIP_EDIT_PATTERN;
    private static final Pattern STRIP_QUOTE_PATTERN;
    private static final Pattern STRIP_EMOTICON_PATTERN;
    private static final Pattern CONTACT_PATTERN;
    private static final Pattern SMS_PATTERN;
    private static final Pattern LOCATION_PATTERN;
    private static final Pattern EVENTTIME_PATTERN;
    private static final Pattern VALUE_PATTERN;
    private static final Pattern ROLE_UPDATE_PATTERN;
    private static final Pattern BLOBID;
    private final String value;

    private MessageType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public abstract void handle(SkypeImpl var1, JsonObject var2) throws SkypeException, IOException;

    public static MessageType getByName(String messageType) {
        return byValue.getOrDefault(messageType, UNKNOWN);
    }

    public ChatImpl getChat(JsonObject resource, SkypeImpl skype) throws ConnectionException, IOException, ChatNotFoundException {
        String chatId = Utils.getString(resource, "conversationLink");
        if (chatId == null) {
            throw new IllegalArgumentException("Null chat");
        }
        return MessageType.getChat(chatId, skype);
    }

    public UserImpl getSender(JsonObject resource, ChatImpl chat) {
        String author = MessageType.getAuthor(resource);
        String username = MessageType.getUsername(author);
        return chat.getUser(username);
    }

    public static ChatImpl getChat(String url, SkypeImpl skype) throws ConnectionException, ChatNotFoundException, IOException {
        Matcher m = CONVERSATION.matcher(url);
        if (m.find()) {
            return skype.getOrLoadChat(m.group(1));
        }
        throw MessageType.conformError("Chat URL");
    }

    public static User getUser(String url, Chat c) {
        Matcher m = USER_PATTERN.matcher(url);
        if (m.find()) {
            return c.getUser(m.group(1));
        }
        throw MessageType.conformError("User");
    }

    public static String getAuthor(JsonObject resource) {
        String from = Utils.getString(resource, "from");
        if (from == null) {
            throw new IllegalArgumentException("Null from");
        }
        Matcher matcher = NAME.matcher(from);
        return matcher.find() ? matcher.group(1) : from;
    }

    private static String getUsername(String author) {
        Matcher matcher = USERNAME.matcher(author);
        return matcher.find() ? matcher.replaceAll("") : author;
    }

    private static UserImpl getInitiator(JsonObject resource, ChatImpl chat) {
        String content = Utils.getString(resource, "content");
        if (content == null) {
            throw new IllegalArgumentException("Null content");
        }
        Matcher matcher = INITIATOR.matcher(content);
        if (matcher.find()) {
            UserImpl user = chat.getUser(MessageType.getUsername(matcher.group(1)));
            if (user != null) {
                return user;
            }
            throw new IllegalArgumentException("Unknown user");
        }
        throw new IllegalArgumentException("Malformatted content");
    }

    private static IllegalArgumentException conformError(String object) {
        return new IllegalArgumentException(String.format("%s did not conform to format expected", object));
    }

    public static String stripMetadata(String content) {
        for (Pattern pattern : METADATA.values()) {
            Matcher m = pattern.matcher(content);
            content = m.find() ? m.replaceAll("") : content;
        }
        return content;
    }

    static {
        METADATA = new HashMap<String, Pattern>();
        METADATA.put("text", Pattern.compile("Edited previous message: "));
        METADATA.put("edited", Pattern.compile("</?[e_m][^<>]+>"));
        METADATA.put("quoted", Pattern.compile("(<(?:/?)(?:quote|legacyquote)[^>]*>)", 2));
        NAME = Pattern.compile("/((?:\\d+:|live:)[^/]+)");
        USERNAME = Pattern.compile("^((\\d+):)+");
        SINGLE_TARGET = Pattern.compile("<target>(\\d+:[^<]+)</target>");
        VIDEOMESSAGE = Pattern.compile("<videomessage[^>]*?\\ssid=\"([a-f0-9]{32})\"", 2);
        URIOBJECT = Pattern.compile("<URIObject[^>]*?\\stype=\"([^\"]+?)\"", 2);
        URIOBJECT_URI = Pattern.compile("<URIObject[^>]*?\\suri=\"([^\"]+?)\"", 2);
        CONVERSATION = Pattern.compile("/(\\d+:[^?]*)");
        INITIATOR = Pattern.compile("<initiator>(\\d+:.+)</initiator>");
        byValue = new HashMap<String, MessageType>();
        USER_PATTERN = Pattern.compile("8:(.*)", 2);
        STRIP_EDIT_PATTERN = Pattern.compile("</?[e_m][^<>]+>", 2);
        STRIP_QUOTE_PATTERN = Pattern.compile("(<(?:/?)(?:quote|legacyquote)[^>]*>)", 2);
        STRIP_EMOTICON_PATTERN = Pattern.compile("(<(?:/?)(?:ss)[^>]*>)", 2);
        CONTACT_PATTERN = Pattern.compile("(<c t=\"([^\"]+?)\"( p=\"([^\"]+?)\")?( s=\"([^\"]+?)\")?( f=\"([^\"]+?)\")?/>)", 2);
        SMS_PATTERN = Pattern.compile("<sms alt=\"([^\"]+?)\">", 2);
        LOCATION_PATTERN = Pattern.compile("<a[^>]+href=\"https://www.bing.com/maps([^\"]+)\"[^>]*>([^<]*)", 2);
        EVENTTIME_PATTERN = Pattern.compile("<eventtime>(\\d+)</eventtime>", 2);
        VALUE_PATTERN = Pattern.compile("(?:<value>(.+)</value>|<value />)", 2);
        ROLE_UPDATE_PATTERN = Pattern.compile("<target><id>(\\d+:.+)</id><role>(.+)</role></target>", 2);
        BLOBID = Pattern.compile("(0-cus-d[0-9]-[a-z0-9]{32})");
        for (MessageType type : MessageType.values()) {
            byValue.put(type.getValue(), type);
        }
    }
}

