/*
 * Decompiled with CFR 0.152.
 */
package com.samczsun.skype4j.internal;

import com.samczsun.skype4j.Skype;
import com.samczsun.skype4j.events.Event;
import com.samczsun.skype4j.events.EventDispatcher;
import com.samczsun.skype4j.events.EventHandler;
import com.samczsun.skype4j.events.Listener;
import com.samczsun.skype4j.exceptions.handler.ErrorSource;
import com.samczsun.skype4j.internal.RegisteredListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class SkypeEventDispatcher
implements EventDispatcher {
    private Skype instance;
    private final Map<Class<?>, List<RegisteredListener>> listeners = Collections.synchronizedMap(new HashMap());

    public SkypeEventDispatcher(Skype instance) {
        this.instance = instance;
    }

    @Override
    public void registerListener(Listener l) {
        Class<?> c = l.getClass();
        for (Method m : c.getMethods()) {
            if (m.getAnnotation(EventHandler.class) == null || m.getParameterTypes().length != 1 || !Event.class.isAssignableFrom(m.getParameterTypes()[0])) continue;
            RegisteredListener reglistener = new RegisteredListener(l, m);
            Class<?> eventType = m.getParameterTypes()[0];
            List<RegisteredListener> methods = this.listeners.get(eventType);
            if (methods == null) {
                methods = new ArrayList<RegisteredListener>();
                this.listeners.put(eventType, methods);
            }
            methods.add(reglistener);
        }
    }

    @Override
    public void callEvent(Event e) {
        ArrayList<RegisteredListener> methods = new ArrayList<RegisteredListener>();
        Class<?> eventType = e.getClass();
        while (true) {
            List<RegisteredListener> m;
            if ((m = this.listeners.get(eventType)) != null) {
                methods.addAll(m);
            }
            if (eventType == Event.class) break;
            eventType = eventType.getSuperclass();
        }
        for (RegisteredListener method : methods) {
            try {
                method.handleEvent(e);
            }
            catch (Throwable t) {
                this.instance.getLogger().log(Level.SEVERE, "Error while handling event", t);
                this.instance.handleError(ErrorSource.DISPATCHING_EVENT, t, false);
            }
        }
    }
}

