/*
 * Decompiled with CFR 0.152.
 */
package com.samczsun.skype4j.internal.threads;

import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import com.samczsun.skype4j.exceptions.ConnectionException;
import com.samczsun.skype4j.exceptions.handler.ErrorSource;
import com.samczsun.skype4j.internal.Endpoints;
import com.samczsun.skype4j.internal.EventType;
import com.samczsun.skype4j.internal.ExceptionHandler;
import com.samczsun.skype4j.internal.SkypeImpl;
import com.samczsun.skype4j.internal.SkypeThreadFactory;
import com.samczsun.skype4j.internal.Utils;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;

public class PollThread
extends Thread {
    private final SkypeImpl skype;
    private final ExecutorService inputFetcher;
    private final String endpointId;
    private final Object lock = new Object();
    private IOException pendingException;
    private HttpURLConnection connection;

    public PollThread(SkypeImpl skype, String endpointId) {
        super(String.format("Skype4J-Poller-%s", skype.getUsername()));
        this.skype = skype;
        this.inputFetcher = Executors.newSingleThreadExecutor(new SkypeThreadFactory(skype, "PollBlocker"));
        this.endpointId = endpointId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int pollId = 0;
        block18: while (this.skype.isAuthenticated()) {
            Endpoints.EndpointConnection<HttpURLConnection> epconn = Endpoints.POLL.open(this.skype, pollId).header("Content-Type", "application/json").dontConnect();
            AtomicBoolean complete = new AtomicBoolean(false);
            while (this.skype.isAuthenticated()) {
                try {
                    complete.set(false);
                    this.connection = epconn.post();
                    this.inputFetcher.execute(() -> {
                        try {
                            this.connection.getResponseCode();
                        }
                        catch (IOException e) {
                            this.pendingException = e;
                        }
                        finally {
                            complete.set(true);
                            Object object = this.lock;
                            synchronized (object) {
                                this.lock.notify();
                            }
                        }
                    });
                    Object object = this.lock;
                    synchronized (object) {
                        if (!complete.get()) {
                            this.lock.wait();
                        }
                    }
                    if (this.pendingException != null) {
                        this.skype.handleError(ErrorSource.POLLING_SKYPE, this.pendingException, false);
                        continue;
                    }
                    if (this.connection.getHeaderField("Set-RegistrationToken") != null) {
                        this.skype.setRegistrationToken(this.connection.getHeaderField("Set-RegistrationToken"));
                    }
                    if (this.connection.getResponseCode() == 403) {
                        JsonObject object2;
                        HttpURLConnection conn;
                        block27: {
                            try {
                                conn = Endpoints.custom("https://client-s.gateway.messenger.live.com/v1/users/ME/endpoints/" + this.endpointId, this.skype, new String[0]).dontConnect().header("Authentication", "skypetoken=" + this.skype.getSkypeToken()).put(new JsonObject());
                                if (conn.getResponseCode() == 200) break block27;
                                this.skype.handleError(ErrorSource.REFRESHING_ENDPOINT, ExceptionHandler.generateException("While refreshing endpoint", conn), true);
                                return;
                            }
                            catch (IOException e) {
                                this.skype.handleError(ErrorSource.REFRESHING_ENDPOINT, e, true);
                                return;
                            }
                        }
                        String regtoken = conn.getHeaderField("Set-RegistrationToken");
                        if (regtoken != null) {
                            this.skype.setRegistrationToken(regtoken);
                        }
                        if ((object2 = Utils.parseJsonObject(conn.getInputStream())).get("subscriptions") == null) continue block18;
                        pollId = object2.get("subscriptions").asArray().get(0).asObject().get("id").asInt();
                        continue block18;
                    }
                    if (this.connection.getResponseCode() != 200) continue;
                    if (this.skype.getScheduler().isShutdown()) {
                        if (!this.skype.isShutdownRequested()) {
                            this.skype.handleError(ErrorSource.THREAD_POOL_DEAD, null, true);
                        }
                        return;
                    }
                    JsonObject message = Utils.parseJsonObject(this.connection.getInputStream());
                    this.skype.getScheduler().execute(() -> {
                        if (message.get("eventMessages") != null) {
                            for (JsonValue elem : message.get("eventMessages").asArray()) {
                                JsonObject eventObj = elem.asObject();
                                EventType type = EventType.getByName(eventObj.get("resourceType").asString());
                                if (type != null) {
                                    try {
                                        type.handle(this.skype, eventObj);
                                    }
                                    catch (Throwable t) {
                                        this.skype.handleError(ErrorSource.PARSING_MESSAGE, t, false);
                                    }
                                    continue;
                                }
                                this.skype.handleError(ErrorSource.NO_MESSAGE_TYPE, null, false);
                            }
                        }
                    });
                }
                catch (InterruptedException e) {
                    return;
                }
                catch (ConnectionException | IOException e) {
                    this.skype.handleError(ErrorSource.POLLING_SKYPE, e, true);
                    return;
                }
                finally {
                    this.connection.disconnect();
                }
            }
        }
    }

    public void shutdown() {
        this.interrupt();
        while (this.getState() != Thread.State.TERMINATED) {
        }
        if (this.connection != null) {
            this.connection.disconnect();
        }
        this.inputFetcher.shutdownNow();
        while (!this.inputFetcher.isTerminated()) {
        }
    }
}

