/*
 * Decompiled with CFR 0.152.
 */
package com.zenjava.javafx.maven.plugin;

import com.zenjava.javafx.maven.plugin.AbstractJfxToolsMojo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Optional;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class RunMojo
extends AbstractJfxToolsMojo {
    protected String runJavaParameter = null;
    protected String runAppParameter = null;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping execution of RunMojo MOJO.");
            return;
        }
        this.getLog().info((CharSequence)"Running JavaFX Application");
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.getEnvironmentRelativeExecutablePath() + "java");
        Optional.ofNullable(this.runJavaParameter).ifPresent(parameter -> {
            if (!parameter.trim().isEmpty()) {
                command.add((String)parameter);
            }
        });
        command.add("-jar");
        command.add(this.jfxMainAppJarName);
        Optional.ofNullable(this.runAppParameter).ifPresent(parameter -> {
            if (!parameter.trim().isEmpty()) {
                command.add((String)parameter);
            }
        });
        try {
            ProcessBuilder pb = new ProcessBuilder(new String[0]).inheritIO().directory(this.jfxAppOutputDir).command(command);
            if (this.verbose.booleanValue()) {
                this.getLog().info((CharSequence)("Running command: " + String.join((CharSequence)" ", command)));
            }
            Process p = pb.start();
            p.waitFor();
            if (p.exitValue() != 0) {
                throw new MojoExecutionException("There was an exception while executing JavaFX Application. Please check build-log.");
            }
        }
        catch (IOException | InterruptedException ex) {
            throw new MojoExecutionException("There was an exception while executing JavaFX Application.", ex);
        }
    }
}

