/*
 * Decompiled with CFR 0.152.
 */
package heros.solver;

import com.google.common.base.Predicate;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import heros.DontSynchronize;
import heros.EdgeFunction;
import heros.EdgeFunctionCache;
import heros.EdgeFunctions;
import heros.FlowFunction;
import heros.FlowFunctionCache;
import heros.FlowFunctions;
import heros.IDETabulationProblem;
import heros.InterproceduralCFG;
import heros.JoinLattice;
import heros.SynchronizedBy;
import heros.ZeroedFlowFunctions;
import heros.edgefunc.EdgeIdentity;
import heros.solver.CountingThreadPoolExecutor;
import heros.solver.JoinHandlingNode;
import heros.solver.JumpFunctions;
import heros.solver.LinkedNode;
import heros.solver.Pair;
import heros.solver.PathEdge;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IDESolver<N, D, M, V, I extends InterproceduralCFG<N, M>> {
    public static CacheBuilder<Object, Object> DEFAULT_CACHE_BUILDER = CacheBuilder.newBuilder().concurrencyLevel(Runtime.getRuntime().availableProcessors()).initialCapacity(10000).softValues();
    protected static final Logger logger = LoggerFactory.getLogger(IDESolver.class);
    @SynchronizedBy(value="consistent lock on field")
    protected Table<N, N, Map<D, Set<D>>> computedIntraPEdges = HashBasedTable.create();
    @SynchronizedBy(value="consistent lock on field")
    protected Table<N, N, Map<D, Set<D>>> computedInterPEdges = HashBasedTable.create();
    public static boolean DEBUG = logger.isDebugEnabled();
    protected CountingThreadPoolExecutor executor;
    @DontSynchronize(value="only used by single thread")
    protected int numThreads;
    @SynchronizedBy(value="thread safe data structure, consistent locking when used")
    protected final JumpFunctions<N, D, V> jumpFn;
    @SynchronizedBy(value="thread safe data structure, only modified internally")
    protected final I icfg;
    @SynchronizedBy(value="consistent lock on 'incoming'")
    protected final Table<N, D, Table<N, D, EdgeFunction<V>>> endSummary = HashBasedTable.create();
    @SynchronizedBy(value="consistent lock on field")
    protected final Table<N, D, Map<N, Set<D>>> incoming = HashBasedTable.create();
    @SynchronizedBy(value="use of ConcurrentHashMap")
    protected final Set<N> unbalancedRetSites;
    @DontSynchronize(value="stateless")
    protected final FlowFunctions<N, D, M> flowFunctions;
    @DontSynchronize(value="stateless")
    protected final EdgeFunctions<N, D, M, V> edgeFunctions;
    @DontSynchronize(value="only used by single thread")
    protected final Map<N, Set<D>> initialSeeds;
    @DontSynchronize(value="stateless")
    protected final JoinLattice<V> valueLattice;
    @DontSynchronize(value="stateless")
    protected final EdgeFunction<V> allTop;
    @SynchronizedBy(value="consistent lock on field")
    protected final Table<N, D, V> val = HashBasedTable.create();
    @DontSynchronize(value="benign races")
    public long flowFunctionApplicationCount;
    @DontSynchronize(value="benign races")
    public long flowFunctionConstructionCount;
    @DontSynchronize(value="benign races")
    public long propagationCount;
    @DontSynchronize(value="benign races")
    public long durationFlowFunctionConstruction;
    @DontSynchronize(value="benign races")
    public long durationFlowFunctionApplication;
    @DontSynchronize(value="stateless")
    protected final D zeroValue;
    @DontSynchronize(value="readOnly")
    protected final FlowFunctionCache<N, D, M> ffCache;
    @DontSynchronize(value="readOnly")
    protected final EdgeFunctionCache<N, D, M, V> efCache;
    @DontSynchronize(value="readOnly")
    protected final boolean followReturnsPastSeeds;
    @DontSynchronize(value="readOnly")
    protected final boolean computeValues;
    private boolean recordEdges;

    public IDESolver(IDETabulationProblem<N, D, M, V, I> tabulationProblem) {
        this(tabulationProblem, DEFAULT_CACHE_BUILDER, DEFAULT_CACHE_BUILDER);
    }

    public IDESolver(IDETabulationProblem<N, D, M, V, I> tabulationProblem, CacheBuilder flowFunctionCacheBuilder, CacheBuilder edgeFunctionCacheBuilder) {
        if (logger.isDebugEnabled()) {
            if (flowFunctionCacheBuilder != null) {
                flowFunctionCacheBuilder = flowFunctionCacheBuilder.recordStats();
            }
            if (edgeFunctionCacheBuilder != null) {
                edgeFunctionCacheBuilder = edgeFunctionCacheBuilder.recordStats();
            }
        }
        this.zeroValue = tabulationProblem.zeroValue();
        this.icfg = tabulationProblem.interproceduralCFG();
        FlowFunctions flowFunctions = tabulationProblem.autoAddZero() ? new ZeroedFlowFunctions(tabulationProblem.flowFunctions(), tabulationProblem.zeroValue()) : tabulationProblem.flowFunctions();
        EdgeFunctions<N, D, M, V> edgeFunctions = tabulationProblem.edgeFunctions();
        if (flowFunctionCacheBuilder != null) {
            this.ffCache = new FlowFunctionCache(flowFunctions, flowFunctionCacheBuilder);
            flowFunctions = this.ffCache;
        } else {
            this.ffCache = null;
        }
        if (edgeFunctionCacheBuilder != null) {
            this.efCache = new EdgeFunctionCache<N, D, M, V>(edgeFunctions, edgeFunctionCacheBuilder);
            edgeFunctions = this.efCache;
        } else {
            this.efCache = null;
        }
        this.flowFunctions = flowFunctions;
        this.edgeFunctions = edgeFunctions;
        this.initialSeeds = tabulationProblem.initialSeeds();
        this.unbalancedRetSites = Collections.newSetFromMap(new ConcurrentHashMap());
        this.valueLattice = tabulationProblem.joinLattice();
        this.allTop = tabulationProblem.allTopFunction();
        this.jumpFn = new JumpFunctions(this.allTop);
        this.followReturnsPastSeeds = tabulationProblem.followReturnsPastSeeds();
        this.numThreads = Math.max(1, tabulationProblem.numThreads());
        this.computeValues = tabulationProblem.computeValues();
        this.executor = this.getExecutor();
        this.recordEdges = tabulationProblem.recordEdges();
    }

    public void solve() {
        this.submitInitialSeeds();
        this.awaitCompletionComputeValuesAndShutdown();
    }

    protected void submitInitialSeeds() {
        for (Map.Entry<N, Set<D>> seed : this.initialSeeds.entrySet()) {
            N startPoint = seed.getKey();
            for (D val : seed.getValue()) {
                this.propagate(this.zeroValue, startPoint, val, EdgeIdentity.v(), null, false);
            }
            this.jumpFn.addFunction(this.zeroValue, startPoint, this.zeroValue, EdgeIdentity.v());
        }
    }

    protected void awaitCompletionComputeValuesAndShutdown() {
        long before = System.currentTimeMillis();
        this.runExecutorAndAwaitCompletion();
        this.durationFlowFunctionConstruction = System.currentTimeMillis() - before;
        if (this.computeValues) {
            before = System.currentTimeMillis();
            this.computeValues();
            this.durationFlowFunctionApplication = System.currentTimeMillis() - before;
        }
        if (logger.isDebugEnabled()) {
            this.printStats();
        }
        this.executor.shutdown();
        this.runExecutorAndAwaitCompletion();
    }

    private void runExecutorAndAwaitCompletion() {
        try {
            this.executor.awaitCompletion();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Throwable exception = this.executor.getException();
        if (exception != null) {
            throw new RuntimeException("There were exceptions during IDE analysis. Exiting.", exception);
        }
    }

    protected void scheduleEdgeProcessing(PathEdge<N, D> edge) {
        if (this.executor.isTerminating()) {
            return;
        }
        this.executor.execute(new PathEdgeProcessingTask(edge));
        ++this.propagationCount;
    }

    private void scheduleValueProcessing(ValuePropagationTask vpt) {
        if (this.executor.isTerminating()) {
            return;
        }
        this.executor.execute(vpt);
    }

    private void scheduleValueComputationTask(ValueComputationTask task) {
        if (this.executor.isTerminating()) {
            return;
        }
        this.executor.execute(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveEdges(N sourceNode, N sinkStmt, D sourceVal, Set<D> destVals, boolean interP) {
        Table<N, N, Map<D, Set<D>>> tgtMap;
        if (!this.recordEdges) {
            return;
        }
        Table<N, N, Map<D, Set<D>>> table = tgtMap = interP ? this.computedInterPEdges : this.computedIntraPEdges;
        synchronized (table) {
            HashMap<D, HashSet<D>> map = (HashMap<D, HashSet<D>>)tgtMap.get(sourceNode, sinkStmt);
            if (map == null) {
                map = new HashMap<D, HashSet<D>>();
                tgtMap.put(sourceNode, sinkStmt, map);
            }
            map.put(sourceVal, new HashSet<D>(destVals));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCall(PathEdge<N, D> edge) {
        D d1 = edge.factAtSource();
        N n = edge.getTarget();
        logger.trace("Processing call to {}", n);
        D d2 = edge.factAtTarget();
        EdgeFunction<V> f = this.jumpFunction(edge);
        Collection<N> returnSiteNs = this.icfg.getReturnSitesOfCallAt(n);
        Collection callees = this.icfg.getCalleesOfCallAt(n);
        for (Object sCalledProcN : callees) {
            FlowFunction<D> function = this.flowFunctions.getCallFlowFunction(n, sCalledProcN);
            ++this.flowFunctionConstructionCount;
            Set<D> res = this.computeCallFlowFunction(function, d1, d2);
            Collection startPointsOf = this.icfg.getStartPointsOf(sCalledProcN);
            for (Object sP : startPointsOf) {
                this.saveEdges(n, sP, d2, res, true);
                for (D d3 : res) {
                    HashSet endSumm;
                    this.propagate(d3, sP, d3, EdgeIdentity.v(), n, false);
                    Table<N, D, Map<N, Set<D>>> table = this.incoming;
                    synchronized (table) {
                        this.addIncoming(sP, d3, n, d2);
                        endSumm = new HashSet(this.endSummary(sP, d3));
                    }
                    for (Table.Cell cell : endSumm) {
                        Object eP = cell.getRowKey();
                        Object d4 = cell.getColumnKey();
                        EdgeFunction fCalleeSummary = (EdgeFunction)cell.getValue();
                        for (N retSiteN : returnSiteNs) {
                            FlowFunction<D> retFunction = this.flowFunctions.getReturnFlowFunction(n, sCalledProcN, eP, retSiteN);
                            ++this.flowFunctionConstructionCount;
                            Set<Object> returnedFacts = this.computeReturnFlowFunction(retFunction, d3, d4, n, Collections.singleton(d2));
                            this.saveEdges(eP, retSiteN, d4, returnedFacts, true);
                            for (Object d5 : returnedFacts) {
                                EdgeFunction<V> f4 = this.edgeFunctions.getCallEdgeFunction(n, d2, sCalledProcN, d3);
                                EdgeFunction<V> f5 = this.edgeFunctions.getReturnEdgeFunction(n, sCalledProcN, eP, d4, retSiteN, d5);
                                EdgeFunction<V> fPrime = f4.composeWith(fCalleeSummary).composeWith(f5);
                                Object d5_restoredCtx = this.restoreContextOnReturnedFact(n, d2, d5);
                                this.propagate(d1, retSiteN, d5_restoredCtx, f.composeWith(fPrime), n, false);
                            }
                        }
                    }
                }
            }
        }
        for (Object returnSiteN : returnSiteNs) {
            FlowFunction<D> callToReturnFlowFunction = this.flowFunctions.getCallToReturnFlowFunction(n, returnSiteN);
            ++this.flowFunctionConstructionCount;
            Set<D> returnFacts = this.computeCallToReturnFlowFunction(callToReturnFlowFunction, d1, d2);
            this.saveEdges(n, returnSiteN, d2, returnFacts, false);
            for (D d3 : returnFacts) {
                EdgeFunction<V> edgeFnE = this.edgeFunctions.getCallToReturnEdgeFunction(n, d2, returnSiteN, d3);
                this.propagate(d1, returnSiteN, d3, f.composeWith(edgeFnE), n, false);
            }
        }
    }

    protected Set<D> computeCallFlowFunction(FlowFunction<D> callFlowFunction, D d1, D d2) {
        return callFlowFunction.computeTargets(d2);
    }

    protected Set<D> computeCallToReturnFlowFunction(FlowFunction<D> callToReturnFlowFunction, D d1, D d2) {
        return callToReturnFlowFunction.computeTargets(d2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processExit(PathEdge<N, D> edge) {
        FlowFunction<D> retFunction;
        N n = edge.getTarget();
        EdgeFunction<V> f = this.jumpFunction(edge);
        Object methodThatNeedsSummary = this.icfg.getMethodOf(n);
        D d1 = edge.factAtSource();
        D d2 = edge.factAtTarget();
        Collection startPointsOf = this.icfg.getStartPointsOf(methodThatNeedsSummary);
        HashMap inc = new HashMap();
        for (Object n2 : startPointsOf) {
            Table<N, D, Map<N, Set<D>>> table = this.incoming;
            synchronized (table) {
                this.addEndSummary(n2, d1, n, d2, f);
                for (Map.Entry entry : this.incoming(d1, n2).entrySet()) {
                    inc.put(entry.getKey(), new HashSet((Collection)entry.getValue()));
                }
            }
        }
        for (Map.Entry entry : inc.entrySet()) {
            Object c = entry.getKey();
            for (Object object : this.icfg.getReturnSitesOfCallAt(c)) {
                retFunction = this.flowFunctions.getReturnFlowFunction(c, methodThatNeedsSummary, n, object);
                ++this.flowFunctionConstructionCount;
                for (Object d4 : (Set)entry.getValue()) {
                    Set<D> targets = this.computeReturnFlowFunction(retFunction, d1, d2, c, (Set)entry.getValue());
                    this.saveEdges(n, object, d2, targets, true);
                    for (D d5 : targets) {
                        EdgeFunction<V> f4 = this.edgeFunctions.getCallEdgeFunction(c, d4, this.icfg.getMethodOf(n), d1);
                        EdgeFunction<V> f5 = this.edgeFunctions.getReturnEdgeFunction(c, this.icfg.getMethodOf(n), n, d2, object, d5);
                        EdgeFunction<V> fPrime = f4.composeWith(f).composeWith(f5);
                        JumpFunctions<N, D, V> jumpFunctions = this.jumpFn;
                        synchronized (jumpFunctions) {
                            for (Map.Entry<D, EdgeFunction<V>> valAndFunc : this.jumpFn.reverseLookup(c, d4).entrySet()) {
                                EdgeFunction<V> f3 = valAndFunc.getValue();
                                if (f3.equalTo(this.allTop)) continue;
                                D d3 = valAndFunc.getKey();
                                Object d5_restoredCtx = this.restoreContextOnReturnedFact(c, d4, d5);
                                this.propagate(d3, object, d5_restoredCtx, f3.composeWith(fPrime), c, false);
                            }
                        }
                    }
                }
            }
        }
        if (this.followReturnsPastSeeds && inc.isEmpty() && d1.equals(this.zeroValue)) {
            Collection callers = this.icfg.getCallersOf(methodThatNeedsSummary);
            for (Object c : callers) {
                for (Object object : this.icfg.getReturnSitesOfCallAt(c)) {
                    retFunction = this.flowFunctions.getReturnFlowFunction(c, methodThatNeedsSummary, n, object);
                    ++this.flowFunctionConstructionCount;
                    Set<D> targets = this.computeReturnFlowFunction(retFunction, d1, d2, c, Collections.singleton(this.zeroValue));
                    this.saveEdges(n, object, d2, targets, true);
                    for (D d5 : targets) {
                        EdgeFunction<V> f5 = this.edgeFunctions.getReturnEdgeFunction(c, this.icfg.getMethodOf(n), n, d2, object, d5);
                        this.propagateUnbalancedReturnFlow(object, d5, f.composeWith(f5), c);
                        this.unbalancedRetSites.add(object);
                    }
                }
            }
            if (callers.isEmpty()) {
                FlowFunction<D> flowFunction = this.flowFunctions.getReturnFlowFunction(null, methodThatNeedsSummary, n, null);
                ++this.flowFunctionConstructionCount;
                flowFunction.computeTargets(d2);
            }
        }
    }

    protected void propagateUnbalancedReturnFlow(N retSiteC, D targetVal, EdgeFunction<V> edgeFunction, N relatedCallSite) {
        this.propagate(this.zeroValue, retSiteC, targetVal, edgeFunction, relatedCallSite, true);
    }

    protected D restoreContextOnReturnedFact(N callSite, D d4, D d5) {
        if (d5 instanceof LinkedNode) {
            ((LinkedNode)d5).setCallingContext(d4);
        }
        if (d5 instanceof JoinHandlingNode) {
            ((JoinHandlingNode)d5).setCallingContext(d4);
        }
        return d5;
    }

    protected Set<D> computeReturnFlowFunction(FlowFunction<D> retFunction, D d1, D d2, N callSite, Set<D> callerSideDs) {
        return retFunction.computeTargets(d2);
    }

    private void processNormalFlow(PathEdge<N, D> edge) {
        D d1 = edge.factAtSource();
        N n = edge.getTarget();
        D d2 = edge.factAtTarget();
        EdgeFunction<V> f = this.jumpFunction(edge);
        for (N m : this.icfg.getSuccsOf(n)) {
            FlowFunction<D> flowFunction = this.flowFunctions.getNormalFlowFunction(n, m);
            ++this.flowFunctionConstructionCount;
            Set<D> res = this.computeNormalFlowFunction(flowFunction, d1, d2);
            this.saveEdges(n, m, d2, res, false);
            for (D d3 : res) {
                EdgeFunction<V> fprime = f.composeWith(this.edgeFunctions.getNormalEdgeFunction(n, d2, m, d3));
                this.propagate(d1, m, d3, fprime, null, false);
            }
        }
    }

    protected Set<D> computeNormalFlowFunction(FlowFunction<D> flowFunction, D d1, D d2) {
        return flowFunction.computeTargets(d2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void propagate(D sourceVal, N target, D targetVal, EdgeFunction<V> f, N relatedCallSite, boolean isUnbalancedReturn) {
        EdgeFunction<V> fPrime;
        boolean newFunction;
        JumpFunctions<N, D, V> jumpFunctions = this.jumpFn;
        synchronized (jumpFunctions) {
            EdgeFunction<V> jumpFnE = this.jumpFn.reverseLookup(target, targetVal).get(sourceVal);
            if (jumpFnE == null) {
                jumpFnE = this.allTop;
            }
            boolean bl = newFunction = !(fPrime = jumpFnE.joinWith(f)).equalTo(jumpFnE);
            if (newFunction) {
                this.jumpFn.addFunction(sourceVal, target, targetVal, fPrime);
            }
        }
        if (newFunction) {
            PathEdge<N, D> edge = new PathEdge<N, D>(sourceVal, target, targetVal);
            this.scheduleEdgeProcessing(edge);
            if (targetVal != this.zeroValue) {
                logger.trace("{} - EDGE: <{},{}> -> <{},{}> - {}", new Object[]{this.getDebugName(), this.icfg.getMethodOf(target), sourceVal, target, targetVal, fPrime});
            }
        }
    }

    private void computeValues() {
        logger.debug("Computing the final values for the edge functions");
        HashMap<N, Set<D>> allSeeds = new HashMap<N, Set<D>>(this.initialSeeds);
        for (N n : this.unbalancedRetSites) {
            HashSet<D> seeds = (HashSet<D>)allSeeds.get(n);
            if (seeds == null) {
                seeds = new HashSet<D>();
                allSeeds.put(n, seeds);
            }
            seeds.add(this.zeroValue);
        }
        for (Map.Entry entry : allSeeds.entrySet()) {
            Object startPoint = entry.getKey();
            for (Object val : (Set)entry.getValue()) {
                this.setVal(startPoint, val, this.valueLattice.bottomElement());
                Pair superGraphNode = new Pair(startPoint, val);
                this.scheduleValueProcessing(new ValuePropagationTask(superGraphNode));
            }
        }
        logger.debug("Computed the final values of the edge functions");
        try {
            this.executor.awaitCompletion();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Set allNonCallStartNodes = this.icfg.allNonCallStartNodes();
        Object[] objectArray = new Object[allNonCallStartNodes.size()];
        int i = 0;
        Iterator<Object> iterator = allNonCallStartNodes.iterator();
        while (iterator.hasNext()) {
            Object n;
            objectArray[i] = n = iterator.next();
            ++i;
        }
        for (int t = 0; t < this.numThreads; ++t) {
            ValueComputationTask task = new ValueComputationTask(objectArray, t);
            this.scheduleValueComputationTask(task);
        }
        try {
            this.executor.awaitCompletion();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void propagateValueAtStart(Pair<N, D> nAndD, N n) {
        D d = nAndD.getO2();
        Object p = this.icfg.getMethodOf(n);
        for (Object c : this.icfg.getCallsFromWithin(p)) {
            JumpFunctions<N, D, V> jumpFunctions = this.jumpFn;
            synchronized (jumpFunctions) {
                Set<Map.Entry<D, EdgeFunction<V>>> entries = this.jumpFn.forwardLookup(d, c).entrySet();
                for (Map.Entry<D, EdgeFunction<V>> dPAndFP : entries) {
                    D dPrime = dPAndFP.getKey();
                    EdgeFunction<V> fPrime = dPAndFP.getValue();
                    N sP = n;
                    this.propagateValue(c, dPrime, fPrime.computeTarget(this.val(sP, d)));
                    ++this.flowFunctionApplicationCount;
                }
            }
        }
    }

    private void propagateValueAtCall(Pair<N, D> nAndD, N n) {
        D d = nAndD.getO2();
        for (Object q : this.icfg.getCalleesOfCallAt(n)) {
            FlowFunction<D> callFlowFunction = this.flowFunctions.getCallFlowFunction(n, q);
            ++this.flowFunctionConstructionCount;
            for (D dPrime : callFlowFunction.computeTargets(d)) {
                EdgeFunction<V> edgeFn = this.edgeFunctions.getCallEdgeFunction(n, d, q, dPrime);
                for (Object startPoint : this.icfg.getStartPointsOf(q)) {
                    this.propagateValue(startPoint, dPrime, edgeFn.computeTarget(this.val(n, d)));
                    ++this.flowFunctionApplicationCount;
                }
            }
        }
    }

    protected V joinValueAt(N unit, D fact, V curr, V newVal) {
        return this.valueLattice.join(curr, newVal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void propagateValue(N nHashN, D nHashD, V v) {
        Table<N, D, V> table = this.val;
        synchronized (table) {
            V valNHash = this.val(nHashN, nHashD);
            V vPrime = this.joinValueAt(nHashN, nHashD, valNHash, v);
            if (!vPrime.equals(valNHash)) {
                this.setVal(nHashN, nHashD, vPrime);
                this.scheduleValueProcessing(new ValuePropagationTask(new Pair<N, D>(nHashN, nHashD)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V val(N nHashN, D nHashD) {
        Object l;
        Table<N, D, V> table = this.val;
        synchronized (table) {
            l = this.val.get(nHashN, nHashD);
        }
        if (l == null) {
            return this.valueLattice.topElement();
        }
        return (V)l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setVal(N nHashN, D nHashD, V l) {
        Table<N, D, V> table = this.val;
        synchronized (table) {
            if (l == this.valueLattice.topElement()) {
                this.val.remove(nHashN, nHashD);
            } else {
                this.val.put(nHashN, nHashD, l);
            }
        }
        logger.debug("VALUE: {} {} {} {}", new Object[]{this.icfg.getMethodOf(nHashN), nHashN, nHashD, l});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EdgeFunction<V> jumpFunction(PathEdge<N, D> edge) {
        JumpFunctions<N, D, V> jumpFunctions = this.jumpFn;
        synchronized (jumpFunctions) {
            EdgeFunction<V> function = this.jumpFn.forwardLookup(edge.factAtSource(), edge.getTarget()).get(edge.factAtTarget());
            if (function == null) {
                return this.allTop;
            }
            return function;
        }
    }

    protected Set<Table.Cell<N, D, EdgeFunction<V>>> endSummary(N sP, D d3) {
        Table map = (Table)this.endSummary.get(sP, d3);
        if (map == null) {
            return Collections.emptySet();
        }
        return map.cellSet();
    }

    private void addEndSummary(N sP, D d1, N eP, D d2, EdgeFunction<V> f) {
        Table summaries = (Table)this.endSummary.get(sP, d1);
        if (summaries == null) {
            summaries = HashBasedTable.create();
            this.endSummary.put(sP, d1, (Object)summaries);
        }
        summaries.put(eP, d2, f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<N, Set<D>> incoming(D d1, N sP) {
        Table<N, D, Map<N, Set<D>>> table = this.incoming;
        synchronized (table) {
            Map map = (Map)this.incoming.get(sP, d1);
            if (map == null) {
                return Collections.emptyMap();
            }
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addIncoming(N sP, D d3, N n, D d2) {
        Table<N, D, Map<N, Set<D>>> table = this.incoming;
        synchronized (table) {
            HashSet<D> set;
            HashMap<N, HashSet<D>> summaries = (HashMap<N, HashSet<D>>)this.incoming.get(sP, d3);
            if (summaries == null) {
                summaries = new HashMap<N, HashSet<D>>();
                this.incoming.put(sP, d3, summaries);
            }
            if ((set = (HashSet<D>)summaries.get(n)) == null) {
                set = new HashSet<D>();
                summaries.put(n, set);
            }
            set.add(d2);
        }
    }

    public V resultAt(N stmt, D value) {
        return (V)this.val.get(stmt, value);
    }

    public Map<D, V> resultsAt(N stmt) {
        return Maps.filterKeys((Map)this.val.row(stmt), (Predicate)new Predicate<D>(){

            public boolean apply(D val) {
                return val != IDESolver.this.zeroValue;
            }
        });
    }

    protected CountingThreadPoolExecutor getExecutor() {
        return new CountingThreadPoolExecutor(1, this.numThreads, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    }

    protected String getDebugName() {
        return "";
    }

    public void printStats() {
        if (logger.isDebugEnabled()) {
            if (this.ffCache != null) {
                this.ffCache.printStats();
            }
            if (this.efCache != null) {
                this.efCache.printStats();
            }
        } else {
            logger.info("No statistics were collected, as DEBUG is disabled.");
        }
    }

    private class ValueComputationTask
    implements Runnable {
        private final N[] values;
        final int num;

        public ValueComputationTask(N[] values, int num) {
            this.values = values;
            this.num = num;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int sectionSize = (int)Math.floor(this.values.length / IDESolver.this.numThreads) + IDESolver.this.numThreads;
            for (int i = sectionSize * this.num; i < Math.min(sectionSize * (this.num + 1), this.values.length); ++i) {
                Object n = this.values[i];
                for (Object sP : IDESolver.this.icfg.getStartPointsOf(IDESolver.this.icfg.getMethodOf(n))) {
                    Set lookupByTarget = IDESolver.this.jumpFn.lookupByTarget(n);
                    for (Table.Cell sourceValTargetValAndFunction : lookupByTarget) {
                        Object dPrime = sourceValTargetValAndFunction.getRowKey();
                        Object d = sourceValTargetValAndFunction.getColumnKey();
                        EdgeFunction fPrime = (EdgeFunction)sourceValTargetValAndFunction.getValue();
                        Table table = IDESolver.this.val;
                        synchronized (table) {
                            IDESolver.this.setVal(n, d, IDESolver.this.valueLattice.join(IDESolver.this.val(n, d), fPrime.computeTarget(IDESolver.this.val(sP, dPrime))));
                        }
                        ++IDESolver.this.flowFunctionApplicationCount;
                    }
                }
            }
        }
    }

    private class ValuePropagationTask
    implements Runnable {
        private final Pair<N, D> nAndD;

        public ValuePropagationTask(Pair<N, D> nAndD) {
            this.nAndD = nAndD;
        }

        @Override
        public void run() {
            Object n = this.nAndD.getO1();
            if (IDESolver.this.icfg.isStartPoint(n) || IDESolver.this.initialSeeds.containsKey(n) || IDESolver.this.unbalancedRetSites.contains(n)) {
                IDESolver.this.propagateValueAtStart(this.nAndD, n);
            }
            if (IDESolver.this.icfg.isCallStmt(n)) {
                IDESolver.this.propagateValueAtCall(this.nAndD, n);
            }
        }
    }

    private class PathEdgeProcessingTask
    implements Runnable {
        private final PathEdge<N, D> edge;

        public PathEdgeProcessingTask(PathEdge<N, D> edge) {
            this.edge = edge;
        }

        @Override
        public void run() {
            if (IDESolver.this.icfg.isCallStmt(this.edge.getTarget())) {
                IDESolver.this.processCall(this.edge);
            } else {
                if (IDESolver.this.icfg.isExitStmt(this.edge.getTarget())) {
                    IDESolver.this.processExit(this.edge);
                }
                if (!IDESolver.this.icfg.getSuccsOf(this.edge.getTarget()).isEmpty()) {
                    IDESolver.this.processNormalFlow(this.edge);
                }
            }
        }
    }
}

