/*
 * Decompiled with CFR 0.152.
 */
package heros.solver;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import heros.DontSynchronize;
import heros.EdgeFunction;
import heros.SynchronizedBy;
import heros.ThreadSafe;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

@ThreadSafe
public class JumpFunctions<N, D, L> {
    @SynchronizedBy(value="consistent lock on this")
    protected Table<N, D, Map<D, EdgeFunction<L>>> nonEmptyReverseLookup = HashBasedTable.create();
    @SynchronizedBy(value="consistent lock on this")
    protected Table<D, N, Map<D, EdgeFunction<L>>> nonEmptyForwardLookup = HashBasedTable.create();
    @SynchronizedBy(value="consistent lock on this")
    protected Map<N, Table<D, D, EdgeFunction<L>>> nonEmptyLookupByTargetNode = new HashMap<N, Table<D, D, EdgeFunction<L>>>();
    @DontSynchronize(value="immutable")
    private final EdgeFunction<L> allTop;

    public JumpFunctions(EdgeFunction<L> allTop) {
        this.allTop = allTop;
    }

    public synchronized void addFunction(D sourceVal, N target, D targetVal, EdgeFunction<L> function) {
        assert (sourceVal != null);
        assert (target != null);
        assert (targetVal != null);
        assert (function != null);
        if (function.equalTo(this.allTop)) {
            return;
        }
        LinkedHashMap<D, EdgeFunction<L>> sourceValToFunc = (LinkedHashMap<D, EdgeFunction<L>>)this.nonEmptyReverseLookup.get(target, targetVal);
        if (sourceValToFunc == null) {
            sourceValToFunc = new LinkedHashMap<D, EdgeFunction<L>>();
            this.nonEmptyReverseLookup.put(target, targetVal, sourceValToFunc);
        }
        sourceValToFunc.put(sourceVal, function);
        LinkedHashMap<D, EdgeFunction<L>> targetValToFunc = (LinkedHashMap<D, EdgeFunction<L>>)this.nonEmptyForwardLookup.get(sourceVal, target);
        if (targetValToFunc == null) {
            targetValToFunc = new LinkedHashMap<D, EdgeFunction<L>>();
            this.nonEmptyForwardLookup.put(sourceVal, target, targetValToFunc);
        }
        targetValToFunc.put(targetVal, function);
        HashBasedTable table = this.nonEmptyLookupByTargetNode.get(target);
        if (table == null) {
            table = HashBasedTable.create();
            this.nonEmptyLookupByTargetNode.put(target, (Table<D, D, EdgeFunction<L>>)table);
        }
        table.put(sourceVal, targetVal, function);
    }

    public synchronized Map<D, EdgeFunction<L>> reverseLookup(N target, D targetVal) {
        assert (target != null);
        assert (targetVal != null);
        Map res = (Map)this.nonEmptyReverseLookup.get(target, targetVal);
        if (res == null) {
            return Collections.emptyMap();
        }
        return res;
    }

    public synchronized Map<D, EdgeFunction<L>> forwardLookup(D sourceVal, N target) {
        assert (sourceVal != null);
        assert (target != null);
        Map res = (Map)this.nonEmptyForwardLookup.get(sourceVal, target);
        if (res == null) {
            return Collections.emptyMap();
        }
        return res;
    }

    public synchronized Set<Table.Cell<D, D, EdgeFunction<L>>> lookupByTarget(N target) {
        assert (target != null);
        Table<D, D, EdgeFunction<L>> table = this.nonEmptyLookupByTargetNode.get(target);
        if (table == null) {
            return Collections.emptySet();
        }
        Set res = table.cellSet();
        if (res == null) {
            return Collections.emptySet();
        }
        return res;
    }

    public synchronized boolean removeFunction(D sourceVal, N target, D targetVal) {
        Table<D, D, EdgeFunction<L>> table;
        Map targetValToFunc;
        assert (sourceVal != null);
        assert (target != null);
        assert (targetVal != null);
        Map sourceValToFunc = (Map)this.nonEmptyReverseLookup.get(target, targetVal);
        if (sourceValToFunc == null) {
            return false;
        }
        if (sourceValToFunc.remove(sourceVal) == null) {
            return false;
        }
        if (sourceValToFunc.isEmpty()) {
            this.nonEmptyReverseLookup.remove(targetVal, targetVal);
        }
        if ((targetValToFunc = (Map)this.nonEmptyForwardLookup.get(sourceVal, target)) == null) {
            return false;
        }
        if (targetValToFunc.remove(targetVal) == null) {
            return false;
        }
        if (targetValToFunc.isEmpty()) {
            this.nonEmptyForwardLookup.remove(sourceVal, target);
        }
        if ((table = this.nonEmptyLookupByTargetNode.get(target)) == null) {
            return false;
        }
        if (table.remove(sourceVal, targetVal) == null) {
            return false;
        }
        if (table.isEmpty()) {
            this.nonEmptyLookupByTargetNode.remove(target);
        }
        return true;
    }

    public synchronized void clear() {
        this.nonEmptyForwardLookup.clear();
        this.nonEmptyLookupByTargetNode.clear();
        this.nonEmptyReverseLookup.clear();
    }
}

