/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.pkipath.bc;

import eu.emi.security.authn.x509.ValidationErrorCode;
import eu.emi.security.authn.x509.helpers.pkipath.ExtPKIXParameters;
import eu.emi.security.authn.x509.helpers.pkipath.SimpleValidationErrorException;
import eu.emi.security.authn.x509.helpers.pkipath.bc.CertPathValidatorUtilities;
import eu.emi.security.authn.x509.helpers.pkipath.bc.CertStatus;
import eu.emi.security.authn.x509.helpers.pkipath.bc.ReasonsMask;
import java.security.PublicKey;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREnumerated;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.IssuingDistributionPoint;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.i18n.filter.TrustedInput;
import org.bouncycastle.jce.provider.AnnotatedException;
import org.bouncycastle.jce.provider.RFC3280CertPathUtilities;
import org.bouncycastle.jce.provider.X509CRLEntryObject;
import org.bouncycastle.jce.provider.X509CRLObject;
import org.bouncycastle.x509.ExtendedPKIXParameters;

public class RFC3280CertPathUtilitiesHelper
extends RFC3280CertPathUtilities {
    protected static void checkCRLs2(ExtPKIXParameters paramsPKIX, X509Certificate cert, Date validDate, X509Certificate sign, PublicKey workingPublicKey, List<?> certPathCerts) throws SimpleValidationErrorException {
        ExtPKIXParameters paramsPKIXClone;
        SimpleValidationErrorException lastException = null;
        CRLDistPoint crldp = null;
        try {
            crldp = CRLDistPoint.getInstance((Object)CertPathValidatorUtilities.getExtensionValue(cert, RFC3280CertPathUtilities.CRL_DISTRIBUTION_POINTS));
        }
        catch (Exception e) {
            throw new SimpleValidationErrorException(ValidationErrorCode.crlDistPtExtError, e);
        }
        try {
            CertPathValidatorUtilities.addAdditionalStoresFromCRLDistributionPoint(crldp, (ExtendedPKIXParameters)paramsPKIX);
        }
        catch (AnnotatedException e) {
            throw new SimpleValidationErrorException(ValidationErrorCode.crlDistPtExtError, new Object[]{e});
        }
        CertStatus certStatus = new CertStatus();
        ReasonsMask reasonsMask = new ReasonsMask();
        boolean validCrlFound = false;
        if (crldp != null) {
            DistributionPoint[] dps = null;
            try {
                dps = crldp.getDistributionPoints();
            }
            catch (Exception e) {
                throw new SimpleValidationErrorException(ValidationErrorCode.crlDistPtExtError, e);
            }
            if (dps != null) {
                for (int i = 0; i < dps.length && certStatus.getCertStatus() == 11 && !reasonsMask.isAllReasons(); ++i) {
                    paramsPKIXClone = paramsPKIX.clone();
                    try {
                        RFC3280CertPathUtilitiesHelper.checkCRL(dps[i], (ExtendedPKIXParameters)paramsPKIXClone, cert, validDate, sign, workingPublicKey, certStatus, reasonsMask, certPathCerts);
                        validCrlFound = true;
                        continue;
                    }
                    catch (SimpleValidationErrorException e) {
                        lastException = e;
                    }
                }
            }
        }
        if (certStatus.getCertStatus() == 11 && !reasonsMask.isAllReasons()) {
            try {
                DERObject issuer = null;
                try {
                    issuer = new ASN1InputStream(CertPathValidatorUtilities.getEncodedIssuerPrincipal(cert).getEncoded()).readObject();
                }
                catch (Exception e) {
                    throw new SimpleValidationErrorException(ValidationErrorCode.crlIssuerException, e);
                }
                DistributionPoint dp = new DistributionPoint(new DistributionPointName(0, (ASN1Encodable)new GeneralNames(new GeneralName(4, (ASN1Encodable)issuer))), null, null);
                paramsPKIXClone = paramsPKIX.clone();
                RFC3280CertPathUtilitiesHelper.checkCRL(dp, (ExtendedPKIXParameters)paramsPKIXClone, cert, validDate, sign, workingPublicKey, certStatus, reasonsMask, certPathCerts);
                validCrlFound = true;
            }
            catch (SimpleValidationErrorException e) {
                lastException = e;
            }
        }
        if (!validCrlFound) {
            throw lastException;
        }
        if (certStatus.getCertStatus() != 11) {
            throw new SimpleValidationErrorException(ValidationErrorCode.certRevoked, new TrustedInput((Object)certStatus.getRevocationDate()), crlReasons[certStatus.getCertStatus()]);
        }
        if (!reasonsMask.isAllReasons() && certStatus.getCertStatus() == 11) {
            certStatus.setCertStatus(12);
        }
        if (certStatus.getCertStatus() == 12) {
            throw new SimpleValidationErrorException(ValidationErrorCode.noValidCrlFound, new Object[0]);
        }
    }

    private static void checkCRL(DistributionPoint dp, ExtendedPKIXParameters paramsPKIX, X509Certificate cert, Date validDate, X509Certificate defaultCRLSignCert, PublicKey defaultCRLSignKey, CertStatus certStatus, ReasonsMask reasonMask, List<?> certPathCerts) throws SimpleValidationErrorException {
        Date currentDate = new Date(System.currentTimeMillis());
        if (validDate.getTime() > currentDate.getTime()) {
            throw new IllegalArgumentException("CRL validation time is in future: " + validDate);
        }
        Set<?> crls = CertPathValidatorUtilities.getCompleteCRLs2(dp, cert, currentDate, paramsPKIX);
        boolean validCrlFound = false;
        SimpleValidationErrorException lastException = null;
        Iterator<?> crl_iter = crls.iterator();
        while (crl_iter.hasNext() && certStatus.getCertStatus() == 11 && !reasonMask.isAllReasons()) {
            try {
                X509CRL crl = (X509CRL)crl_iter.next();
                ReasonsMask interimReasonsMask = RFC3280CertPathUtilitiesHelper.processCRLD2(crl, dp);
                if (!interimReasonsMask.hasNewReasons(reasonMask)) continue;
                Set<?> keys = RFC3280CertPathUtilitiesHelper.processCRLF2(crl, cert, defaultCRLSignCert, defaultCRLSignKey, paramsPKIX, certPathCerts);
                PublicKey key = RFC3280CertPathUtilitiesHelper.processCRLG2(crl, keys);
                X509CRL deltaCRL = null;
                if (paramsPKIX.isUseDeltasEnabled()) {
                    Set<X509CRL> deltaCRLs = CertPathValidatorUtilities.getDeltaCRLs2(currentDate, paramsPKIX, crl);
                    deltaCRL = RFC3280CertPathUtilitiesHelper.processCRLH2(deltaCRLs, key);
                }
                if (paramsPKIX.getValidityModel() != 1 && cert.getNotAfter().getTime() < crl.getThisUpdate().getTime()) {
                    throw new SimpleValidationErrorException(ValidationErrorCode.noValidCrlFound, new Object[0]);
                }
                RFC3280CertPathUtilitiesHelper.processCRLB1_2(dp, cert, crl);
                RFC3280CertPathUtilitiesHelper.processCRLB2_2(dp, cert, crl);
                RFC3280CertPathUtilitiesHelper.processCRLC2(deltaCRL, crl, paramsPKIX);
                RFC3280CertPathUtilitiesHelper.processCRLI(validDate, deltaCRL, cert, certStatus, paramsPKIX);
                RFC3280CertPathUtilitiesHelper.processCRLJ(validDate, crl, cert, certStatus);
                if (certStatus.getCertStatus() == 8) {
                    certStatus.setCertStatus(11);
                }
                reasonMask.addReasons(interimReasonsMask);
                Set<String> criticalExtensions = crl.getCriticalExtensionOIDs();
                if (criticalExtensions != null) {
                    criticalExtensions = new HashSet<String>(criticalExtensions);
                    criticalExtensions.remove(X509Extensions.IssuingDistributionPoint.getId());
                    criticalExtensions.remove(X509Extensions.DeltaCRLIndicator.getId());
                    if (!criticalExtensions.isEmpty()) {
                        throw new SimpleValidationErrorException(ValidationErrorCode.crlUnknownCritExt, criticalExtensions.iterator().next());
                    }
                }
                if (deltaCRL != null && (criticalExtensions = deltaCRL.getCriticalExtensionOIDs()) != null) {
                    criticalExtensions = new HashSet<String>(criticalExtensions);
                    criticalExtensions.remove(X509Extensions.IssuingDistributionPoint.getId());
                    criticalExtensions.remove(X509Extensions.DeltaCRLIndicator.getId());
                    if (!criticalExtensions.isEmpty()) {
                        throw new SimpleValidationErrorException(ValidationErrorCode.crlUnknownCritExt, criticalExtensions.iterator().next());
                    }
                }
                validCrlFound = true;
            }
            catch (SimpleValidationErrorException e) {
                lastException = e;
            }
        }
        if (!validCrlFound) {
            throw lastException;
        }
    }

    protected static void processCRLB1_2(DistributionPoint dp, Object cert, X509CRL crl) throws SimpleValidationErrorException {
        try {
            RFC3280CertPathUtilities.processCRLB1((DistributionPoint)dp, (Object)cert, (X509CRL)crl);
        }
        catch (AnnotatedException e) {
            if (e.getMessage().startsWith("CRL issuer information from distribution point cannot be decoded")) {
                throw new SimpleValidationErrorException(ValidationErrorCode.crlIssuerException, e.getCause());
            }
            if (e.getMessage().startsWith("Distribution point contains cRLIssuer field but CRL is not indirect")) {
                throw new SimpleValidationErrorException(ValidationErrorCode.distrPtExtError, e.getMessage());
            }
            if (e.getMessage().startsWith("CRL issuer of CRL does not match CRL issuer of distribution point")) {
                throw new SimpleValidationErrorException(ValidationErrorCode.distrPtExtError, e.getMessage());
            }
            if (e.getMessage().startsWith("Cannot find matching CRL issuer for certificate")) {
                throw new SimpleValidationErrorException(ValidationErrorCode.crlNoIssuerForDP, new Object[0]);
            }
            if (e.getMessage().startsWith("exception processing extension")) {
                throw new SimpleValidationErrorException(ValidationErrorCode.distrPtExtError, e.getCause());
            }
            throw new SimpleValidationErrorException(ValidationErrorCode.unknownMsg, new Object[]{e});
        }
    }

    protected static void processCRLB2_2(DistributionPoint dp, Object cert, X509CRL crl) throws SimpleValidationErrorException {
        try {
            RFC3280CertPathUtilities.processCRLB2((DistributionPoint)dp, (Object)cert, (X509CRL)crl);
        }
        catch (AnnotatedException e) {
            if (e.getMessage().startsWith("Issuing distribution point extension could not be decoded")) {
                throw new SimpleValidationErrorException(ValidationErrorCode.distrPtExtError, e.getCause());
            }
            if (e.getMessage().startsWith("Could not read CRL issuer")) {
                throw new SimpleValidationErrorException(ValidationErrorCode.crlIssuerException, new Object[]{e});
            }
            if (e.getMessage().startsWith("No match for certificate CRL issuing distribution point name to cRLIssuer CRL distribution point")) {
                throw new SimpleValidationErrorException(ValidationErrorCode.crlIDPAndDPMismatch, new Object[0]);
            }
            if (e.getMessage().startsWith("Either the cRLIssuer or the distributionPoint field must")) {
                throw new SimpleValidationErrorException(ValidationErrorCode.crlNoIssuerAndDP, new Object[0]);
            }
            if (e.getMessage().startsWith("Basic constraints extension could not be decoded")) {
                throw new SimpleValidationErrorException(ValidationErrorCode.crlBCExtError, e.getCause());
            }
            if (e.getMessage().startsWith("CA Cert CRL only contains user certificates")) {
                throw new SimpleValidationErrorException(ValidationErrorCode.crlOnlyUserCert, new Object[0]);
            }
            if (e.getMessage().startsWith("End CRL only contains CA certificates")) {
                throw new SimpleValidationErrorException(ValidationErrorCode.crlOnlyCaCert, new Object[0]);
            }
            if (e.getMessage().startsWith("onlyContainsAttributeCerts boolean is asserted")) {
                throw new SimpleValidationErrorException(ValidationErrorCode.crlOnlyAttrCert, new Object[0]);
            }
            throw new SimpleValidationErrorException(ValidationErrorCode.unknownMsg, new Object[]{e});
        }
    }

    protected static void processCRLC2(X509CRL deltaCRL, X509CRL completeCRL, ExtendedPKIXParameters pkixParams) throws SimpleValidationErrorException {
        try {
            RFC3280CertPathUtilities.processCRLC((X509CRL)deltaCRL, (X509CRL)completeCRL, (ExtendedPKIXParameters)pkixParams);
        }
        catch (AnnotatedException e) {
            if (e.getMessage().startsWith("Issuing distribution point extension")) {
                throw new SimpleValidationErrorException(ValidationErrorCode.distrPtExtError, e.getCause());
            }
            if (e.getMessage().startsWith("Complete CRL issuer does not match delta CRL issuer")) {
                throw new SimpleValidationErrorException(ValidationErrorCode.crlDeltaProblem, e.getMessage());
            }
            if (e.getMessage().startsWith("Issuing distribution point extension from delta CRL and complete CRL does not match")) {
                throw new SimpleValidationErrorException(ValidationErrorCode.crlDeltaProblem, e.getMessage());
            }
            if (e.getMessage().startsWith("Authority key identifier extension could not be extracted from")) {
                throw new SimpleValidationErrorException(ValidationErrorCode.crlAKIExtError, e.getCause());
            }
            if (e.getMessage().startsWith("CRL authority key identifier is null")) {
                throw new SimpleValidationErrorException(ValidationErrorCode.crlAKIExtError, e.getMessage());
            }
            if (e.getMessage().startsWith("Delta CRL authority key identifier is null")) {
                throw new SimpleValidationErrorException(ValidationErrorCode.crlAKIExtError, e.getMessage());
            }
            if (e.getMessage().startsWith("Delta CRL authority key identifier does not match complete CRL authority key identifier")) {
                throw new SimpleValidationErrorException(ValidationErrorCode.crlDeltaProblem, e.getMessage());
            }
            throw new SimpleValidationErrorException(ValidationErrorCode.unknownMsg, new Object[]{e});
        }
    }

    protected static Set<?> processCRLF2(X509CRL crl, Object cert, X509Certificate defaultCRLSignCert, PublicKey defaultCRLSignKey, ExtendedPKIXParameters paramsPKIX, List<?> certPathCerts) throws SimpleValidationErrorException {
        try {
            return RFC3280CertPathUtilities.processCRLF((X509CRL)crl, (Object)cert, (X509Certificate)defaultCRLSignCert, (PublicKey)defaultCRLSignKey, (ExtendedPKIXParameters)paramsPKIX, certPathCerts);
        }
        catch (AnnotatedException e) {
            if (e.getMessage().startsWith("Subject criteria for certificate selector to find issuer certificate for CRL could not be set")) {
                new RuntimeException(e.getMessage(), e);
            } else if (e.getMessage().startsWith("Issuer certificate for CRL cannot be searched")) {
                new RuntimeException(e.getMessage(), e);
            } else {
                if (e.getMessage().startsWith("Internal error")) {
                    throw new SimpleValidationErrorException(ValidationErrorCode.crlNoIssuerPublicKey, e.getCause());
                }
                if (e.getMessage().startsWith("Public key of issuer certificate of CRL could not be retrieved")) {
                    throw new SimpleValidationErrorException(ValidationErrorCode.crlNoIssuerPublicKey, e.getCause());
                }
                if (e.getMessage().startsWith("Issuer certificate key usage extension does not permit CRL signing")) {
                    throw new SimpleValidationErrorException(ValidationErrorCode.noCrlSigningPermited, new Object[0]);
                }
                if (e.getMessage().startsWith("Cannot find a valid issuer certificate")) {
                    throw new SimpleValidationErrorException(ValidationErrorCode.crlNoIssuerPublicKey, e.getMessage());
                }
            }
            throw new SimpleValidationErrorException(ValidationErrorCode.unknownMsg, new Object[]{e});
        }
    }

    protected static X509CRL processCRLH2(Set<?> deltacrls, PublicKey key) throws SimpleValidationErrorException {
        try {
            return RFC3280CertPathUtilities.processCRLH(deltacrls, (PublicKey)key);
        }
        catch (AnnotatedException e) {
            throw new SimpleValidationErrorException(ValidationErrorCode.crlVerifyFailed, new Object[]{e});
        }
    }

    protected static PublicKey processCRLG2(X509CRL crl, Set<?> keys) throws SimpleValidationErrorException {
        try {
            return RFC3280CertPathUtilities.processCRLG((X509CRL)crl, keys);
        }
        catch (AnnotatedException e) {
            throw new SimpleValidationErrorException(ValidationErrorCode.crlVerifyFailed, new Object[]{e});
        }
    }

    protected static void processCRLI(Date validDate, X509CRL deltacrl, Object cert, CertStatus certStatus, ExtendedPKIXParameters pkixParams) throws SimpleValidationErrorException {
        if (pkixParams.isUseDeltasEnabled() && deltacrl != null) {
            RFC3280CertPathUtilitiesHelper.getCertStatus(validDate, deltacrl, cert, certStatus);
        }
    }

    protected static void processCRLJ(Date validDate, X509CRL completecrl, Object cert, CertStatus certStatus) throws SimpleValidationErrorException {
        if (certStatus.getCertStatus() == 11) {
            RFC3280CertPathUtilitiesHelper.getCertStatus(validDate, completecrl, cert, certStatus);
        }
    }

    protected static ReasonsMask processCRLD2(X509CRL crl, DistributionPoint dp) throws SimpleValidationErrorException {
        IssuingDistributionPoint idp = null;
        try {
            idp = IssuingDistributionPoint.getInstance((Object)CertPathValidatorUtilities.getExtensionValue(crl, RFC3280CertPathUtilities.ISSUING_DISTRIBUTION_POINT));
        }
        catch (Exception e) {
            throw new SimpleValidationErrorException(ValidationErrorCode.distrPtExtError, e);
        }
        if (idp != null && idp.getOnlySomeReasons() != null && dp.getReasons() != null) {
            return new ReasonsMask(dp.getReasons().intValue()).intersect(new ReasonsMask(idp.getOnlySomeReasons().intValue()));
        }
        if ((idp == null || idp.getOnlySomeReasons() == null) && dp.getReasons() == null) {
            return ReasonsMask.allReasons;
        }
        return (dp.getReasons() == null ? ReasonsMask.allReasons : new ReasonsMask(dp.getReasons().intValue())).intersect(idp == null ? ReasonsMask.allReasons : new ReasonsMask(idp.getOnlySomeReasons().intValue()));
    }

    protected static void getCertStatus(Date validDate, X509CRL crl, Object cert, CertStatus certStatus) throws SimpleValidationErrorException {
        X509CRLObject bcCRL = null;
        try {
            bcCRL = new X509CRLObject(new CertificateList((ASN1Sequence)ASN1Sequence.fromByteArray((byte[])crl.getEncoded())));
        }
        catch (Exception e) {
            throw new SimpleValidationErrorException(ValidationErrorCode.unknownMsg, e);
        }
        X509CRLEntryObject crl_entry = (X509CRLEntryObject)bcCRL.getRevokedCertificate(CertPathValidatorUtilities.getSerialNumber(cert));
        if (crl_entry != null && (CertPathValidatorUtilities.getEncodedIssuerPrincipal(cert).equals(crl_entry.getCertificateIssuer()) || CertPathValidatorUtilities.getEncodedIssuerPrincipal(cert).equals(crl.getIssuerX500Principal()))) {
            DEREnumerated reasonCode = null;
            if (crl_entry.hasExtensions()) {
                try {
                    reasonCode = DEREnumerated.getInstance((Object)CertPathValidatorUtilities.getExtensionValue((X509Extension)crl_entry, X509Extensions.ReasonCode.getId()));
                }
                catch (Exception e) {
                    throw new SimpleValidationErrorException(ValidationErrorCode.crlReasonExtError, e);
                }
            }
            if (validDate.getTime() >= crl_entry.getRevocationDate().getTime() || reasonCode == null || reasonCode.getValue().intValue() == 0 || reasonCode.getValue().intValue() == 1 || reasonCode.getValue().intValue() == 2 || reasonCode.getValue().intValue() == 8) {
                if (reasonCode != null) {
                    certStatus.setCertStatus(reasonCode.getValue().intValue());
                } else {
                    certStatus.setCertStatus(0);
                }
                certStatus.setRevocationDate(crl_entry.getRevocationDate());
            }
        }
    }
}

