/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.proxy;

import eu.emi.security.authn.x509.helpers.proxy.FixedV3TBSCertificateGenerator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.Time;
import org.bouncycastle.asn1.x509.X509ExtensionsGenerator;

public class X509v3CertificateBuilder {
    private FixedV3TBSCertificateGenerator tbsGen = new FixedV3TBSCertificateGenerator();
    private X509ExtensionsGenerator extGenerator;

    public X509v3CertificateBuilder(X500Name issuer, BigInteger serial, Date notBefore, Date notAfter, X500Name subject, SubjectPublicKeyInfo publicKeyInfo) {
        this.tbsGen.setSerialNumber(new DERInteger(serial));
        this.tbsGen.setIssuer(issuer);
        this.tbsGen.setStartDate(new Time(notBefore));
        this.tbsGen.setEndDate(new Time(notAfter));
        this.tbsGen.setSubject(subject);
        this.tbsGen.setSubjectPublicKeyInfo(publicKeyInfo);
        this.extGenerator = new X509ExtensionsGenerator();
    }

    public X509v3CertificateBuilder addExtension(ASN1ObjectIdentifier oid, boolean isCritical, ASN1Encodable value) {
        this.extGenerator.addExtension((DERObjectIdentifier)oid, isCritical, (DEREncodable)value);
        return this;
    }

    public X509Certificate build(PrivateKey key, AlgorithmIdentifier sigAlg, String sigAlgName, String provider, SecureRandom random) throws InvalidKeyException, CertificateParsingException, NoSuchProviderException, NoSuchAlgorithmException, SignatureException, IOException {
        if (sigAlg == null || sigAlgName == null) {
            throw new IllegalStateException("no signature algorithm specified");
        }
        if (key == null) {
            throw new IllegalStateException("no private key specified");
        }
        this.tbsGen.setSignature(sigAlg);
        if (!this.extGenerator.isEmpty()) {
            this.tbsGen.setExtensions(this.extGenerator.generate());
        }
        DERSequence toSign = this.tbsGen.generateTBSCertificate();
        return this.sign(toSign, sigAlg, sigAlgName, key, provider, random);
    }

    private X509Certificate sign(DERSequence toSign, AlgorithmIdentifier sigAlg, String sigAlgName, PrivateKey key, String provider, SecureRandom random) throws InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException, SignatureException, IOException, CertificateParsingException {
        byte[] signature = this.calculateSignature(sigAlgName, provider, key, random, (ASN1Encodable)toSign);
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((DEREncodable)toSign);
        v.add((DEREncodable)sigAlg.toASN1Object());
        v.add((DEREncodable)new DERBitString(signature));
        DERSequence derCertificate = new DERSequence(v);
        try {
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream bais = new ByteArrayInputStream(derCertificate.getDEREncoded());
            return (X509Certificate)factory.generateCertificate(bais);
        }
        catch (CertificateException e) {
            throw new RuntimeException("The generated proxy certificate was not parsed by the JDK", e);
        }
    }

    private byte[] calculateSignature(String sigName, String provider, PrivateKey key, SecureRandom random, ASN1Encodable object) throws IOException, NoSuchProviderException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Signature sig = provider != null ? Signature.getInstance(sigName, provider) : Signature.getInstance(sigName);
        if (random != null) {
            sig.initSign(key, random);
        } else {
            sig.initSign(key);
        }
        sig.update(object.getEncoded("DER"));
        return sig.sign();
    }

    public static AlgorithmIdentifier extractAlgorithmId(X509Certificate cert) throws IOException {
        String oid = cert.getSigAlgOID();
        byte[] params = cert.getSigAlgParams();
        if (params != null) {
            ASN1Object derParams = ASN1Object.fromByteArray((byte[])params);
            return new AlgorithmIdentifier(new DERObjectIdentifier(oid), (DEREncodable)derParams);
        }
        return new AlgorithmIdentifier(new DERObjectIdentifier(oid));
    }
}

