/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.proxy;

import eu.emi.security.authn.x509.proxy.OidAndValue;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBoolean;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;

public class CertificateExtension
extends OidAndValue<ASN1Encodable>
implements DEREncodable {
    private boolean critical;

    public CertificateExtension(String oid, ASN1Encodable value, boolean critical) {
        super(oid, value);
        this.critical = critical;
    }

    public CertificateExtension(byte[] encoded) {
        ASN1Sequence seq = ASN1Sequence.getInstance((Object)encoded);
        if (seq.size() != 2 && seq.size() != 3) {
            throw new IllegalArgumentException("Certificate extension must have 2 or 3 elements");
        }
        ASN1ObjectIdentifier oidId = (ASN1ObjectIdentifier)seq.getObjectAt(0);
        this.oid = oidId.getId();
        if (seq.size() == 2) {
            this.critical = false;
            this.value = (ASN1Encodable)seq.getObjectAt(1);
        } else {
            DERBoolean crit = (DERBoolean)seq.getObjectAt(1);
            this.critical = crit.isTrue();
            this.value = (ASN1Encodable)seq.getObjectAt(2);
        }
    }

    public boolean isCritical() {
        return this.critical;
    }

    public void setCritical(boolean critical) {
        this.critical = critical;
    }

    public DERObject getDERObject() {
        ASN1ObjectIdentifier oid = new ASN1ObjectIdentifier(this.getOid());
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((DEREncodable)oid);
        if (this.isCritical()) {
            v.add((DEREncodable)new DERBoolean(true));
        }
        v.add(this.getValue());
        return new DERSequence(v);
    }
}

