/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.odt.textstyling;

import fr.opensagres.xdocreport.core.utils.StringUtils;
import fr.opensagres.xdocreport.document.odt.template.ODTContextHelper;
import fr.opensagres.xdocreport.document.odt.textstyling.IODTStylesGenerator;
import fr.opensagres.xdocreport.document.preprocessor.sax.BufferedElement;
import fr.opensagres.xdocreport.document.textstyling.AbstractDocumentHandler;
import fr.opensagres.xdocreport.document.textstyling.IDocumentHandler;
import fr.opensagres.xdocreport.document.textstyling.properties.ContainerProperties;
import fr.opensagres.xdocreport.document.textstyling.properties.HeaderProperties;
import fr.opensagres.xdocreport.document.textstyling.properties.ListItemProperties;
import fr.opensagres.xdocreport.document.textstyling.properties.ListProperties;
import fr.opensagres.xdocreport.document.textstyling.properties.ParagraphProperties;
import fr.opensagres.xdocreport.document.textstyling.properties.SpanProperties;
import fr.opensagres.xdocreport.document.textstyling.properties.TableCellProperties;
import fr.opensagres.xdocreport.document.textstyling.properties.TableProperties;
import fr.opensagres.xdocreport.document.textstyling.properties.TableRowProperties;
import fr.opensagres.xdocreport.template.IContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class ODTDocumentHandler
extends AbstractDocumentHandler {
    private Stack<Boolean> paragraphsStack;
    private boolean insideHeader = false;
    private Stack<Integer> spanStack;
    private int listDepth = 0;
    private List<Boolean> lastItemAlreadyClosed = new ArrayList<Boolean>();
    protected final IODTStylesGenerator styleGen;
    private boolean paragraphWasInserted;
    private boolean closeHeader;
    protected String itemStyle = "";

    public ODTDocumentHandler(BufferedElement parent, IContext context, String entryName) {
        super(parent, context, entryName);
        this.styleGen = ODTContextHelper.getStylesGenerator(context);
        this.paragraphWasInserted = false;
        this.closeHeader = false;
    }

    public void startDocument() {
        this.paragraphsStack = new Stack();
        this.spanStack = new Stack();
    }

    public void endDocument() throws IOException {
        this.endParagraphIfNeeded();
    }

    private void endParagraphIfNeeded() throws IOException {
        if (!this.paragraphsStack.isEmpty()) {
            this.paragraphsStack.size();
            for (int i = 0; i < this.paragraphsStack.size(); ++i) {
                this.internalEndParagraph();
            }
            this.paragraphsStack.clear();
        }
    }

    public void startBold() throws IOException {
        this.internalStartSpan(this.styleGen.getBoldStyleName(), true);
    }

    public void endBold() throws IOException {
        this.internalEndSpan();
    }

    public void startItalics() throws IOException {
        this.internalStartSpan(this.styleGen.getItalicStyleName(), true);
    }

    public void endItalics() throws IOException {
        this.internalEndSpan();
    }

    public void startUnderline() throws IOException {
        this.internalStartSpan(this.styleGen.getUnderlineStyleName(), true);
    }

    public void endUnderline() throws IOException {
        this.internalEndSpan();
    }

    public void startStrike() throws IOException {
        this.internalStartSpan(this.styleGen.getStrikeStyleName(), true);
    }

    public void endStrike() throws IOException {
        this.internalEndSpan();
    }

    public void startSubscript() throws IOException {
        this.internalStartSpan(this.styleGen.getSubscriptStyleName(), true);
    }

    public void endSubscript() throws IOException {
        this.internalEndSpan();
    }

    public void startSuperscript() throws IOException {
        this.internalStartSpan(this.styleGen.getSuperscriptStyleName(), true);
    }

    public void endSuperscript() throws IOException {
        this.internalEndSpan();
    }

    public void handleString(String content) throws IOException {
        content = StringUtils.xmlUnescape((String)content);
        content = StringUtils.xmlEscape((String)content);
        if (this.insideHeader) {
            super.write(content);
        } else {
            this.startSpanIfNeeded();
            super.write(content);
            this.internalEndSpan();
        }
    }

    private void startSpanIfNeeded() throws IOException {
        boolean spanNeeded = true;
        for (Integer depth : this.spanStack) {
            if (depth == 0) continue;
            spanNeeded = false;
            break;
        }
        if (spanNeeded) {
            this.internalStartSpan(this.styleGen.getTextStyleName(null), true);
        } else {
            this.spanStack.push(0);
        }
    }

    private void internalStartSpan(String styleName, boolean push) throws IOException {
        this.startParagraphIfNeeded();
        super.write("<text:span");
        if (StringUtils.isNotEmpty((String)styleName)) {
            super.write(" text:style-name=\"");
            super.write(styleName);
            super.write("\" ");
        }
        super.write(">");
        if (push) {
            this.spanStack.push(1);
        }
    }

    private void internalEndSpan() throws IOException {
        Integer depth = this.spanStack.pop();
        while (depth > 0) {
            super.write("</text:span>");
            Integer n = depth;
            depth = depth - 1;
        }
    }

    private void startParagraphIfNeeded() throws IOException {
        if (this.paragraphWasInserted && this.paragraphsStack.isEmpty() || this.closeHeader) {
            this.internalStartParagraph(false, (String)null);
        }
    }

    public void startParagraph(ParagraphProperties properties) throws IOException {
        if (this.paragraphsStack.isEmpty() || !this.paragraphsStack.peek().booleanValue()) {
            super.setTextLocation(IDocumentHandler.TextLocation.End);
            this.internalStartParagraph(false, properties);
        }
    }

    public void endParagraph() throws IOException {
        this.internalEndParagraph();
    }

    private void internalStartParagraph(boolean containerIsList, ParagraphProperties properties) throws IOException {
        String styleName = null;
        if (properties != null) {
            styleName = properties.isPageBreakAfter() ? this.styleGen.getParaBreakAfterStyleName() : (properties.isPageBreakBefore() ? this.styleGen.getParaBreakBeforeStyleName() : this.styleGen.getTextStyleName((ContainerProperties)properties));
        }
        this.internalStartParagraph(containerIsList, styleName);
    }

    private void internalStartParagraph(boolean containerIsList, String styleName) throws IOException {
        this.closeHeader = false;
        if (styleName == null) {
            super.write("<text:p>");
        } else {
            super.write("<text:p text:style-name=\"");
            super.write(styleName);
            super.write("\">");
        }
        this.paragraphWasInserted = true;
        this.paragraphsStack.push(containerIsList);
        this.spanStack.push(0);
    }

    private void internalEndParagraph() throws IOException {
        if (!this.paragraphsStack.isEmpty()) {
            this.internalEndSpan();
            super.write("</text:p>");
            this.paragraphsStack.pop();
        }
    }

    public void startHeading(int level, HeaderProperties properties) throws IOException {
        this.endParagraphIfNeeded();
        super.setTextLocation(IDocumentHandler.TextLocation.End);
        super.write("<text:h text:style-name=\"" + this.styleGen.getHeaderStyleName(level) + "\" text:outline-level=\"" + level + "\">");
        this.insideHeader = true;
        this.closeHeader = false;
    }

    public void endHeading(int level) throws IOException {
        super.write("</text:h>");
        this.insideHeader = false;
        this.closeHeader = true;
    }

    protected void doStartOrderedList(ListProperties properties) throws IOException {
        this.internalStartList(this.styleGen.getOLStyleName());
    }

    protected void doEndOrderedList() throws IOException {
        this.internalEndList();
    }

    protected void doStartUnorderedList(ListProperties properties) throws IOException {
        this.internalStartList(this.styleGen.getULStyleName());
    }

    protected void doEndUnorderedList() throws IOException {
        this.internalEndList();
    }

    protected void internalStartList(String style) throws IOException {
        this.closeHeader = false;
        super.setTextLocation(IDocumentHandler.TextLocation.End);
        if (this.listDepth == 0) {
            this.endParagraphIfNeeded();
            this.lastItemAlreadyClosed.add(this.listDepth, false);
        } else {
            this.endParagraph();
            this.lastItemAlreadyClosed.add(this.listDepth, true);
        }
        if (style != null) {
            super.write("<text:list text:style-name=\"" + style + "\">");
            this.itemStyle = style;
        } else {
            super.write("<text:list>");
        }
        ++this.listDepth;
    }

    protected void internalEndList() throws IOException {
        super.write("</text:list>");
        --this.listDepth;
        if (this.listDepth == 0) {
            // empty if block
        }
    }

    public void startListItem(ListItemProperties properties) throws IOException {
        if (this.itemStyle != null) {
            super.write("<text:list-item text:style-name=\"" + this.itemStyle + "\">");
            this.internalStartParagraph(true, this.itemStyle + this.styleGen.getListItemParagraphStyleNameSuffix());
        } else {
            super.write("<text:list-item>");
            this.internalStartParagraph(true, (String)null);
        }
    }

    public void endListItem() throws IOException {
        if (this.lastItemAlreadyClosed.size() > this.listDepth && this.lastItemAlreadyClosed.get(this.listDepth).booleanValue()) {
            this.lastItemAlreadyClosed.add(this.listDepth, false);
        }
        this.endParagraphIfNeeded();
        super.write("</text:list-item>");
    }

    public void startSpan(SpanProperties properties) throws IOException {
        this.internalStartSpan(this.styleGen.getTextStyleName((ContainerProperties)properties), true);
    }

    public void endSpan() throws IOException {
        this.internalEndSpan();
    }

    public void handleReference(String ref, String label) throws IOException {
        super.write("<text:a xlink:type=\"simple\" xlink:href=\"");
        super.write(ref);
        super.write("\">");
        super.write(label);
        super.write("</text:a>");
    }

    public void handleImage(String ref, String label) throws IOException {
    }

    public void handleLineBreak() throws IOException {
        super.write("<text:line-break />");
    }

    protected void doStartTable(TableProperties properties) throws IOException {
        this.endParagraphIfNeeded();
        this.pushTempWriter();
    }

    public void doEndTable(TableProperties properties) throws IOException {
        super.setTextLocation(IDocumentHandler.TextLocation.End);
        StringBuilder startTable = new StringBuilder("<table:table>");
        startTable.append("<table:table-column ");
        int count = properties.getColumnCount();
        startTable.append("table:number-columns-repeated=\"");
        startTable.append(count);
        startTable.append("\" >");
        startTable.append("</table:table-column>");
        this.popTempWriter(startTable.toString());
        super.write("</table:table>");
    }

    protected void doStartTableRow(TableRowProperties properties) throws IOException {
        super.write("<table:table-row>");
    }

    protected void doEndTableRow() throws IOException {
        super.write("</table:table-row>");
    }

    protected void doStartTableCell(TableCellProperties properties) throws IOException {
        super.write("<table:table-cell>");
        this.internalStartParagraph(false, (String)null);
    }

    public void doEndTableCell() throws IOException {
        this.endParagraph();
        super.write("</table:table-cell>");
    }
}

