/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.configuration;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.dataformat.yaml.snakeyaml.error.Mark;
import com.google.common.collect.ImmutableSet;
import io.dropwizard.configuration.ConfigurationException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class ConfigurationParsingException
extends ConfigurationException {
    static Builder builder(String brief) {
        return new Builder(brief);
    }

    private ConfigurationParsingException(String path, String msg) {
        super(path, (Collection<String>)ImmutableSet.of((Object)msg));
    }

    private ConfigurationParsingException(String path, String msg, Throwable cause) {
        super(path, (Collection<String>)ImmutableSet.of((Object)msg), cause);
    }

    static class Builder {
        private static final int MAX_SUGGESTIONS = 5;
        private String summary;
        private String detail = "";
        private List<JsonMappingException.Reference> fieldPath = Collections.emptyList();
        private int line = -1;
        private int column = -1;
        private Exception cause = null;
        private List<String> suggestions = new ArrayList<String>();
        private String suggestionBase = null;
        private boolean suggestionsSorted = false;

        Builder(String summary) {
            this.summary = summary;
        }

        public String getSummary() {
            return this.summary.trim();
        }

        public String getDetail() {
            return this.detail.trim();
        }

        public boolean hasDetail() {
            return this.detail != null && !this.detail.isEmpty();
        }

        public List<JsonMappingException.Reference> getFieldPath() {
            return this.fieldPath;
        }

        public boolean hasFieldPath() {
            return this.fieldPath != null && !this.fieldPath.isEmpty();
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }

        public boolean hasLocation() {
            return this.line > -1 && this.column > -1;
        }

        public List<String> getSuggestions() {
            if (this.suggestionsSorted || !this.hasSuggestionBase()) {
                return this.suggestions;
            }
            Collections.sort(this.suggestions, new LevenshteinComparator(this.getSuggestionBase()));
            this.suggestionsSorted = true;
            return this.suggestions;
        }

        public boolean hasSuggestions() {
            return this.suggestions != null && !this.suggestions.isEmpty();
        }

        public String getSuggestionBase() {
            return this.suggestionBase;
        }

        public boolean hasSuggestionBase() {
            return this.suggestionBase != null && !this.suggestionBase.isEmpty();
        }

        public Exception getCause() {
            return this.cause;
        }

        public boolean hasCause() {
            return this.cause != null;
        }

        Builder setCause(Exception cause) {
            this.cause = cause;
            return this;
        }

        Builder setDetail(String detail) {
            this.detail = detail;
            return this;
        }

        Builder setFieldPath(List<JsonMappingException.Reference> fieldPath) {
            this.fieldPath = fieldPath;
            return this;
        }

        Builder setLocation(JsonLocation location) {
            return location == null ? this : this.setLocation(location.getLineNr(), location.getColumnNr());
        }

        Builder setLocation(Mark mark) {
            return mark == null ? this : this.setLocation(mark.getLine(), mark.getColumn());
        }

        Builder setLocation(int line, int column) {
            this.line = line;
            this.column = column;
            return this;
        }

        Builder addSuggestion(String suggestion) {
            this.suggestionsSorted = false;
            this.suggestions.add(suggestion);
            return this;
        }

        Builder addSuggestions(Collection<String> suggestions) {
            this.suggestionsSorted = false;
            this.suggestions.addAll(suggestions);
            return this;
        }

        Builder setSuggestionBase(String base) {
            this.suggestionBase = base;
            this.suggestionsSorted = false;
            return this;
        }

        ConfigurationParsingException build(String path) {
            StringBuilder sb = new StringBuilder(this.getSummary());
            if (this.hasFieldPath()) {
                sb.append(" at: ").append(this.buildPath(this.getFieldPath()));
            } else if (this.hasLocation()) {
                sb.append(" at line: ").append(this.getLine() + 1).append(", column: ").append(this.getColumn() + 1);
            }
            if (this.hasDetail()) {
                sb.append("; ").append(this.getDetail());
            }
            if (this.hasSuggestions()) {
                int i;
                List<String> suggestions = this.getSuggestions();
                sb.append(ConfigurationException.NEWLINE).append("    Did you mean?:").append(ConfigurationException.NEWLINE);
                Iterator<String> it = suggestions.iterator();
                for (i = 0; it.hasNext() && i < 5; ++i) {
                    sb.append("      - ").append(it.next());
                    if (!it.hasNext()) continue;
                    sb.append(ConfigurationException.NEWLINE);
                }
                int total = suggestions.size();
                if (i < total) {
                    sb.append("        [").append(total - i).append(" more]");
                }
            }
            return this.hasCause() ? new ConfigurationParsingException(path, sb.toString(), this.getCause()) : new ConfigurationParsingException(path, sb.toString());
        }

        private String buildPath(Iterable<JsonMappingException.Reference> path) {
            StringBuilder sb = new StringBuilder();
            if (path != null) {
                Iterator<JsonMappingException.Reference> it = path.iterator();
                while (it.hasNext()) {
                    JsonMappingException.Reference reference = it.next();
                    String name = reference.getFieldName();
                    if (name == null) {
                        sb.append('[').append(reference.getIndex()).append(']');
                    } else {
                        sb.append(name);
                    }
                    if (!it.hasNext()) continue;
                    sb.append('.');
                }
            }
            return sb.toString();
        }

        private static class LevenshteinComparator
        implements Comparator<String>,
        Serializable {
            private String base;

            public LevenshteinComparator(String base) {
                this.base = base;
            }

            @Override
            public int compare(String a, String b) {
                if (a.equals(b)) {
                    return 0;
                }
                if (a.equals(this.base)) {
                    return -1;
                }
                if (b.equals(this.base)) {
                    return 1;
                }
                return StringUtils.getLevenshteinDistance((String)a, (String)this.base) < StringUtils.getLevenshteinDistance((String)b, (String)this.base) ? -1 : 1;
            }

            private void writeObject(ObjectOutputStream stream) throws IOException {
                stream.defaultWriteObject();
            }

            private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
                stream.defaultReadObject();
            }
        }
    }
}

