/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jdbi.args;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDate;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.Argument;

public class LocalDateArgument
implements Argument {
    private final LocalDate value;

    public LocalDateArgument(LocalDate value) {
        this.value = value;
    }

    public void apply(int position, PreparedStatement statement, StatementContext ctx) throws SQLException {
        if (this.value != null) {
            statement.setTimestamp(position, Timestamp.valueOf(this.value.atStartOfDay()));
        } else {
            statement.setNull(position, 93);
        }
    }
}

