/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jdbi.args;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Optional;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.Argument;
import org.skife.jdbi.v2.tweak.ArgumentFactory;

public class OptionalArgumentFactory
implements ArgumentFactory<Optional<Object>> {
    private final String jdbcDriver;

    public OptionalArgumentFactory(String jdbcDriver) {
        this.jdbcDriver = jdbcDriver;
    }

    public boolean accepts(Class<?> expectedType, Object value, StatementContext ctx) {
        return value instanceof Optional;
    }

    public Argument build(Class<?> expectedType, Optional<Object> value, StatementContext ctx) {
        if ("com.microsoft.sqlserver.jdbc.SQLServerDriver".equals(this.jdbcDriver)) {
            return new MsSqlOptionalArgument(value);
        }
        if ("oracle.jdbc.OracleDriver".equals(this.jdbcDriver)) {
            return new DefaultOptionalArgument(value, 0);
        }
        return new DefaultOptionalArgument(value);
    }

    private static class MsSqlOptionalArgument
    implements Argument {
        private final Optional<?> value;

        private MsSqlOptionalArgument(Optional<?> value) {
            this.value = value;
        }

        public void apply(int position, PreparedStatement statement, StatementContext ctx) throws SQLException {
            statement.setObject(position, this.value.orElse(null));
        }
    }

    private static class DefaultOptionalArgument
    implements Argument {
        private final Optional<?> value;
        private final int nullType;

        private DefaultOptionalArgument(Optional<?> value, int nullType) {
            this.value = value;
            this.nullType = nullType;
        }

        private DefaultOptionalArgument(Optional<?> value) {
            this(value, 1111);
        }

        public void apply(int position, PreparedStatement statement, StatementContext ctx) throws SQLException {
            if (this.value.isPresent()) {
                statement.setObject(position, this.value.get());
            } else {
                statement.setNull(position, this.nullType);
            }
        }
    }
}

