/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.internal.bouncycastle.pqc.jcajce.provider.ntruprime;

import io.gatling.recorder.internal.bouncycastle.crypto.AsymmetricCipherKeyPair;
import io.gatling.recorder.internal.bouncycastle.crypto.CryptoServicesRegistrar;
import io.gatling.recorder.internal.bouncycastle.pqc.crypto.ntruprime.NTRULPRimeKeyGenerationParameters;
import io.gatling.recorder.internal.bouncycastle.pqc.crypto.ntruprime.NTRULPRimeKeyPairGenerator;
import io.gatling.recorder.internal.bouncycastle.pqc.crypto.ntruprime.NTRULPRimeParameters;
import io.gatling.recorder.internal.bouncycastle.pqc.crypto.ntruprime.NTRULPRimePrivateKeyParameters;
import io.gatling.recorder.internal.bouncycastle.pqc.crypto.ntruprime.NTRULPRimePublicKeyParameters;
import io.gatling.recorder.internal.bouncycastle.pqc.jcajce.provider.ntruprime.BCNTRULPRimePrivateKey;
import io.gatling.recorder.internal.bouncycastle.pqc.jcajce.provider.ntruprime.BCNTRULPRimePublicKey;
import io.gatling.recorder.internal.bouncycastle.pqc.jcajce.provider.util.SpecUtil;
import io.gatling.recorder.internal.bouncycastle.pqc.jcajce.spec.NTRULPRimeParameterSpec;
import io.gatling.recorder.internal.bouncycastle.util.Strings;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.Map;

public class NTRULPRimeKeyPairGeneratorSpi
extends KeyPairGenerator {
    private static Map parameters = new HashMap();
    NTRULPRimeKeyGenerationParameters param;
    NTRULPRimeKeyPairGenerator engine = new NTRULPRimeKeyPairGenerator();
    SecureRandom random = CryptoServicesRegistrar.getSecureRandom();
    boolean initialised = false;

    public NTRULPRimeKeyPairGeneratorSpi() {
        super("NTRULPRime");
    }

    @Override
    public void initialize(int n, SecureRandom secureRandom) {
        throw new IllegalArgumentException("use AlgorithmParameterSpec");
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        String string = NTRULPRimeKeyPairGeneratorSpi.getNameFromParams(algorithmParameterSpec);
        if (string == null) {
            throw new InvalidAlgorithmParameterException("invalid ParameterSpec: " + algorithmParameterSpec);
        }
        this.param = new NTRULPRimeKeyGenerationParameters(secureRandom, (NTRULPRimeParameters)parameters.get(string));
        this.engine.init(this.param);
        this.initialised = true;
    }

    private static String getNameFromParams(AlgorithmParameterSpec algorithmParameterSpec) {
        if (algorithmParameterSpec instanceof NTRULPRimeParameterSpec) {
            NTRULPRimeParameterSpec nTRULPRimeParameterSpec = (NTRULPRimeParameterSpec)algorithmParameterSpec;
            return nTRULPRimeParameterSpec.getName();
        }
        return Strings.toLowerCase(SpecUtil.getNameFrom(algorithmParameterSpec));
    }

    @Override
    public KeyPair generateKeyPair() {
        if (!this.initialised) {
            this.param = new NTRULPRimeKeyGenerationParameters(this.random, NTRULPRimeParameters.ntrulpr953);
            this.engine.init(this.param);
            this.initialised = true;
        }
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.engine.generateKeyPair();
        NTRULPRimePublicKeyParameters nTRULPRimePublicKeyParameters = (NTRULPRimePublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        NTRULPRimePrivateKeyParameters nTRULPRimePrivateKeyParameters = (NTRULPRimePrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        return new KeyPair(new BCNTRULPRimePublicKey(nTRULPRimePublicKeyParameters), new BCNTRULPRimePrivateKey(nTRULPRimePrivateKeyParameters));
    }

    static {
        parameters.put(NTRULPRimeParameterSpec.ntrulpr653.getName(), NTRULPRimeParameters.ntrulpr653);
        parameters.put(NTRULPRimeParameterSpec.ntrulpr761.getName(), NTRULPRimeParameters.ntrulpr761);
        parameters.put(NTRULPRimeParameterSpec.ntrulpr857.getName(), NTRULPRimeParameters.ntrulpr857);
        parameters.put(NTRULPRimeParameterSpec.ntrulpr953.getName(), NTRULPRimeParameters.ntrulpr953);
        parameters.put(NTRULPRimeParameterSpec.ntrulpr1013.getName(), NTRULPRimeParameters.ntrulpr1013);
        parameters.put(NTRULPRimeParameterSpec.ntrulpr1277.getName(), NTRULPRimeParameters.ntrulpr1277);
    }
}

