/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.internal.bouncycastle.pqc.jcajce.provider.sike;

import io.gatling.recorder.internal.bouncycastle.crypto.SecretWithEncapsulation;
import io.gatling.recorder.internal.bouncycastle.jcajce.SecretKeyWithEncapsulation;
import io.gatling.recorder.internal.bouncycastle.jcajce.spec.KEMExtractSpec;
import io.gatling.recorder.internal.bouncycastle.jcajce.spec.KEMGenerateSpec;
import io.gatling.recorder.internal.bouncycastle.pqc.crypto.sike.SIKEKEMExtractor;
import io.gatling.recorder.internal.bouncycastle.pqc.crypto.sike.SIKEKEMGenerator;
import io.gatling.recorder.internal.bouncycastle.pqc.jcajce.provider.sike.BCSIKEPrivateKey;
import io.gatling.recorder.internal.bouncycastle.pqc.jcajce.provider.sike.BCSIKEPublicKey;
import io.gatling.recorder.internal.bouncycastle.util.Arrays;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.DestroyFailedException;

public class SIKEKeyGeneratorSpi
extends KeyGeneratorSpi {
    private KEMGenerateSpec genSpec;
    private SecureRandom random;
    private KEMExtractSpec extSpec;

    @Override
    protected void engineInit(SecureRandom secureRandom) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        this.random = secureRandom;
        if (algorithmParameterSpec instanceof KEMGenerateSpec) {
            this.genSpec = (KEMGenerateSpec)algorithmParameterSpec;
            this.extSpec = null;
        } else if (algorithmParameterSpec instanceof KEMExtractSpec) {
            this.genSpec = null;
            this.extSpec = (KEMExtractSpec)algorithmParameterSpec;
        } else {
            throw new InvalidAlgorithmParameterException("unknown spec");
        }
    }

    @Override
    protected void engineInit(int n, SecureRandom secureRandom) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    protected SecretKey engineGenerateKey() {
        if (this.genSpec != null) {
            BCSIKEPublicKey bCSIKEPublicKey = (BCSIKEPublicKey)this.genSpec.getPublicKey();
            SIKEKEMGenerator sIKEKEMGenerator = new SIKEKEMGenerator(this.random);
            SecretWithEncapsulation secretWithEncapsulation = sIKEKEMGenerator.generateEncapsulated(bCSIKEPublicKey.getKeyParams());
            SecretKeyWithEncapsulation secretKeyWithEncapsulation = new SecretKeyWithEncapsulation(new SecretKeySpec(secretWithEncapsulation.getSecret(), this.genSpec.getKeyAlgorithmName()), secretWithEncapsulation.getEncapsulation());
            try {
                secretWithEncapsulation.destroy();
            }
            catch (DestroyFailedException destroyFailedException) {
                throw new IllegalStateException("key cleanup failed");
            }
            return secretKeyWithEncapsulation;
        }
        BCSIKEPrivateKey bCSIKEPrivateKey = (BCSIKEPrivateKey)this.extSpec.getPrivateKey();
        SIKEKEMExtractor sIKEKEMExtractor = new SIKEKEMExtractor(bCSIKEPrivateKey.getKeyParams());
        byte[] byArray = this.extSpec.getEncapsulation();
        byte[] byArray2 = sIKEKEMExtractor.extractSecret(byArray);
        SecretKeyWithEncapsulation secretKeyWithEncapsulation = new SecretKeyWithEncapsulation(new SecretKeySpec(byArray2, this.extSpec.getKeyAlgorithmName()), byArray);
        Arrays.clear(byArray2);
        return secretKeyWithEncapsulation;
    }
}

