/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.http;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props$;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.util.Clock;
import io.gatling.recorder.http.OutgoingProxy;
import io.gatling.recorder.http.TrafficLogger;
import io.gatling.recorder.http.flows.MitmActor;
import io.gatling.recorder.http.flows.MitmActor$;
import io.gatling.recorder.http.flows.MitmMessage;
import io.gatling.recorder.http.flows.MitmMessage$ServerChannelInactive$;
import io.gatling.recorder.http.flows.Remote;
import io.gatling.recorder.http.flows.Remote$;
import io.gatling.recorder.http.ssl.SslServerContext;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpMethod;
import java.io.Serializable;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005uc\u0001\u0002\u000b\u0016\u0001yA\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\tu\u0001\u0011\t\u0011)A\u0005w!AQ\t\u0001B\u0001B\u0003%a\t\u0003\u0005M\u0001\t\u0005\t\u0015!\u0003N\u0011!\u0019\u0006A!A!\u0002\u0013!\u0006\u0002C,\u0001\u0005\u0003\u0005\u000b\u0011\u0002-\t\u0011\u0011\u0004!\u0011!Q\u0001\n\u0015DQ!\u001c\u0001\u0005\u00029Dqa\u001e\u0001A\u0002\u0013%\u0001\u0010C\u0004}\u0001\u0001\u0007I\u0011B?\t\u000f\u0005\u001d\u0001\u0001)Q\u0005s\"Y\u0011\u0011\u0003\u0001A\u0002\u0003\u0007I\u0011BA\n\u0011-\t\t\u0003\u0001a\u0001\u0002\u0004%I!a\t\t\u0017\u0005\u001d\u0002\u00011A\u0001B\u0003&\u0011Q\u0003\u0005\f\u0003W\u0001\u0001\u0019!a\u0001\n\u0013\ti\u0003C\u0006\u00026\u0001\u0001\r\u00111A\u0005\n\u0005]\u0002bCA\u001e\u0001\u0001\u0007\t\u0011)Q\u0005\u0003_Aq!a\u0010\u0001\t\u0003\n\t\u0005C\u0004\u0002X\u0001!\t%!\u0017\u0003\u001bM+'O^3s\u0011\u0006tG\r\\3s\u0015\t1r#\u0001\u0003iiR\u0004(B\u0001\r\u001a\u0003!\u0011XmY8sI\u0016\u0014(B\u0001\u000e\u001c\u0003\u001d9\u0017\r\u001e7j]\u001eT\u0011\u0001H\u0001\u0003S>\u001c\u0001aE\u0002\u0001?\u001d\u0002\"\u0001I\u0013\u000e\u0003\u0005R!AI\u0012\u0002\u000f\rD\u0017M\u001c8fY*\u0011AeG\u0001\u0006]\u0016$H/_\u0005\u0003M\u0005\u0012Ad\u00115b]:,G.\u00138c_VtG\rS1oI2,'/\u00113baR,'\u000f\u0005\u0002)_5\t\u0011F\u0003\u0002+W\u0005a1oY1mC2|wmZ5oO*\u0011A&L\u0001\tif\u0004Xm]1gK*\ta&A\u0002d_6L!\u0001M\u0015\u0003\u001bM#(/[2u\u0019><w-\u001b8h\u0003\u0019\u0019\u0018p\u001d;f[B\u00111\u0007O\u0007\u0002i)\u0011QGN\u0001\u0006C\u000e$xN\u001d\u0006\u0002o\u0005!\u0011m[6b\u0013\tIDGA\u0006BGR|'oU=ti\u0016l\u0017!D8vi\u001e|\u0017N\\4Qe>D\u0018\u0010E\u0002=\u007f\u0005k\u0011!\u0010\u0006\u0002}\u0005)1oY1mC&\u0011\u0001)\u0010\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\t\u001bU\"A\u000b\n\u0005\u0011+\"!D(vi\u001e|\u0017N\\4Qe>D\u00180A\bdY&,g\u000e\u001e\"p_R\u001cHO]1q!\t9%*D\u0001I\u0015\tI5%A\u0005c_>$8\u000f\u001e:ba&\u00111\n\u0013\u0002\n\u0005>|Go\u001d;sCB\f\u0001c]:m'\u0016\u0014h/\u001a:D_:$X\r\u001f;\u0011\u00059\u000bV\"A(\u000b\u0005A+\u0012aA:tY&\u0011!k\u0014\u0002\u0011'Nd7+\u001a:wKJ\u001cuN\u001c;fqR\fQ\u0002\u001e:bM\u001aL7\rT8hO\u0016\u0014\bC\u0001\"V\u0013\t1VCA\u0007Ue\u00064g-[2M_\u001e<WM]\u0001\u0017QR$\bo\u00117jK:$8i\u001c3fG\u001a\u000b7\r^8ssB\u0019A(W.\n\u0005ik$!\u0003$v]\u000e$\u0018n\u001c81!\ta&-D\u0001^\u0015\t1bL\u0003\u0002`A\u0006)1m\u001c3fG*\u0011\u0011mI\u0001\bQ\u0006tG\r\\3s\u0013\t\u0019WLA\bIiR\u00048\t\\5f]R\u001cu\u000eZ3d\u0003\u0015\u0019Gn\\2l!\t17.D\u0001h\u0015\tA\u0017.\u0001\u0003vi&d'B\u00016\u001a\u0003\u001d\u0019w.\\7p]NL!\u0001\\4\u0003\u000b\rcwnY6\u0002\rqJg.\u001b;?)!y\u0007/\u001d:tiV4\bC\u0001\"\u0001\u0011\u0015\t\u0004\u00021\u00013\u0011\u0015Q\u0004\u00021\u0001<\u0011\u0015)\u0005\u00021\u0001G\u0011\u0015a\u0005\u00021\u0001N\u0011\u0015\u0019\u0006\u00021\u0001U\u0011\u00159\u0006\u00021\u0001Y\u0011\u0015!\u0007\u00021\u0001f\u0003\u0015AG\u000f\u001e9t+\u0005I\bC\u0001\u001f{\u0013\tYXHA\u0004C_>dW-\u00198\u0002\u0013!$H\u000f]:`I\u0015\fHc\u0001@\u0002\u0004A\u0011Ah`\u0005\u0004\u0003\u0003i$\u0001B+oSRD\u0001\"!\u0002\u000b\u0003\u0003\u0005\r!_\u0001\u0004q\u0012\n\u0014A\u00025uiB\u001c\b\u0005K\u0002\f\u0003\u0017\u00012\u0001PA\u0007\u0013\r\ty!\u0010\u0002\tm>d\u0017\r^5mK\u00061!/Z7pi\u0016,\"!!\u0006\u0011\t\u0005]\u0011QD\u0007\u0003\u00033Q1!a\u0007\u0016\u0003\u00151Gn\\<t\u0013\u0011\ty\"!\u0007\u0003\rI+Wn\u001c;f\u0003)\u0011X-\\8uK~#S-\u001d\u000b\u0004}\u0006\u0015\u0002\"CA\u0003\u001b\u0005\u0005\t\u0019AA\u000b\u0003\u001d\u0011X-\\8uK\u0002B3ADA\u0006\u0003%i\u0017\u000e^7BGR|'/\u0006\u0002\u00020A\u00191'!\r\n\u0007\u0005MBG\u0001\u0005BGR|'OU3g\u00035i\u0017\u000e^7BGR|'o\u0018\u0013fcR\u0019a0!\u000f\t\u0013\u0005\u0015\u0001#!AA\u0002\u0005=\u0012AC7ji6\f5\r^8sA!\u001a\u0011#a\u0003\u0002\u0017\rD\u0017M\u001c8fYJ+\u0017\r\u001a\u000b\u0006}\u0006\r\u0013Q\n\u0005\b\u0003\u000b\u0012\u0002\u0019AA$\u0003\r\u0019G\u000f\u001f\t\u0004A\u0005%\u0013bAA&C\t)2\t[1o]\u0016d\u0007*\u00198eY\u0016\u00148i\u001c8uKb$\bbBA(%\u0001\u0007\u0011\u0011K\u0001\u0004[N<\u0007c\u0001\u001f\u0002T%\u0019\u0011QK\u001f\u0003\r\u0005s\u0017PU3g\u0003=\u0019\u0007.\u00198oK2Le.Y2uSZ,Gc\u0001@\u0002\\!9\u0011QI\nA\u0002\u0005\u001d\u0003")
public class ServerHandler
extends ChannelInboundHandlerAdapter
implements StrictLogging {
    private final ActorSystem system;
    private final Option<OutgoingProxy> outgoingProxy;
    private final Bootstrap clientBootstrap;
    private final SslServerContext sslServerContext;
    private final TrafficLogger trafficLogger;
    private final Function0<HttpClientCodec> httpClientCodecFactory;
    private final Clock clock;
    private volatile boolean https;
    private volatile Remote remote;
    private volatile ActorRef mitmActor;
    private Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private boolean https() {
        return this.https;
    }

    private void https_$eq(boolean x$1) {
        this.https = x$1;
    }

    private Remote remote() {
        return this.remote;
    }

    private void remote_$eq(Remote x$1) {
        this.remote = x$1;
    }

    private ActorRef mitmActor() {
        return this.mitmActor;
    }

    private void mitmActor_$eq(ActorRef x$1) {
        this.mitmActor = x$1;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        long sendTimestamp = this.clock.nowMillis();
        Object object = msg;
        if (object instanceof FullHttpRequest) {
            FullHttpRequest fullHttpRequest = (FullHttpRequest)object;
            if (this.mitmActor() == null) {
                HttpMethod httpMethod = fullHttpRequest.method();
                HttpMethod httpMethod2 = HttpMethod.CONNECT;
                if (!(httpMethod != null ? !httpMethod.equals(httpMethod2) : httpMethod2 != null)) {
                    Predef$.MODULE$.assert(!fullHttpRequest.uri().startsWith("http"), (Function0 & Serializable)() -> new StringBuilder(60).append("Invalid HTTPS Proxy request: URI '").append(fullHttpRequest.uri()).append("' shouldn't have a scheme.").toString());
                    this.https_$eq(true);
                    this.remote_$eq(Remote$.MODULE$.fromAbsoluteUri(new StringBuilder(3).append(this.https()).append("://").append(fullHttpRequest.uri()).toString()));
                } else {
                    Predef$.MODULE$.assert(fullHttpRequest.uri().startsWith("http://"), (Function0 & Serializable)() -> new StringBuilder(139).append("Invalid HTTP Proxy request: URI '").append(fullHttpRequest.uri()).append("' should be absolute with http scheme. You're probably confusing Recorder proxy url and target system url.").toString());
                    this.https_$eq(false);
                    this.remote_$eq(Remote$.MODULE$.fromAbsoluteUri(fullHttpRequest.uri()));
                }
                this.mitmActor_$eq(this.system.actorOf(Props$.MODULE$.apply((Function0 & Serializable)() -> MitmActor$.MODULE$.apply($this.outgoingProxy, $this.clientBootstrap, $this.sslServerContext, $this.trafficLogger, $this.httpClientCodecFactory, ctx.channel(), this.https(), $this.clock), ClassTag$.MODULE$.apply(MitmActor.class))));
            }
            this.trafficLogger.logRequest(ctx.channel().id(), fullHttpRequest, this.remote(), this.https(), sendTimestamp);
            ActorRef qual$1 = this.mitmActor();
            MitmMessage.RequestReceived x$1 = new MitmMessage.RequestReceived(fullHttpRequest);
            ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
            qual$1.$bang((Object)x$1, x$2);
            return;
        }
        if (this.logger().underlying().isWarnEnabled()) {
            this.logger().underlying().warn("Received unknown message: {}", object);
            return;
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        if (this.mitmActor() != null) {
            this.trafficLogger.clear(ctx.channel().id());
            ActorRef qual$1 = this.mitmActor();
            MitmMessage$ServerChannelInactive$ x$1 = MitmMessage$ServerChannelInactive$.MODULE$;
            ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
            qual$1.$bang((Object)x$1, x$2);
            return;
        }
    }

    public ServerHandler(ActorSystem system, Option<OutgoingProxy> outgoingProxy, Bootstrap clientBootstrap, SslServerContext sslServerContext, TrafficLogger trafficLogger, Function0<HttpClientCodec> httpClientCodecFactory, Clock clock) {
        this.system = system;
        this.outgoingProxy = outgoingProxy;
        this.clientBootstrap = clientBootstrap;
        this.sslServerContext = sslServerContext;
        this.trafficLogger = trafficLogger;
        this.httpClientCodecFactory = httpClientCodecFactory;
        this.clock = clock;
        StrictLogging.$init$((StrictLogging)this);
        this.https = false;
        Statics.releaseFence();
    }
}

