/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf.deployment;

import io.quarkiverse.cxf.deployment.CxfBuildTimeConfig;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.paths.PathFilter;
import jakarta.jws.WebService;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.spi.GeneratedClassClassLoaderCapture;
import org.apache.cxf.tools.java2ws.JavaToWS;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.logging.Logger;

class Java2WsdlProcessor {
    private static final Logger log = Logger.getLogger(Java2WsdlProcessor.class);

    Java2WsdlProcessor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Consume(value=GeneratedBeanBuildItem.class)
    @BuildStep
    void java2wsdl(CxfBuildTimeConfig cxfBuildTimeConfig, CombinedIndexBuildItem combinedIndex, OutputTargetBuildItem outputTargetBuildItem, BuildProducer<GeneratedResourceBuildItem> dummy) {
        String targetDir = outputTargetBuildItem.getOutputDirectory().toString();
        String classesDir = outputTargetBuildItem.getOutputDirectory().resolve("classes").toString();
        IndexView index = combinedIndex.getIndex();
        if (!cxfBuildTimeConfig.java2ws().enabled()) {
            log.info((Object)("Skipping " + this.getClass() + " invocation on user's request"));
            return;
        }
        Set services = index.getAnnotations(DotName.createSimple((String)WebService.class.getName())).stream().map(AnnotationInstance::target).filter(annotationTarget -> annotationTarget.kind() == AnnotationTarget.Kind.CLASS).map(AnnotationTarget::asClass).map(classInfo -> classInfo.name()).collect(Collectors.toCollection(TreeSet::new));
        Bus oldBus = BusFactory.getThreadDefaultBus();
        Bus java2wsdlBus = BusFactory.newInstance().createBus();
        java2wsdlBus.setExtension(null, GeneratedClassClassLoaderCapture.class);
        BusFactory.setThreadDefaultBus((Bus)java2wsdlBus);
        try {
            LinkedHashMap<String, String> processedClasses = new LinkedHashMap<String, String>();
            Java2WsdlProcessor.java2wsdl(services, cxfBuildTimeConfig.java2ws().rootParameterSet(), "quarkus.cxf.java2ws", targetDir, classesDir, processedClasses);
            for (Map.Entry<String, CxfBuildTimeConfig.Java2WsParameterSet> en : cxfBuildTimeConfig.java2ws().namedParameterSets().entrySet()) {
                Java2WsdlProcessor.java2wsdl(services, en.getValue(), "quarkus.cxf.java2ws." + en.getKey(), targetDir, classesDir, processedClasses);
            }
            log.infof("java2ws processed %d classes", (Object)processedClasses.size());
        }
        finally {
            BusFactory.setThreadDefaultBus((Bus)oldBus);
        }
    }

    static void java2wsdl(Set<DotName> serviceClasses, CxfBuildTimeConfig.Java2WsParameterSet params, String prefix, String targetDir, String classesDir, Map<String, String> processedClasses) {
        params.validate(prefix);
        if (params.includes().isEmpty()) {
            return;
        }
        String selectors = "    " + prefix + ".includes = " + params.includes().get() + (String)(params.excludes().isPresent() ? "\n    " + prefix + ".excludes = " + params.excludes().get() : "");
        PathFilter pathFilter = new PathFilter(Java2WsdlProcessor.toSlashNames(params.includes()), Java2WsdlProcessor.toSlashNames(params.excludes()));
        for (DotName serviceClass : serviceClasses) {
            if (!pathFilter.isVisible(serviceClass.toString('/'))) continue;
            String oldSelectors = processedClasses.get(serviceClass.toString());
            if (oldSelectors != null) {
                throw new IllegalStateException("Service class " + serviceClass + " was already selected by\n\n" + oldSelectors + "\n\nand therefore it cannot once again be selected by\n\n" + selectors + "\n\nPlease make sure that the individual include/exclude sets are mutually exclusive.");
            }
            processedClasses.put(serviceClass.toString(), selectors);
            Java2WsdlParams java2WsdlParams = new Java2WsdlParams(serviceClass.toString(), params.additionalParams().orElse(Collections.emptyList()), Java2WsdlProcessor.generateWsdlName(params.wsdlNameTemplate(), serviceClass, targetDir, classesDir));
            if (log.isInfoEnabled()) {
                log.info((Object)java2WsdlParams.appendLog(new StringBuilder("Running java2ws")).toString());
            }
            try {
                new JavaToWS(java2WsdlParams.toParameterArray()).run();
            }
            catch (Exception e) {
                throw new RuntimeException(java2WsdlParams.appendLog(new StringBuilder("Could not run java2ws")).toString(), e);
            }
        }
    }

    static List<String> toSlashNames(Optional<List<String>> includes) {
        if (includes.isPresent()) {
            return includes.get().stream().map(incl -> incl.replace('.', '/')).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    static String generateWsdlName(String template, DotName serviceClass, String targetDir, String classesDir) {
        return template.replace("%SIMPLE_CLASS_NAME%", serviceClass.withoutPackagePrefix()).replace("%FULLY_QUALIFIED_CLASS_NAME%", serviceClass.toString().replace('.', '_')).replace("%TARGET_DIR%", targetDir).replace("%CLASSES_DIR%", classesDir);
    }

    static class Java2WsdlParams {
        private final String serviceClassName;
        private final List<String> additionalParams;
        private final String outputPath;

        Java2WsdlParams(String serviceClassName, List<String> additionalParams, String outputPath) {
            this.serviceClassName = serviceClassName;
            this.additionalParams = additionalParams;
            this.outputPath = outputPath;
        }

        StringBuilder appendLog(StringBuilder sb) {
            this.render(value -> sb.append(' ').append((String)value));
            return sb;
        }

        String[] toParameterArray() {
            String[] result = new String[this.additionalParams.size() + 4];
            AtomicInteger i = new AtomicInteger(0);
            this.render(value -> {
                result[i.getAndIncrement()] = value;
            });
            return result;
        }

        void render(Consumer<String> paramConsumer) {
            paramConsumer.accept("-wsdl");
            paramConsumer.accept("-o");
            paramConsumer.accept(this.outputPath);
            this.additionalParams.forEach(paramConsumer);
            paramConsumer.accept(this.serviceClassName);
        }
    }
}

