/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf.transport;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.net.URI;

public class VertxHttpServletRequestXForwardedFilter
extends HttpServletRequestWrapper {
    private String newProtocol;
    private String newRemoteAddr;
    private String newContextPath;
    private String newServletPath;
    private String newRequestUri;
    private StringBuffer newRequestUrl;

    VertxHttpServletRequestXForwardedFilter(HttpServletRequest request, String originalProto, String originalRemoteAddr, String originalPrefix, String originalHost, String originalPort) {
        super(request);
        this.newProtocol = originalProto;
        if (originalRemoteAddr != null) {
            this.newRemoteAddr = originalRemoteAddr.split(",")[0].trim();
        }
        this.newRequestUri = VertxHttpServletRequestXForwardedFilter.calculateNewRequestUri(request, originalPrefix);
        String outermostHost = originalHost != null ? originalHost.split(",", 2)[0].trim() : originalHost;
        this.newRequestUrl = VertxHttpServletRequestXForwardedFilter.calculateNewRequestUrl(request, originalProto, originalPrefix, outermostHost, originalPort);
        this.newContextPath = VertxHttpServletRequestXForwardedFilter.calculateNewContextPath(request, originalPrefix);
        this.newServletPath = VertxHttpServletRequestXForwardedFilter.calculateNewServletPath(request, originalPrefix);
    }

    private static String calculateNewContextPath(HttpServletRequest request, String originalPrefix) {
        if (originalPrefix != null) {
            return originalPrefix;
        }
        return request.getContextPath();
    }

    private static String calculateNewServletPath(HttpServletRequest request, String originalPrefix) {
        Object servletPath = request.getServletPath();
        if (originalPrefix != null) {
            servletPath = request.getContextPath() + (String)servletPath;
        }
        return servletPath;
    }

    private static String calculateNewRequestUri(HttpServletRequest request, String originalPrefix) {
        Object requestUri = request.getRequestURI();
        if (originalPrefix != null) {
            requestUri = originalPrefix + (String)requestUri;
        }
        return requestUri;
    }

    private static StringBuffer calculateNewRequestUrl(HttpServletRequest request, String originalProto, String originalPrefix, String originalHost, String originalPort) {
        URI uri = URI.create(request.getRequestURL().toString());
        StringBuffer sb = new StringBuffer();
        sb.append(originalProto != null ? originalProto : uri.getScheme()).append("://").append(originalHost != null ? originalHost : uri.getHost()).append((String)(originalPort != null && !"-1".equals(originalPort) ? ":" + originalPort : (uri.getPort() != -1 ? ":" + uri.getPort() : ""))).append(originalPrefix != null ? originalPrefix : "").append(uri.getRawPath());
        String query = uri.getRawQuery();
        if (query != null) {
            sb.append('?').append(query);
        }
        return sb;
    }

    public boolean isSecure() {
        if (this.newProtocol != null) {
            return "https".equals(this.newProtocol);
        }
        return super.isSecure();
    }

    public StringBuffer getRequestURL() {
        return this.newRequestUrl;
    }

    public String getRemoteAddr() {
        if (this.newRemoteAddr != null) {
            return this.newRemoteAddr;
        }
        return super.getRemoteAddr();
    }

    public String getRequestURI() {
        return this.newRequestUri;
    }

    public String getContextPath() {
        return this.newContextPath;
    }

    public String getServletPath() {
        return this.newServletPath;
    }
}

