/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf.transport.generated;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import java.util.ArrayDeque;
import java.util.Objects;

final class AppendBuffer {
    private final ByteBufAllocator allocator;
    private final int minChunkSize;
    private final int capacity;
    private ByteBuf buffer;
    private ArrayDeque<ByteBuf> otherBuffers;
    private int size;

    private AppendBuffer(ByteBufAllocator allocator, int minChunkSize, int capacity) {
        this.allocator = allocator;
        this.minChunkSize = Math.min(minChunkSize, capacity);
        this.capacity = capacity;
    }

    public static AppendBuffer eager(ByteBufAllocator allocator, int capacity) {
        return new AppendBuffer(allocator, capacity, capacity);
    }

    public static AppendBuffer exact(ByteBufAllocator allocator, int capacity) {
        return new AppendBuffer(allocator, 0, capacity);
    }

    public static AppendBuffer withMinChunks(ByteBufAllocator allocator, int minChunkSize, int capacity) {
        return new AppendBuffer(allocator, minChunkSize, capacity);
    }

    private ByteBuf lastBuffer() {
        if (this.otherBuffers == null || this.otherBuffers.isEmpty()) {
            return this.buffer;
        }
        return this.otherBuffers.peekLast();
    }

    public int append(byte[] bytes, int off, int len) {
        int availableCapacity;
        int availableOnLast;
        ByteBuf lastBuffer;
        Objects.requireNonNull(bytes);
        if (len == 0) {
            return 0;
        }
        int alreadyWritten = 0;
        if (this.minChunkSize > 0 && (lastBuffer = this.lastBuffer()) != null && (availableOnLast = lastBuffer.writableBytes()) > 0) {
            int toWrite = Math.min(len, availableOnLast);
            lastBuffer.writeBytes(bytes, off, toWrite);
            this.size += toWrite;
            if ((len -= toWrite) == 0) {
                return toWrite;
            }
            off += toWrite;
            alreadyWritten = toWrite;
        }
        if ((availableCapacity = this.capacity - this.size) == 0) {
            return alreadyWritten;
        }
        int toWrite = Math.min(len, availableCapacity);
        assert (toWrite > 0);
        int chunkCapacity = this.minChunkSize > 0 ? Math.min(Math.max(this.minChunkSize, toWrite), availableCapacity) : toWrite;
        ByteBuf tmpBuf = this.allocator.directBuffer(chunkCapacity);
        try {
            tmpBuf.writeBytes(bytes, off, toWrite);
        }
        catch (Throwable t) {
            tmpBuf.release();
            throw t;
        }
        if (this.buffer == null) {
            this.buffer = tmpBuf;
        } else {
            boolean resetOthers = false;
            try {
                if (this.otherBuffers == null) {
                    this.otherBuffers = new ArrayDeque();
                    resetOthers = true;
                }
                this.otherBuffers.add(tmpBuf);
            }
            catch (Throwable t) {
                this.rollback(alreadyWritten, tmpBuf, resetOthers);
                throw t;
            }
        }
        this.size += toWrite;
        return toWrite + alreadyWritten;
    }

    private void rollback(int alreadyWritten, ByteBuf tmpBuf, boolean resetOthers) {
        tmpBuf.release();
        if (resetOthers) {
            this.otherBuffers = null;
        }
        if (alreadyWritten > 0) {
            ByteBuf last = this.lastBuffer();
            last.writerIndex(last.writerIndex() - alreadyWritten);
            this.size -= alreadyWritten;
            assert (last.writerIndex() > 0);
        }
    }

    public ByteBuf clear() {
        ByteBuf firstBuf = this.buffer;
        if (firstBuf == null) {
            return null;
        }
        ArrayDeque<ByteBuf> others = this.otherBuffers;
        if (others == null || others.isEmpty()) {
            this.size = 0;
            this.buffer = null;
            return firstBuf;
        }
        return this.clearBuffers();
    }

    private CompositeByteBuf clearBuffers() {
        ByteBuf firstBuf = this.buffer;
        ArrayDeque<ByteBuf> others = this.otherBuffers;
        CompositeByteBuf batch = this.allocator.compositeDirectBuffer(1 + others.size());
        try {
            this.buffer = null;
            this.size = 0;
            batch.addComponent(true, 0, firstBuf);
            int othersCount = others.size();
            for (int i = 0; i < othersCount; ++i) {
                batch.addComponent(true, 1 + i, others.poll());
            }
            return batch;
        }
        catch (Throwable anyError) {
            batch.release();
            AppendBuffer.releaseOthers(others);
            throw anyError;
        }
    }

    private static void releaseOthers(ArrayDeque<ByteBuf> others) {
        ByteBuf buf;
        while ((buf = others.poll()) != null) {
            buf.release();
        }
    }

    public int capacity() {
        return this.capacity;
    }

    public int availableCapacity() {
        return this.capacity - this.size;
    }
}

