/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven.components;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.Restriction;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=MavenVersionEnforcer.class, instantiationStrategy="per-lookup")
public class MavenVersionEnforcer {
    public void ensureMavenVersion(Log log, MavenSession session) throws MojoExecutionException {
        String supported;
        try {
            supported = MavenVersionEnforcer.getSupportedMavenVersions();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to ensure Quarkus Maven version compatibility", (Exception)e);
        }
        String mavenVersion = session.getSystemProperties().getProperty("maven.version");
        if (log.isDebugEnabled()) {
            log.debug((CharSequence)("Detected Maven Version: " + mavenVersion));
        }
        DefaultArtifactVersion detectedVersion = new DefaultArtifactVersion(mavenVersion);
        this.enforce(log, supported, (ArtifactVersion)detectedVersion);
    }

    private static String getSupportedMavenVersions() throws IOException {
        return MavenVersionEnforcer.loadQuarkusProperties().getProperty("supported-maven-versions");
    }

    private static Properties loadQuarkusProperties() throws IOException {
        String resource = "quarkus.properties";
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("quarkus.properties");
        if (is == null) {
            throw new IOException("Could not locate quarkus.properties on the classpath");
        }
        Properties props = new Properties();
        try {
            props.load(is);
        }
        catch (IOException e) {
            throw new IOException("Failed to load quarkus.properties from the classpath", e);
        }
        return props;
    }

    private void enforce(Log log, String requiredMavenVersionRange, ArtifactVersion actualMavenVersion) throws MojoExecutionException {
        if (StringUtils.isBlank((CharSequence)requiredMavenVersionRange)) {
            throw new MojoExecutionException("Maven version can't be empty.");
        }
        if (!actualMavenVersion.toString().equals(requiredMavenVersionRange)) {
            try {
                VersionRange vr = VersionRange.createFromVersionSpec((String)requiredMavenVersionRange);
                if (!MavenVersionEnforcer.containsVersion(vr, actualMavenVersion)) {
                    throw new MojoExecutionException(MavenVersionEnforcer.getDetectedVersionStr(actualMavenVersion.toString()) + " is not supported, it must be in " + vr + ".");
                }
            }
            catch (InvalidVersionSpecificationException e) {
                throw new MojoExecutionException("The requested Maven version " + requiredMavenVersionRange + " is invalid.", (Exception)((Object)e));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((CharSequence)(MavenVersionEnforcer.getDetectedVersionStr(actualMavenVersion.toString()) + " is allowed in " + requiredMavenVersionRange + "."));
        }
    }

    private static boolean containsVersion(VersionRange allowedRange, ArtifactVersion theVersion) {
        boolean matched = false;
        ArtifactVersion recommendedVersion = allowedRange.getRecommendedVersion();
        if (recommendedVersion == null) {
            List restrictions = allowedRange.getRestrictions();
            for (Restriction restriction : restrictions) {
                if (!restriction.containsVersion(theVersion)) continue;
                matched = true;
                break;
            }
        } else {
            int compareTo = recommendedVersion.compareTo((Object)theVersion);
            matched = compareTo <= 0;
        }
        return matched;
    }

    private static String getDetectedVersionStr(String version) {
        return "Detected Maven Version (" + version + ") ";
    }
}

