/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.project.update.rewrite.operations;

import io.quarkus.devtools.project.BuildTool;
import io.quarkus.devtools.project.update.rewrite.RewriteOperation;
import java.util.Map;

public class UpdatePropertyOperation
implements RewriteOperation {
    private final String key;
    private final String newValue;

    public UpdatePropertyOperation(String key, String newValue) {
        this.key = key;
        this.newValue = newValue;
    }

    @Override
    public Map<String, Object> single(BuildTool buildTool) {
        switch (buildTool) {
            case MAVEN: {
                return Map.of("org.openrewrite.maven.ChangePropertyValue", Map.of("key", this.key, "newValue", this.newValue));
            }
            case GRADLE: {
                return Map.of("org.openrewrite.gradle.AddProperty", Map.of("key", this.key, "value", this.newValue, "overwrite", true));
            }
        }
        return Map.of();
    }
}

