/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.auth;

import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.Status;
import io.quarkus.grpc.ExceptionHandler;
import io.quarkus.security.AuthenticationFailedException;
import jakarta.enterprise.inject.spi.Prioritized;

public class AuthExceptionHandler<ReqT, RespT>
extends ExceptionHandler<ReqT, RespT>
implements Prioritized {
    public AuthExceptionHandler(ServerCall.Listener<ReqT> listener, ServerCall<ReqT, RespT> serverCall, Metadata metadata) {
        super(listener, serverCall, metadata);
    }

    protected void handleException(Throwable exception, ServerCall<ReqT, RespT> serverCall, Metadata metadata) {
        if (exception instanceof AuthenticationFailedException) {
            serverCall.close(Status.UNAUTHENTICATED.withDescription(exception.getMessage()), metadata);
        } else if (exception instanceof SecurityException) {
            serverCall.close(Status.PERMISSION_DENIED.withDescription(exception.getMessage()), metadata);
        } else {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new RuntimeException(exception);
        }
    }

    public int getPriority() {
        return 0;
    }
}

