/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.runtime.devmode;

import io.quarkus.dev.spi.HotReplacementContext;
import io.quarkus.dev.spi.HotReplacementSetup;
import io.quarkus.grpc.runtime.devmode.GrpcHotReplacementInterceptor;
import io.quarkus.grpc.runtime.devmode.GrpcServerReloader;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

public class GrpcHotReplacementSetup
implements HotReplacementSetup {
    private static final Logger LOGGER = Logger.getLogger((String)GrpcHotReplacementSetup.class.getName());
    private HotReplacementContext context;
    private static final long TWO_SECONDS = 2000L;
    private volatile long nextUpdate;

    public void setupHotDeployment(HotReplacementContext context) {
        this.context = context;
        GrpcHotReplacementInterceptor.register(new RestartHandler());
    }

    public void handleFailedInitialStart() {
        this.close();
    }

    public void close() {
        GrpcServerReloader.shutdown();
    }

    private class RestartHandler
    implements Supplier<Boolean> {
        private RestartHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean get() {
            boolean restarted = false;
            RestartHandler restartHandler = this;
            synchronized (restartHandler) {
                if (GrpcHotReplacementSetup.this.nextUpdate < System.currentTimeMillis() || GrpcHotReplacementSetup.this.context.isTest()) {
                    try {
                        restarted = GrpcHotReplacementSetup.this.context.doScan(true);
                        if (GrpcHotReplacementSetup.this.context.getDeploymentProblem() != null) {
                            LOGGER.error((Object)"Failed to redeploy application on changes", GrpcHotReplacementSetup.this.context.getDeploymentProblem());
                        }
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    GrpcHotReplacementSetup.this.nextUpdate = System.currentTimeMillis() + 2000L;
                }
            }
            return restarted;
        }
    }
}

