/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.hibernate.orm.deployment.ClassNames;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

public final class HibernateUserTypeProcessor {
    private static final String TYPE_VALUE = "type";
    private static final String TYPE_CLASS_VALUE = "typeClass";

    @BuildStep
    public void build(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, CombinedIndexBuildItem combinedIndexBuildItem) {
        IndexView index = combinedIndexBuildItem.getIndex();
        HashSet<String> userTypes = new HashSet<String>();
        Collection typeAnnotationInstances = index.getAnnotations(ClassNames.TYPE);
        Collection typeDefinitionAnnotationInstances = index.getAnnotations(ClassNames.TYPE_DEFINITION);
        Collection typeDefinitionsAnnotationInstances = index.getAnnotations(ClassNames.TYPE_DEFINITIONS);
        userTypes.addAll(this.getUserTypes(typeDefinitionAnnotationInstances));
        for (AnnotationInstance typeDefinitionAnnotationInstance : typeDefinitionsAnnotationInstances) {
            AnnotationValue typeDefinitionsAnnotationValue = typeDefinitionAnnotationInstance.value();
            if (typeDefinitionsAnnotationValue == null) continue;
            userTypes.addAll(this.getUserTypes(Arrays.asList(typeDefinitionsAnnotationValue.asNestedArray())));
        }
        for (AnnotationInstance typeAnnotationInstance : typeAnnotationInstances) {
            String type;
            DotName className;
            AnnotationValue typeValue = typeAnnotationInstance.value(TYPE_VALUE);
            if (typeValue == null || index.getClassByName(className = DotName.createSimple((String)(type = typeValue.asString()))) == null) continue;
            userTypes.add(type);
        }
        if (!userTypes.isEmpty()) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, userTypes.toArray(new String[0])));
        }
    }

    private Set<String> getUserTypes(Collection<AnnotationInstance> typeDefinitionAnnotationInstances) {
        HashSet<String> userTypes = new HashSet<String>();
        for (AnnotationInstance typeDefAnnotationInstance : typeDefinitionAnnotationInstances) {
            AnnotationValue typeClassValue = typeDefAnnotationInstance.value(TYPE_CLASS_VALUE);
            if (typeClassValue == null) continue;
            String typeClass = typeClassValue.asClass().name().toString();
            userTypes.add(typeClass);
        }
        return userTypes;
    }
}

